/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritJsonEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeMerged;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.DraftPublished;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.RefUpdated;
import java.util.LinkedList;

public enum GerritEventType {
    PATCHSET_CREATED("patchset-created", true, PatchsetCreated.class),
    DRAFT_PUBLISHED("draft-published", true, DraftPublished.class),
    CHANGE_ABANDONED("change-abandoned", true, ChangeAbandoned.class),
    CHANGE_MERGED("change-merged", true, ChangeMerged.class),
    COMMENT_ADDED("comment-added", true, CommentAdded.class),
    REF_UPDATED("ref-updated", true, RefUpdated.class);

    private String typeValue;
    private boolean interesting;
    private Class<? extends GerritJsonEvent> eventRepresentative;

    private GerritEventType(String typeValue, boolean interesting, Class<? extends GerritJsonEvent> eventRepresentative) {
        this.typeValue = typeValue;
        this.interesting = interesting;
        this.eventRepresentative = eventRepresentative;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public boolean isInteresting() {
        return this.interesting;
    }

    public Class<? extends GerritJsonEvent> getEventRepresentative() {
        return this.eventRepresentative;
    }

    public static GerritEventType findByTypeValue(String typeValue) {
        for (GerritEventType type : GerritEventType.values()) {
            if (!type.getTypeValue().equalsIgnoreCase(typeValue)) continue;
            return type;
        }
        return null;
    }

    public static GerritEventType[] getInterestingEventTypes() {
        LinkedList<GerritEventType> list = new LinkedList<GerritEventType>();
        for (GerritEventType type : GerritEventType.values()) {
            if (!type.isInteresting()) continue;
            list.add(type);
        }
        return list.toArray(new GerritEventType[list.size()]);
    }
}

