/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritQueryException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritQueryHandler;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr.Change;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeBasedEvent
extends GerritTriggeredEvent {
    private static final Logger logger = LoggerFactory.getLogger(ChangeBasedEvent.class);
    protected Change change;
    protected PatchSet patchSet;
    private List<String> files;

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
    }

    public List<String> getFiles(GerritQueryHandler gerritQueryHandler) {
        if (this.files == null) {
            this.files = new LinkedList<String>();
            try {
                List<JSONObject> jsonList = gerritQueryHandler.queryFiles("change:" + this.getChange().getId());
                for (JSONObject json : jsonList) {
                    JSONObject currentPatchSet;
                    if (json.has("type") && "stats".equalsIgnoreCase(json.getString("type")) || !json.has("currentPatchSet") || !(currentPatchSet = json.getJSONObject("currentPatchSet")).has("files")) continue;
                    JSONArray changedFiles = currentPatchSet.optJSONArray("files");
                    for (int i = 0; i < changedFiles.size(); ++i) {
                        JSONObject file = changedFiles.getJSONObject(i);
                        this.files.add(file.getString("file"));
                    }
                }
            }
            catch (IOException e) {
                logger.error("IOException occured. ", (Throwable)e);
            }
            catch (GerritQueryException e) {
                logger.error("Bad query. ", (Throwable)e);
            }
        }
        return this.files;
    }

    public PatchSet getPatchSet() {
        return this.patchSet;
    }

    public void setPatchset(PatchSet patchset) {
        this.patchSet = patchset;
    }

    public void fromJson(JSONObject json) {
        if (json.containsKey((Object)"change")) {
            this.change = new Change(json.getJSONObject("change"));
        }
        if (json.containsKey((Object)"patchSet")) {
            this.patchSet = new PatchSet(json.getJSONObject("patchSet"));
        } else if (json.containsKey((Object)"patchset")) {
            this.patchSet = new PatchSet(json.getJSONObject("patchset"));
        }
    }

    public int hashCode() {
        int result = 0;
        if (this.getEventType() != null) {
            result = this.getEventType().hashCode() * 31;
        }
        if (this.change != null) {
            result += this.change.hashCode();
        }
        result *= 31;
        if (this.patchSet != null) {
            result += this.patchSet.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        ChangeBasedEvent event = (ChangeBasedEvent)o;
        if (this.getEventType() == null ? event.getEventType() != null : !this.getEventType().equals((Object)event.getEventType())) {
            return false;
        }
        if (this.getChange() == null ? event.getChange() != null : !this.getChange().equals(event.getChange())) {
            return false;
        }
        return !(this.getPatchSet() == null ? event.getPatchSet() != null : !this.getPatchSet().equals(event.getPatchSet()));
    }
}

