/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.cmd;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritCmdRunner;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendCommandJob
implements Runnable,
GerritCmdRunner {
    protected static Logger logger = LoggerFactory.getLogger(AbstractSendCommandJob.class);
    private GerritConnectionConfig config;

    protected AbstractSendCommandJob(GerritConnectionConfig config) {
        this.config = config;
    }

    public GerritConnectionConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean sendCommand(String command) {
        try {
            SshConnection ssh = SshConnectionFactory.getConnection(this.config.getGerritHostName(), this.config.getGerritSshPort(), this.config.getGerritAuthentication());
            ssh.executeCommand(command);
            ssh.disconnect();
            return true;
        }
        catch (Exception ex) {
            logger.error("Could not run command " + command, (Throwable)ex);
            return false;
        }
    }

    @Override
    public String sendCommandStr(String command) {
        try {
            SshConnection ssh = SshConnectionFactory.getConnection(this.config.getGerritHostName(), this.config.getGerritSshPort(), this.config.getGerritAuthentication());
            String str = ssh.executeCommand(command);
            ssh.disconnect();
            return str;
        }
        catch (Exception ex) {
            logger.error("Could not run command " + command, (Throwable)ex);
            return null;
        }
    }
}

