/*
 * Decompiled with CFR 0.152.
 */
package com.g2one.hudson.grails;

import com.g2one.hudson.grails.GrailsInstallation;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.UnflaggedOption;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsBuilder
extends Builder {
    private final String targets;
    private final String name;
    private String grailsWorkDir;
    private String projectWorkDir;
    private String projectBaseDir;
    private String serverPort;
    private String properties;
    private Boolean forceUpgrade;
    private Boolean nonInteractive;
    private Boolean useWrapper;
    private Boolean plainOutput;
    private Boolean stackTrace;
    private Boolean verbose;
    private Boolean refreshDependencies;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public GrailsBuilder(String targets, String name, String grailsWorkDir, String projectWorkDir, String projectBaseDir, String serverPort, String properties, Boolean forceUpgrade, Boolean nonInteractive, Boolean useWrapper, Boolean plainOutput, Boolean stackTrace, Boolean verbose, Boolean refreshDependencies) {
        this.name = name;
        this.targets = targets;
        this.grailsWorkDir = grailsWorkDir;
        this.projectWorkDir = projectWorkDir;
        this.projectBaseDir = projectBaseDir;
        this.serverPort = serverPort;
        this.properties = properties;
        this.forceUpgrade = forceUpgrade;
        this.nonInteractive = nonInteractive;
        this.useWrapper = useWrapper == false;
        this.plainOutput = plainOutput;
        this.stackTrace = stackTrace;
        this.verbose = verbose;
        this.refreshDependencies = refreshDependencies;
    }

    public boolean getNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(Boolean b) {
        this.nonInteractive = b;
    }

    public boolean getForceUpgrade() {
        return this.forceUpgrade;
    }

    public void setForceUpgrade(Boolean b) {
        this.forceUpgrade = b;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProjectBaseDir() {
        return this.projectBaseDir;
    }

    public void setProjectBaseDir(String projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    public String getProjectWorkDir() {
        return this.projectWorkDir;
    }

    public void setProjectWorkDir(String projectWorkDir) {
        this.projectWorkDir = projectWorkDir;
    }

    public String getGrailsWorkDir() {
        return this.grailsWorkDir;
    }

    public void setGrailsWorkDir(String grailsWorkDir) {
        this.grailsWorkDir = grailsWorkDir;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getName() {
        return this.name;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setUseWrapper(Boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    public Boolean getUseWrapper() {
        return this.useWrapper;
    }

    public Boolean getPlainOutput() {
        return this.plainOutput;
    }

    public void setPlainOutput(Boolean plainOutput) {
        this.plainOutput = plainOutput;
    }

    public Boolean getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(Boolean stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public Boolean getRefreshDependencies() {
        return this.refreshDependencies;
    }

    public void setRefreshDependencies(Boolean refreshDependencies) {
        this.refreshDependencies = refreshDependencies;
    }

    public GrailsInstallation getGrails() {
        GrailsInstallation[] installations;
        for (GrailsInstallation i : installations = ((GrailsInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GrailsInstallation.DescriptorImpl.class)).getInstallations()) {
            if (this.name == null || !i.getName().equals(this.name)) continue;
            return i;
        }
        return null;
    }

    private Object readResolve() {
        if (this.nonInteractive == null) {
            this.nonInteractive = Boolean.FALSE;
        }
        if (this.useWrapper == null) {
            this.useWrapper = Boolean.FALSE;
        }
        return this;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.readResolve();
        List<String[]> targetsToRun = this.getTargetsToRun();
        if (targetsToRun.size() > 0) {
            GrailsInstallation grailsInstallation;
            String execName;
            if (this.useWrapper.booleanValue()) {
                FilePath wrapper = new FilePath(this.getBasePath(build), launcher.isUnix() ? "grailsw" : "grailsw.bat");
                execName = wrapper.getRemote();
            } else {
                execName = launcher.isUnix() ? "grails" : "grails.bat";
            }
            EnvVars env = build.getEnvironment((TaskListener)listener);
            GrailsInstallation grailsInstallation2 = grailsInstallation = this.useWrapper != false ? null : this.getGrails();
            if (grailsInstallation != null) {
                grailsInstallation = grailsInstallation.forEnvironment(env).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
                env.put("GRAILS_HOME", grailsInstallation.getHome());
            }
            for (String[] targetsAndArgs : targetsToRun) {
                String target = targetsAndArgs[0];
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (grailsInstallation == null) {
                    args.add(execName);
                } else {
                    File exec = grailsInstallation.getExecutable();
                    if (!new FilePath(launcher.getChannel(), grailsInstallation.getExecutable().getPath()).exists()) {
                        listener.fatalError(exec + " doesn't exist");
                        return false;
                    }
                    args.add(exec.getPath());
                }
                args.addKeyValuePairs("-D", build.getBuildVariables());
                HashMap<String, String> systemProperties = new HashMap<String, String>();
                if (this.grailsWorkDir != null && !"".equals(this.grailsWorkDir.trim())) {
                    systemProperties.put("grails.work.dir", GrailsBuilder.evalTarget((Map<String, String>)env, this.grailsWorkDir.trim()));
                }
                if (this.projectWorkDir != null && !"".equals(this.projectWorkDir.trim())) {
                    systemProperties.put("grails.project.work.dir", GrailsBuilder.evalTarget((Map<String, String>)env, this.projectWorkDir.trim()));
                }
                if (this.serverPort != null && !"".equals(this.serverPort.trim())) {
                    systemProperties.put("server.port", GrailsBuilder.evalTarget((Map<String, String>)env, this.serverPort.trim()));
                }
                if (systemProperties.size() > 0) {
                    args.addKeyValuePairs("-D", systemProperties);
                }
                args.addKeyValuePairsFromPropertyString("-D", this.properties, build.getBuildVariableResolver());
                args.add(target);
                this.addArgument("--non-interactive", this.nonInteractive, args, env, targetsAndArgs);
                this.addArgument("--plain-output", this.plainOutput, args, env, targetsAndArgs);
                this.addArgument("--stacktrace", this.stackTrace, args, env, targetsAndArgs);
                this.addArgument("--verbose", this.verbose, args, env, targetsAndArgs);
                this.addArgument("--refresh-dependencies", this.refreshDependencies, args, env, targetsAndArgs);
                if (!launcher.isUnix()) {
                    args.prepend(new String[]{"cmd.exe", "/C"});
                    args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
                }
                try {
                    int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(this.getBasePath(build)).join();
                    if (r == 0) continue;
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("command execution failed"));
                    return false;
                }
            }
        } else {
            listener.getLogger().println("Error: No Targets To Run!");
            return false;
        }
        return true;
    }

    protected void addArgument(String option, Boolean optionEnabled, ArgumentListBuilder args, EnvVars env, String[] targetsAndArgs) {
        boolean foundArgument = false;
        for (int i = 1; i < targetsAndArgs.length; ++i) {
            String arg = GrailsBuilder.evalTarget((Map<String, String>)env, targetsAndArgs[i]);
            if (option.equals(arg)) {
                foundArgument = true;
            }
            if (args.toList().contains(arg)) continue;
            args.add(arg);
        }
        if (optionEnabled != null && optionEnabled.booleanValue() && !foundArgument) {
            args.add(option);
        }
    }

    private FilePath getBasePath(AbstractBuild<?, ?> build) {
        FilePath moduleRoot = build.getModuleRoot();
        FilePath basePath = this.projectBaseDir != null && !"".equals(this.projectBaseDir.trim()) ? new FilePath(moduleRoot, this.projectBaseDir) : moduleRoot;
        return basePath;
    }

    static String evalTarget(Map<String, String> env, String target) {
        Binding binding = new Binding();
        binding.setVariable("env", env);
        binding.setVariable("sys", (Object)System.getProperties());
        GroovyShell shell = new GroovyShell(binding);
        Object result = shell.evaluate("return \"" + target + "\"");
        if (result == null) {
            return target;
        }
        return result.toString().trim();
    }

    protected List<String[]> getTargetsToRun() {
        ArrayList<String[]> targetsToRun = new ArrayList<String[]>();
        if (this.forceUpgrade.booleanValue()) {
            targetsToRun.add(new String[]{"upgrade", "--non-interactive"});
        }
        if (this.targets != null && this.targets.length() > 0) {
            try {
                String[] targets;
                JSAP jsap = new JSAP();
                UnflaggedOption option = new UnflaggedOption("targets");
                option.setGreedy(true);
                jsap.registerParameter((Parameter)option);
                JSAPResult jsapResult = jsap.parse(this.targets);
                for (String targetAndArgs : targets = jsapResult.getStringArray("targets")) {
                    String[] pieces = targetAndArgs.split(" ");
                    targetsToRun.add(pieces);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return targetsToRun;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public String getDisplayName() {
            return "Build With Grails";
        }

        public synchronized void load() {
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(this.clazz, formData);
        }

        public GrailsInstallation[] getInstallations() {
            return ((GrailsInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GrailsInstallation.DescriptorImpl.class)).getInstallations();
        }
    }
}

