/*
 * Decompiled with CFR 0.152.
 */
package com.g2one.hudson.grails;

import com.g2one.hudson.grails.GrailsBuilder;
import com.g2one.hudson.grails.GrailsInstaller;
import com.thoughtworks.xstream.XStream;
import hudson.EnvVars;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsInstallation
extends ToolInstallation
implements EnvironmentSpecific<GrailsInstallation>,
NodeSpecific<GrailsInstallation> {
    public transient String grailsHome;

    @DataBoundConstructor
    public GrailsInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public File getExecutable() {
        String execName = File.separatorChar == '\\' ? "grails.bat" : "grails";
        return new File(this.getHome(), "bin/" + execName);
    }

    public boolean getExists() {
        return this.getExecutable().exists();
    }

    public GrailsInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GrailsInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public GrailsInstallation forEnvironment(EnvVars environment) {
        return new GrailsInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<GrailsInstallation> {
        private static final Logger LOGGER = Logger.getLogger(Descriptor.class.getName());
        private volatile GrailsInstallation[] installations = new GrailsInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public synchronized void load() {
            File root = Hudson.getInstance().root;
            if (new File(root, GrailsInstallation.class.getName() + ".xml").exists()) {
                super.load();
            } else if (new File(root, GrailsBuilder.class.getName() + ".xml").exists()) {
                this.loadFromOldConfigFile();
            }
        }

        private void loadFromOldConfigFile() {
            XStream2 stream = new XStream2();
            stream.alias(GrailsBuilder.DescriptorImpl.class.getName(), DescriptorImpl.class);
            XmlFile file = new XmlFile((XStream)stream, new File(Hudson.getInstance().root, GrailsBuilder.class.getName() + ".xml"));
            try {
                file.unmarshal((Object)this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + file, e);
            }
            for (int i = 0; i < this.installations.length; ++i) {
                GrailsInstallation inst = this.installations[i];
                this.installations[i] = new GrailsInstallation(inst.getName(), inst.grailsHome, null);
            }
        }

        public String getDisplayName() {
            return "Grails";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new GrailsInstaller(null));
        }

        public GrailsInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(GrailsInstallation ... installations) {
            this.installations = installations;
            this.save();
        }
    }
}

