/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.greenballs;

import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.greenballs.ColorBlindProperty;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GreenBallFilter
implements Filter {
    final String patternStr = "/(\\d{2}x\\d{2})/%s(_anime|)\\.(gif|png)";
    final Pattern patternBlue = Pattern.compile(String.format("/(\\d{2}x\\d{2})/%s(_anime|)\\.(gif|png)", "blue"));
    final Pattern patternRed = Pattern.compile(String.format("/(\\d{2}x\\d{2})/%s(_anime|)\\.(gif|png)", "red"));
    final Pattern patternYellow = Pattern.compile(String.format("/(\\d{2}x\\d{2})/%s(_anime|)\\.(gif|png)", "yellow"));
    final Logger logger = Logger.getLogger("hudson.plugins.greenballs");

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            String newImageUrl;
            HttpServletRequest httpServletRequest = (HttpServletRequest)req;
            HttpServletResponse httpServletResponse = (HttpServletResponse)resp;
            String uri = httpServletRequest.getRequestURI();
            if ((uri.endsWith(".gif") || uri.endsWith(".png")) && (newImageUrl = this.mapImage(uri)) != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Redirecting {0} to {1}", new Object[]{uri, newImageUrl});
                }
                RequestDispatcher dispatcher = httpServletRequest.getRequestDispatcher(newImageUrl);
                dispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    private String mapImage(String uri) {
        ColorBlindProperty colorBlindProperty;
        User user = Hudson.getInstance().getUser(Hudson.getAuthentication().getName());
        if (user != null && (colorBlindProperty = (ColorBlindProperty)user.getProperty(ColorBlindProperty.class)) != null && colorBlindProperty.isEnabledColorBlindSupport()) {
            Matcher m = this.patternBlue.matcher(uri);
            if (m.find()) {
                return "/plugin/greenballs/colorblind/" + m.group(1) + "/green" + m.group(2) + ".gif";
            }
            m = this.patternRed.matcher(uri);
            if (m.find()) {
                return "/plugin/greenballs/colorblind/" + m.group(1) + "/red" + m.group(2) + ".gif";
            }
            m = this.patternYellow.matcher(uri);
            if (m.find()) {
                return "/plugin/greenballs/colorblind/" + m.group(1) + "/yellow" + m.group(2) + ".gif";
            }
            return null;
        }
        Matcher m = this.patternBlue.matcher(uri);
        if (m.find()) {
            return "/plugin/greenballs/" + m.group(1) + "/green" + m.group(2) + "." + m.group(3);
        }
        return null;
    }

    public void destroy() {
    }
}

