/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.greenballs;

import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.plugins.greenballs.GreenBallFilter;
import hudson.util.ColorPalette;
import hudson.util.PluginServletFilter;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PluginImpl
extends Plugin {
    transient PluginWrapper wrapper;
    final transient Logger logger = Logger.getLogger("hudson.plugins.greenballs");

    public void start() throws Exception {
        super.start();
        this.load();
        PluginServletFilter.addFilter((Filter)new GreenBallFilter());
        try {
            this.wrapper = null;
            Field wrapperField = Plugin.class.getDeclaredField("wrapper");
            wrapperField.setAccessible(true);
            this.wrapper = (PluginWrapper)wrapperField.get(this);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Unable to access plugin wrapper", e);
        }
        try {
            Field colorValue = Color.class.getDeclaredField("value");
            colorValue.setAccessible(true);
            colorValue.setInt(ColorPalette.BLUE, new Color(172, 218, 0).getRGB());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Unable to change BLUE ColorPalette", e);
        }
        this.logger.log(Level.INFO, "Green Balls!");
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        rsp.setHeader("Cache-Control", "public, s-maxage=86400");
        if (this.wrapper == null) {
            super.doDynamic(req, rsp);
            return;
        }
        String path = req.getRestOfPath();
        if (path.length() == 0) {
            path = "/";
        }
        if (path.indexOf("..") != -1 || path.length() < 1) {
            rsp.sendError(400);
            return;
        }
        this.logger.log(Level.FINE, "Serving cached resource {0}", path);
        rsp.serveLocalizedFile(req, new URL(this.wrapper.baseResourceURL, '.' + path), 86400000L);
    }
}

