/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import htmlpublisher.HtmlPublisherTarget;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class HtmlPublisher
extends Recorder {
    private final ArrayList<HtmlPublisherTarget> reportTargets;

    @DataBoundConstructor
    public HtmlPublisher(List<HtmlPublisherTarget> reportTargets) {
        this.reportTargets = new ArrayList<HtmlPublisherTarget>(reportTargets);
    }

    public ArrayList<HtmlPublisherTarget> getReportTargets() {
        return this.reportTargets;
    }

    private static void writeFile(ArrayList<String> lines, File path) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(path));
        for (int i = 0; i < lines.size(); ++i) {
            bw.write(lines.get(i));
            bw.newLine();
        }
        bw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> readFile(String filePath) throws FileNotFoundException, IOException {
        ArrayList<String> aList = new ArrayList<String>();
        try {
            InputStream is = this.getClass().getResourceAsStream(filePath);
            try {
                InputStreamReader r = new InputStreamReader(is);
                try {
                    BufferedReader br = new BufferedReader(r);
                    try {
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            aList.add(line);
                        }
                        br.close();
                        ((Reader)r).close();
                        is.close();
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        ((Reader)r).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aList;
    }

    protected static String resolveParametersInString(AbstractBuild<?, ?> build, BuildListener listener, String input) {
        try {
            return build.getEnvironment((TaskListener)listener).expand(input);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            return input;
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        ArrayList footerLines;
        ArrayList headerLines;
        listener.getLogger().println("[htmlpublisher] Archiving HTML reports...");
        try {
            headerLines = this.readFile("/htmlpublisher/HtmlPublisher/header.html");
            footerLines = this.readFile("/htmlpublisher/HtmlPublisher/footer.html");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        for (int i = 0; i < this.reportTargets.size(); ++i) {
            ArrayList<String> reportLines = new ArrayList<String>(headerLines);
            HtmlPublisherTarget reportTarget = (HtmlPublisherTarget)this.reportTargets.get(i);
            boolean keepAll = reportTarget.getKeepAll();
            FilePath archiveDir = build.getWorkspace().child(HtmlPublisher.resolveParametersInString(build, (BuildListener)listener, (String)reportTarget.getReportDir()));
            FilePath targetDir = reportTarget.getArchiveTarget(build);
            String levelString = keepAll ? "BUILD" : "PROJECT";
            listener.getLogger().println("[htmlpublisher] Archiving at " + levelString + " level " + archiveDir + " to " + targetDir);
            String[] csvReports = HtmlPublisher.resolveParametersInString(build, (BuildListener)listener, (String)reportTarget.getReportFiles()).split(",");
            ArrayList<String> reports = new ArrayList<String>();
            for (int j = 0; j < csvReports.length; ++j) {
                String report = csvReports[j];
                if ((report = report.trim()).equals("")) continue;
                reports.add(report);
                String tabNo = "tab" + (j + 1);
                int end = report.lastIndexOf(".");
                String reportName = end > 0 ? report.substring(0, end) : report;
                String tabItem = "<li id=\"" + tabNo + "\" class=\"unselected\" onclick=\"updateBody('" + tabNo + "');\" value=\"" + report + "\">" + reportName + "</li>";
                reportLines.add(tabItem);
            }
            String hudsonUrl = Hudson.getInstance().getRootUrl();
            AbstractProject job = build.getProject();
            reportLines.add("<script type=\"text/javascript\">document.getElementById(\"hudson_link\").innerHTML=\"Back to " + job.getName() + "\";</script>");
            if (hudsonUrl == null) {
                reportLines.add("<script type=\"text/javascript\">document.getElementById(\"hudson_link\").onclick = function() { history.go(-1); return false; };</script>");
            } else {
                String jobUrl = hudsonUrl + job.getUrl();
                reportLines.add("<script type=\"text/javascript\">document.getElementById(\"hudson_link\").href=\"" + jobUrl + "\";</script>");
            }
            reportLines.add("<script type=\"text/javascript\">document.getElementById(\"zip_link\").href=\"*zip*/" + reportTarget.getSanitizedName() + ".zip\";</script>");
            try {
                if (!archiveDir.exists()) {
                    listener.error("Specified HTML directory '" + archiveDir + "' does not exist.");
                    build.setResult(Result.FAILURE);
                    return true;
                }
                if (!keepAll) {
                    targetDir.deleteRecursive();
                }
                if (archiveDir.copyRecursiveTo("**/*", targetDir) == 0) {
                    listener.error("Directory '" + archiveDir + "' exists but failed copying to '" + targetDir + "'.");
                    if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                        listener.error("This is especially strange since your build otherwise succeeded.");
                    }
                    build.setResult(Result.FAILURE);
                    return true;
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("HTML Publisher failure"));
                build.setResult(Result.FAILURE);
                return true;
            }
            reportTarget.handleAction(build);
            reportLines.addAll(footerLines);
            try {
                HtmlPublisher.writeFile(reportLines, (File)new File(targetDir.getRemote(), reportTarget.getWrapperName()));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        if (this.reportTargets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (HtmlPublisherTarget target : this.reportTargets) {
            actions.add(target.getProjectAction(project));
            if (!(project instanceof MatrixProject) || ((MatrixProject)project).getActiveConfigurations() == null) continue;
            for (MatrixConfiguration mc : ((MatrixProject)project).getActiveConfigurations()) {
                try {
                    mc.onLoad((ItemGroup)mc.getParent(), mc.getName());
                }
                catch (IOException e) {}
            }
        }
        return actions;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

