/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPublisherTarget
extends AbstractDescribableImpl<HtmlPublisherTarget> {
    private final String reportName;
    private final String reportDir;
    private final String reportFiles;
    private final boolean keepAll;
    private final boolean allowMissing;
    private final String wrapperName = "htmlpublisher-wrapper.html";

    @DataBoundConstructor
    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, boolean keepAll, boolean allowMissing) {
        this.reportName = reportName;
        this.reportDir = reportDir;
        this.reportFiles = reportFiles;
        this.keepAll = keepAll;
        this.allowMissing = allowMissing;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getReportFiles() {
        return this.reportFiles;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    public boolean getAllowMissing() {
        return this.allowMissing;
    }

    public String getSanitizedName() {
        String safeName = this.reportName;
        safeName = safeName.replace(" ", "_");
        return safeName;
    }

    public String getWrapperName() {
        return this.wrapperName;
    }

    public FilePath getArchiveTarget(AbstractBuild build) {
        return new FilePath(this.keepAll ? this.getBuildArchiveDir((Run)build) : this.getProjectArchiveDir((AbstractItem)build.getProject()));
    }

    private File getProjectArchiveDir(AbstractItem project) {
        return new File(new File(project.getRootDir(), "htmlreports"), this.getSanitizedName());
    }

    private File getBuildArchiveDir(Run run) {
        return new File(new File(run.getRootDir(), "htmlreports"), this.getSanitizedName());
    }

    public void handleAction(AbstractBuild<?, ?> build) {
        if (this.keepAll) {
            build.addAction((Action)new HTMLBuildAction(build, this));
        }
    }

    public Action getProjectAction(AbstractProject project) {
        return new HTMLAction((AbstractItem)project, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<HtmlPublisherTarget> {
        public String getDisplayName() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HTMLBuildAction
    extends BaseHTMLAction {
        private final AbstractBuild<?, ?> build;

        public HTMLBuildAction(AbstractBuild<?, ?> build, HtmlPublisherTarget actualHtmlPublisherTarget) {
            super(actualHtmlPublisherTarget);
            this.build = build;
        }

        public final AbstractBuild<?, ?> getOwner() {
            return this.build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " html3";
        }

        @Override
        protected File dir() {
            return HtmlPublisherTarget.this.getBuildArchiveDir(this.build);
        }
    }

    public class HTMLAction
    extends BaseHTMLAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public HTMLAction(AbstractItem project, HtmlPublisherTarget actualHtmlPublisherTarget) {
            super(actualHtmlPublisherTarget);
            this.project = project;
        }

        protected File dir() {
            File javadocDir;
            AbstractProject abstractProject;
            Run run;
            if (this.project instanceof AbstractProject && (run = (abstractProject = (AbstractProject)this.project).getLastSuccessfulBuild()) != null && (javadocDir = HtmlPublisherTarget.this.getBuildArchiveDir(run)).exists()) {
                return javadocDir;
            }
            return HtmlPublisherTarget.this.getProjectArchiveDir(this.project);
        }

        protected String getTitle() {
            return this.project.getDisplayName() + " html2";
        }
    }

    protected abstract class BaseHTMLAction
    implements Action {
        private HtmlPublisherTarget actualHtmlPublisherTarget;

        public BaseHTMLAction(HtmlPublisherTarget actualHtmlPublisherTarget) {
            this.actualHtmlPublisherTarget = actualHtmlPublisherTarget;
        }

        public String getUrlName() {
            return this.actualHtmlPublisherTarget.getSanitizedName();
        }

        public String getDisplayName() {
            String action = this.actualHtmlPublisherTarget.reportName;
            return this.dir().exists() ? action : null;
        }

        public String getIconFileName() {
            return this.dir().exists() ? "graph.gif" : null;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.dir()), this.getTitle(), "graph.gif", false);
            dbs.setIndexFileName("htmlpublisher-wrapper.html");
            dbs.generateResponse(req, rsp, (Object)this);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }
}

