/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.CmdRunner;
import com.mks.api.Command;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import hudson.scm.Logger;
import java.io.IOException;

public class APISession {
    public static final String VERSION = IntegrationPointFactory.getAPIVersion().substring(0, IntegrationPointFactory.getAPIVersion().indexOf(32));
    public static final int MAJOR_VERSION = Integer.parseInt(VERSION.substring(0, VERSION.indexOf(46)));
    public static final int MINOR_VERSION = Integer.parseInt(VERSION.substring(VERSION.indexOf(46) + 1, VERSION.length()));
    private String ipHostName;
    private int ipPort = 0;
    private String hostName;
    private int port;
    private String userName;
    private String password;
    private IntegrationPoint ip;
    private Session session;
    private CmdRunner icr;
    private boolean terminated;
    private boolean secure;

    public APISession(String ipHost, int ipPortNum, String host, int portNum, String user, String paswd, boolean secure) throws APIException {
        this.ipHostName = ipHost;
        this.ipPort = ipPortNum;
        this.hostName = host;
        this.port = portNum;
        this.userName = user;
        this.password = paswd;
        this.secure = secure;
        this.initAPI();
    }

    private void initAPI() throws APIException {
        this.terminated = false;
        this.ip = null != this.ipHostName && this.ipHostName.length() > 0 && this.ipPort > 0 ? IntegrationPointFactory.getInstance().createIntegrationPoint(this.ipHostName, this.ipPort, this.secure, MAJOR_VERSION, MINOR_VERSION) : IntegrationPointFactory.getInstance().createIntegrationPoint(this.hostName, this.port, this.secure, MAJOR_VERSION, MINOR_VERSION);
        this.session = this.ip.createSession(this.userName, this.password);
        Command ping = new Command("api", "ping");
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        Response res = cmdRunner.execute(ping);
        Logger.debug(res.getCommandString() + " returned exit code " + res.getExitCode());
        cmdRunner.release();
        Logger.debug("Successfully established connection " + this.userName + "@" + this.hostName + ":" + this.port);
    }

    public Response runCommand(Command cmd) throws APIException {
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        Response res = cmdRunner.execute(cmd);
        Logger.debug(res.getCommandString() + " returned exit code " + res.getExitCode());
        cmdRunner.release();
        return res;
    }

    public Response runCommandWithInterim(Command cmd) throws APIException {
        if (null != this.icr) {
            this.icr.interrupt();
            this.icr.release();
        }
        this.icr = this.session.createCmdRunner();
        this.icr.setDefaultHostname(this.hostName);
        this.icr.setDefaultPort(this.port);
        this.icr.setDefaultUsername(this.userName);
        this.icr.setDefaultPassword(this.password);
        Response res = this.icr.executeWithInterim(cmd, false);
        Logger.debug("Executed " + res.getCommandString() + " with interim");
        return res;
    }

    public Response runCommandAs(Command cmd, String impersonateUser) throws APIException {
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        cmdRunner.setDefaultImpersonationUser(impersonateUser);
        Response res = cmdRunner.execute(cmd);
        Logger.debug(res.getCommandString() + " returned exit code " + res.getExitCode());
        cmdRunner.release();
        return res;
    }

    public void refreshAPISession() throws APIException {
        this.Terminate();
        this.initAPI();
    }

    public void Terminate() {
        if (!this.terminated) {
            try {
                if (null != this.icr) {
                    this.icr.interrupt();
                    this.icr.release();
                }
                if (null != this.session) {
                    this.session.release();
                }
                if (null != this.ip) {
                    this.ip.release();
                }
                this.terminated = true;
                Logger.debug("Successfully disconnected connection " + this.userName + "@" + this.hostName + ":" + this.port);
            }
            catch (APIException aex) {
                Logger.debug("Caught API Exception when releasing session!");
                aex.printStackTrace();
            }
            catch (IOException ioe) {
                Logger.debug("Caught IO Exception when releasing session!");
                ioe.printStackTrace();
            }
        }
    }

    public String getIPHostName() {
        return this.ipHostName;
    }

    public String getIPPort() {
        return String.valueOf(this.ipPort);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return String.valueOf(this.port);
    }

    public String getUserName() {
        return this.userName;
    }
}

