/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.util.Base64;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegritySCM;
import hudson.scm.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckoutTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1240357991626897900L;
    private static final int CHECKOUT_TRESHOLD = 500;
    private final List<Hashtable<CM_PROJECT, Object>> projectMembersList;
    private final List<String> dirList;
    private final String lineTerminator;
    private final boolean restoreTimestamp;
    private final boolean cleanCopy;
    private final String alternateWorkspaceDir;
    private final boolean fetchChangedWorkspaceFiles;
    private final BuildListener listener;
    private String ipHostName;
    private String hostName;
    private int ipPort = 0;
    private int port;
    private boolean secure;
    private String userName;
    private String password;
    private ConcurrentHashMap<String, String> checksumHash;
    private int addCount;
    private int updateCount;
    private int dropCount;
    private int fetchCount;
    private int checkoutThreadPoolSize;

    public IntegrityCheckoutTask(List<Hashtable<CM_PROJECT, Object>> projectMembersList, List<String> dirList, String alternateWorkspaceDir, String lineTerminator, boolean restoreTimestamp, boolean cleanCopy, boolean fetchChangedWorkspaceFiles, int checkoutThreadPoolSize, BuildListener listener) {
        this.projectMembersList = projectMembersList;
        this.dirList = dirList;
        this.alternateWorkspaceDir = alternateWorkspaceDir;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.cleanCopy = cleanCopy;
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
        this.listener = listener;
        this.ipHostName = "";
        this.ipPort = 0;
        this.hostName = "";
        this.port = 7001;
        this.secure = false;
        this.userName = "";
        this.password = "";
        this.addCount = 0;
        this.updateCount = 0;
        this.dropCount = 0;
        this.fetchCount = 0;
        this.checkoutThreadPoolSize = checkoutThreadPoolSize;
        this.checksumHash = new ConcurrentHashMap();
        Logger.debug("Integrity Checkout Task Created!");
    }

    public void initAPIVariables(String ipHostName, int ipPort, String hostName, int port, boolean secure, String userName, String password) {
        this.ipHostName = ipHostName;
        this.ipPort = ipPort;
        this.hostName = hostName;
        this.port = port;
        this.secure = secure;
        this.userName = userName;
        this.password = password;
    }

    public APISession createAPISession() {
        try {
            Logger.debug("Creating Integrity API Session...");
            return new APISession(this.ipHostName, this.ipPort, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            Logger.error("API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            Logger.error(eh.getMessage());
            Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
            Logger.fatal((Object)aex);
            return null;
        }
    }

    private void createFolderStructure(FilePath workspace) {
        Iterator<String> folders = this.dirList.iterator();
        while (folders.hasNext()) {
            File dir = new File(workspace + folders.next());
            if (dir.isDirectory()) continue;
            Logger.debug("Creating folder: " + dir.getAbsolutePath());
            dir.mkdirs();
        }
    }

    public ConcurrentHashMap<String, String> getChecksumUpdates() {
        return this.checksumHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean invoke(File workspaceFile, VirtualChannel channel) throws IOException {
        ThreadLocalAPISession generateAPISession;
        block17: {
            File checkOutDir = null != this.alternateWorkspaceDir && this.alternateWorkspaceDir.length() > 0 ? new File(this.alternateWorkspaceDir) : workspaceFile;
            FilePath workspace = new FilePath(checkOutDir.isAbsolute() ? checkOutDir : new File(workspaceFile.getAbsolutePath() + IntegritySCM.FS + checkOutDir.getPath()));
            this.listener.getLogger().println("Checkout directory is " + workspace);
            generateAPISession = new ThreadLocalAPISession(this.ipHostName, this.ipPort, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
            ThreadLocalOpenFileHandler openFileHandler = new ThreadLocalOpenFileHandler();
            ExecutorService executor = Executors.newFixedThreadPool(this.checkoutThreadPoolSize);
            ArrayList<Future<Void>> coThreads = new ArrayList<Future<Void>>();
            try {
                try {
                    if (this.cleanCopy) {
                        this.listener.getLogger().println("A clean copy is requested; deleting contents of " + workspace);
                        Logger.debug("Deleting contents of workspace " + workspace);
                        workspace.deleteContents();
                        this.listener.getLogger().println("Populating clean workspace...");
                    }
                    this.createFolderStructure(workspace);
                    for (Hashtable<CM_PROJECT, Object> memberInfo : this.projectMembersList) {
                        String checksum;
                        int deltaFlag = null == memberInfo.get((Object)CM_PROJECT.DELTA) ? -1 : (int)Short.valueOf(memberInfo.get((Object)CM_PROJECT.DELTA).toString()).shortValue();
                        File targetFile = new File(workspace + memberInfo.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                        String memberName = memberInfo.get((Object)CM_PROJECT.NAME).toString();
                        String memberID = memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString();
                        String memberRev = memberInfo.get((Object)CM_PROJECT.REVISION).toString();
                        String configPath = memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString();
                        String string = checksum = null == memberInfo.get((Object)CM_PROJECT.CHECKSUM) ? "" : memberInfo.get((Object)CM_PROJECT.CHECKSUM).toString();
                        if (this.cleanCopy && deltaFlag != 3) {
                            Logger.debug("Attempting to checkout file: " + targetFile.getAbsolutePath() + " at revision " + memberRev);
                            coThreads.add(executor.submit(new CheckOutTask(generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, this.fetchChangedWorkspaceFiles)));
                            continue;
                        }
                        if (deltaFlag == 0 && this.fetchChangedWorkspaceFiles && checksum.length() > 0) {
                            if (checksum.equals(IntegrityCMMember.getMD5Checksum(targetFile))) continue;
                            Logger.debug("Attempting to restore changed workspace file: " + targetFile.getAbsolutePath() + " to revision " + memberRev);
                            coThreads.add(executor.submit(new CheckOutTask(generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, false)));
                            ++this.fetchCount;
                            continue;
                        }
                        if (deltaFlag == 1) {
                            Logger.debug("Attempting to get new file: " + targetFile.getAbsolutePath() + " at revision " + memberRev);
                            coThreads.add(executor.submit(new CheckOutTask(generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, this.fetchChangedWorkspaceFiles)));
                            ++this.addCount;
                            continue;
                        }
                        if (deltaFlag == 2) {
                            Logger.debug("Attempting to update file: " + targetFile.getAbsolutePath() + " to revision " + memberRev);
                            coThreads.add(executor.submit(new CheckOutTask(generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, this.fetchChangedWorkspaceFiles)));
                            ++this.updateCount;
                            continue;
                        }
                        if (deltaFlag != 3) continue;
                        Logger.debug("Attempting to drop file: " + targetFile.getAbsolutePath() + " was at revision " + memberRev);
                        ++this.dropCount;
                        if (!targetFile.exists() || targetFile.delete()) continue;
                        this.listener.getLogger().println("Failed to clean up workspace file " + targetFile.getAbsolutePath() + "!");
                        Boolean bl = false;
                        Object var20_24 = null;
                        if (generateAPISession == null) return bl;
                        generateAPISession.remove();
                        return bl;
                    }
                    int checkoutMembers = 0;
                    int previousCount = 0;
                    int canceledMembers = 0;
                    int totalMembers = coThreads.size();
                    while (!coThreads.isEmpty()) {
                        Iterator iter = coThreads.iterator();
                        while (iter.hasNext()) {
                            Future future = (Future)iter.next();
                            if (future.isCancelled()) {
                                this.listener.getLogger().println("Checkout thread " + future.toString() + " was cancelled");
                                ++canceledMembers;
                                iter.remove();
                                continue;
                            }
                            if (!future.isDone()) continue;
                            ++checkoutMembers;
                            iter.remove();
                        }
                        if (previousCount != checkoutMembers + canceledMembers) {
                            Logger.debug("Checkout process: " + checkoutMembers + " of " + totalMembers + (canceledMembers > 0 ? "(Canceled: " + canceledMembers + ")" : ""));
                        }
                        previousCount = checkoutMembers + canceledMembers;
                        Thread.sleep(2000L);
                    }
                    executor.shutdown();
                    executor.awaitTermination(2L, TimeUnit.MINUTES);
                    if (this.cleanCopy) {
                        this.listener.getLogger().println("Successfully checked out " + this.projectMembersList.size() + " files!");
                        break block17;
                    }
                    this.listener.getLogger().println("Successfully updated workspace with " + (this.addCount + this.updateCount) + " updates and cleaned up " + this.dropCount + " files!");
                    if (this.fetchChangedWorkspaceFiles && this.fetchCount > 0) {
                        this.listener.getLogger().println("Additionally, a total of " + this.fetchCount + " files were restored to their original repository state!");
                    }
                }
                catch (InterruptedException iex) {
                    Logger.error("Interrupted Exception caught...");
                    this.listener.getLogger().println("An Interrupted Exception was caught!");
                    Logger.error(iex.getMessage());
                    this.listener.getLogger().println(iex.getMessage());
                    this.listener.getLogger().println("Failed to clean up workspace (" + workspace + ") contents!");
                    Boolean bl = false;
                    Object var20_26 = null;
                    if (generateAPISession == null) return bl;
                    generateAPISession.remove();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var20_27 = null;
                if (generateAPISession == null) throw throwable;
                generateAPISession.remove();
                throw throwable;
            }
        }
        Object var20_25 = null;
        if (generateAPISession == null) return true;
        generateAPISession.remove();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CheckOutTask
    implements Callable<Void> {
        private final ThreadLocalAPISession apiSession;
        private final ThreadLocalOpenFileHandler openFileHandler;
        private final String configPath;
        private final String memberID;
        private final String memberName;
        private final String memberRev;
        private final File targetFile;
        private final boolean calculateChecksum;

        public CheckOutTask(ThreadLocalAPISession apiSession, ThreadLocalOpenFileHandler openFileHandler, String memberName, String configPath, String memberID, String memberRev, File targetFile, boolean calculateChecksum) {
            this.apiSession = apiSession;
            this.openFileHandler = openFileHandler;
            this.configPath = configPath;
            this.memberID = memberID;
            this.memberName = memberName;
            this.memberRev = memberRev;
            this.targetFile = targetFile;
            this.calculateChecksum = calculateChecksum;
        }

        @Override
        public Void call() throws Exception {
            APISession api = (APISession)this.apiSession.get();
            Logger.debug("API open file handles: " + this.openFileHandler.get());
            if ((Integer)this.openFileHandler.get() >= 500) {
                Logger.debug("Checkout threshold reached for session " + api.toString() + ", refreshing API session");
                api.refreshAPISession();
                this.openFileHandler.set(1);
            }
            Logger.debug("Checkout on API thread: " + api.toString());
            IntegrityCMMember.checkout(api, this.configPath, this.memberID, this.memberRev, this.targetFile, IntegrityCheckoutTask.this.restoreTimestamp, IntegrityCheckoutTask.this.lineTerminator);
            this.openFileHandler.set((Integer)this.openFileHandler.get() + 1);
            if (this.calculateChecksum) {
                IntegrityCheckoutTask.this.checksumHash.put(this.memberName, IntegrityCMMember.getMD5Checksum(this.targetFile));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalAPISession
    extends ThreadLocal<APISession> {
        final String ipHost;
        final int ipPortNum;
        final String host;
        final int portNum;
        final String user;
        final String paswd;
        final boolean secure;
        private Vector<APISession> sessions = new Vector();

        public ThreadLocalAPISession(String ipHost, int ipPortNum, String host, int portNum, String user, String paswd, boolean secure) {
            this.ipHost = ipHost;
            this.ipPortNum = ipPortNum;
            this.host = host;
            this.portNum = portNum;
            this.user = user;
            this.paswd = paswd;
            this.secure = secure;
        }

        @Override
        public void remove() {
            for (APISession session : this.sessions) {
                try {
                    session.Terminate();
                }
                catch (Exception ex) {
                    Logger.debug("Error while shuting down thread API session: " + ex.getMessage());
                }
            }
            super.remove();
        }

        @Override
        protected APISession initialValue() {
            Logger.debug("Trying to initialize new thread session");
            try {
                APISession session = new APISession(this.ipHost, this.ipPortNum, this.host, this.portNum, this.user, this.paswd, this.secure);
                Logger.debug("Initialized thread session: " + session.toString());
                this.sessions.add(session);
                return session;
            }
            catch (APIException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalOpenFileHandler
    extends ThreadLocal<Integer> {
        private ThreadLocalOpenFileHandler() {
        }

        @Override
        protected Integer initialValue() {
            Logger.debug("Trying to retrieve initial value for open file handler");
            return new Integer(1);
        }
    }
}

