/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.scm.IntegrityDeleteNonMembersTask;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityDeleteNonMembersAction
extends Notifier {
    @Extension
    public static final IntegrityDeleteNonMembersDescriptorImpl DELETENONMEMBERS_DESCRIPTOR = new IntegrityDeleteNonMembersDescriptorImpl();

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractProject<?, ?> rootProject = this.getRootProject(build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            listener.getLogger().println("Integrity DeleteNonMembers is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        IntegritySCM scm = (IntegritySCM)IntegritySCM.class.cast(rootProject.getScm());
        IntegrityDeleteNonMembersTask deleteNonMembers = new IntegrityDeleteNonMembersTask(build, listener, scm.getAlternateWorkspace(), scm.getIntegrityProject());
        return (Boolean)build.getWorkspace().act((FilePath.FileCallable)deleteNonMembers) != false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DELETENONMEMBERS_DESCRIPTOR;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegrityDeleteNonMembersDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Integrity - Delete Non Members";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new IntegrityDeleteNonMembersAction();
        }
    }
}

