/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItemIterator;
import com.mks.api.util.Base64;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegritySCM;
import hudson.scm.Logger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityItemAction
extends Notifier {
    private String hostName;
    private int port;
    private boolean secure;
    private String userName;
    private String password;
    private String queryDefinition;
    private String stateField;
    private String successValue;
    private String failureValue;
    private String logField;
    @Extension
    public static final IntegrityItemDescriptorImpl ITEM_DESCRIPTOR = new IntegrityItemDescriptorImpl();

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password != null && this.password.length() > 0 ? Base64.decode((String)this.password) : this.password;
    }

    public String getQueryDefinition() {
        return this.queryDefinition;
    }

    public String getStateField() {
        return this.stateField;
    }

    public String getSuccessValue() {
        return this.successValue;
    }

    public String getFailureValue() {
        return this.failureValue;
    }

    public String getLogField() {
        return this.logField;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Base64.encode((String)password);
    }

    public void setQueryDefinition(String queryDefinition) {
        this.queryDefinition = queryDefinition;
    }

    public void setStateField(String stateField) {
        this.stateField = stateField;
    }

    public void setSuccessValue(String successValue) {
        this.successValue = successValue;
    }

    public void setFailureValue(String failureValue) {
        this.failureValue = failureValue;
    }

    public void setLogField(String logField) {
        this.logField = logField;
    }

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    public APISession createAPISession() {
        try {
            Logger.debug("Creating Integrity API Session...");
            return new APISession(null, 0, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            Logger.error("API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            Logger.error(eh.getMessage());
            Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
            aex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractProject<?, ?> rootProject = this.getRootProject(build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            listener.getLogger().println("Integrity Item update is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        APISession api = this.createAPISession();
        if (null == api) {
            Logger.error("An API Session could not be established!  Cannot update Integrity Build Item!");
            listener.getLogger().println("An API Session could not be established!  Cannot update Integrity Build Item!");
            return false;
        }
        try {
            block14: {
                boolean wit2;
                block13: {
                    try {
                        try {
                            Command editIssue;
                            String buildItemID;
                            block16: {
                                block17: {
                                    block15: {
                                        buildItemID = "";
                                        Command issues = new Command("im", "issues");
                                        issues.addOption(new Option("fields", "ID"));
                                        issues.addOption(new Option("queryDefinition", this.queryDefinition));
                                        Response issuesResponse = api.runCommand(issues);
                                        if (null == issuesResponse) break block15;
                                        WorkItemIterator wit2 = issuesResponse.getWorkItems();
                                        if (!wit2.hasNext()) {
                                            listener.getLogger().println("Cannot find an Integrity Build Item!  Response from executing custom query is null!");
                                            boolean bl = false;
                                            Object var14_16 = null;
                                            api.Terminate();
                                            return bl;
                                        }
                                        buildItemID = wit2.next().getField("ID").getValueAsString();
                                        editIssue = new Command("im", "editissue");
                                        if (null == this.logField) break block16;
                                        break block17;
                                    }
                                    listener.getLogger().println("Cannot find an Integrity Build Item!  Response from executing custom query is null!");
                                    wit2 = false;
                                    break block13;
                                }
                                if (this.logField.length() > 0) {
                                    StringWriter writer = new StringWriter();
                                    build.getLogText().writeHtmlTo(0L, (Writer)writer);
                                    writer.flush();
                                    writer.close();
                                    String log = writer.getBuffer().toString().replace('\u0000', ' ');
                                    log = log.replaceAll(IntegritySCM.NL, "<br>");
                                    MultiValue mvLog = new MultiValue("=");
                                    mvLog.add(this.logField);
                                    mvLog.add(log);
                                    editIssue.addOption(new Option("richContentField", mvLog));
                                }
                            }
                            MultiValue mvState = new MultiValue("=");
                            mvState.add(this.stateField);
                            if (Result.SUCCESS.equals((Object)build.getResult())) {
                                listener.getLogger().println("Preparing to update item '" + buildItemID + "' with value " + this.stateField + " = " + this.successValue);
                                mvState.add(this.successValue);
                            } else {
                                listener.getLogger().println("Preparing to update item '" + buildItemID + "' with values " + this.stateField + " = " + this.failureValue);
                                mvState.add(this.failureValue);
                            }
                            editIssue.addOption(new Option("field", mvState));
                            editIssue.addSelection(buildItemID);
                            Response editIssueResponse = api.runCommand(editIssue);
                            Logger.debug(editIssueResponse.getCommandString() + " returned " + editIssueResponse.getExitCode());
                            listener.getLogger().println("Updated build item '" + buildItemID + "' with build status!");
                            break block14;
                        }
                        catch (APIException aex) {
                            Logger.error("API Exception caught...");
                            ExceptionHandler eh = new ExceptionHandler(aex);
                            Logger.error(eh.getMessage());
                            Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
                            throw new Exception(eh.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        api.Terminate();
                        throw throwable;
                    }
                }
                Object var14_17 = null;
                api.Terminate();
                return wit2;
            }
            Object var14_18 = null;
            api.Terminate();
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(listener.fatalError(e.getMessage()));
            Logger.error("Exception caught!  " + e);
            return false;
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return ITEM_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegrityItemDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String defaultQueryDefinition = "((field[Type] = \"Build Request\") and (field[State] = \"Approved\"))";

        public IntegrityItemDescriptorImpl() {
            super(IntegrityItemAction.class);
            this.load();
            Logger.debug("IntegrityItemAction.IntegrityItemDescriptorImpl() constructed!");
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            IntegrityItemAction itemAction = new IntegrityItemAction();
            itemAction.setHostName(formData.getString("hostName"));
            itemAction.setPort(formData.getInt("port"));
            itemAction.setUserName(formData.getString("userName"));
            itemAction.setPassword(formData.getString("password"));
            itemAction.setSecure(formData.getBoolean("secure"));
            itemAction.setQueryDefinition(formData.getString("queryDefinition"));
            itemAction.setStateField(formData.getString("stateField"));
            itemAction.setSuccessValue(formData.getString("successValue"));
            itemAction.setFailureValue(formData.getString("failureValue"));
            itemAction.setLogField(formData.getString("logField"));
            Logger.debug("IntegrityItemAction.IntegrityItemDescriptorImpl.newInstance() executed!");
            return itemAction;
        }

        public String getDisplayName() {
            return "Integrity - Workflow Item";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.defaultQueryDefinition = Util.fixEmptyAndTrim((String)req.getParameter("mks.queryDefinition"));
            this.save();
            Logger.debug("IntegrityItemAction.IntegrityItemDescriptorImpl.configure() executed!");
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            Logger.debug("IntegrityItemAction.IntegrityItemDescriptorImpl.isApplicable executed!");
            return true;
        }

        public String getDefaultHostName() {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDefaultHostName();
        }

        public int getDefaultPort() {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDefaultPort();
        }

        public boolean getDefaultSecure() {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDefaultSecure();
        }

        public String getDefaultUserName() {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDefaultUserName();
        }

        public String getDefaultPassword() {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDefaultPassword();
        }

        public String getDefaultQueryDefinition() {
            return this.defaultQueryDefinition;
        }
    }
}

