/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.CmdRunner;
import com.mks.api.Command;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityConfigurable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class APISession {
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    public static final String VERSION = "4.13";
    public static final int MAJOR_VERSION = 4;
    public static final int MINOR_VERSION = 13;
    private String ipHostName;
    private int ipPort = 0;
    private String hostName;
    private int port;
    private String userName;
    private String password;
    private IntegrationPoint ip;
    private Session session;
    private CmdRunner icr;
    private boolean terminated;
    private boolean secure;

    public static synchronized APISession create(IntegrityConfigurable settings) {
        try {
            LOGGER.fine("Creating Integrity API Session...");
            return new APISession(settings.getIpHostName(), settings.getIpPort(), settings.getHostName(), settings.getPort(), settings.getUserName(), settings.getPasswordInPlainText(), settings.getSecure());
        }
        catch (APIException aex) {
            LOGGER.severe("API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            LOGGER.severe(eh.getMessage());
            LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
            LOGGER.log(Level.SEVERE, "APIException", aex);
            return null;
        }
    }

    private APISession(String ipHost, int ipPortNum, String host, int portNum, String user, String paswd, boolean secure) throws APIException {
        this.ipHostName = ipHost;
        this.ipPort = ipPortNum;
        this.hostName = host;
        this.port = portNum;
        this.userName = user;
        this.password = paswd;
        this.secure = secure;
        this.initAPI();
    }

    private void initAPI() throws APIException {
        this.terminated = false;
        this.ip = null != this.ipHostName && this.ipHostName.length() > 0 && this.ipPort > 0 ? IntegrationPointFactory.getInstance().createIntegrationPoint(this.ipHostName, this.ipPort, this.secure, 4, 13) : IntegrationPointFactory.getInstance().createIntegrationPoint(this.hostName, this.port, this.secure, 4, 13);
        this.session = this.ip.createSession(this.userName, this.password);
        Command ping = new Command("api", "ping");
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        Response res = cmdRunner.execute(ping);
        LOGGER.fine(res.getCommandString() + " returned exit code " + res.getExitCode());
        cmdRunner.release();
        LOGGER.fine("Successfully established connection " + this.userName + "@" + this.hostName + ":" + this.port);
    }

    public Response runCommand(Command cmd) throws APIException {
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        Response res = cmdRunner.execute(cmd);
        LOGGER.fine(res.getCommandString() + " returned exit code " + res.getExitCode());
        cmdRunner.release();
        return res;
    }

    public Response runCommandWithInterim(Command cmd) throws APIException {
        if (null != this.icr) {
            if (!this.icr.isFinished()) {
                this.icr.interrupt();
            }
            this.icr.release();
        }
        this.icr = this.session.createCmdRunner();
        this.icr.setDefaultHostname(this.hostName);
        this.icr.setDefaultPort(this.port);
        this.icr.setDefaultUsername(this.userName);
        this.icr.setDefaultPassword(this.password);
        Response res = this.icr.executeWithInterim(cmd, false);
        LOGGER.fine("Executed " + res.getCommandString() + " with interim");
        return res;
    }

    public Response runCommandAs(Command cmd, String impersonateUser) throws APIException {
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        cmdRunner.setDefaultImpersonationUser(impersonateUser);
        Response res = cmdRunner.execute(cmd);
        LOGGER.fine(res.getCommandString() + " returned exit code " + res.getExitCode());
        cmdRunner.release();
        return res;
    }

    public void refreshAPISession() throws APIException {
        this.Terminate();
        this.initAPI();
    }

    public void Terminate() {
        boolean cmdRunnerKilled = false;
        boolean sessionKilled = false;
        boolean intPointKilled = false;
        if (!this.terminated) {
            try {
                if (null != this.icr) {
                    if (!this.icr.isFinished()) {
                        this.icr.interrupt();
                    }
                    this.icr.release();
                    cmdRunnerKilled = true;
                } else {
                    cmdRunnerKilled = true;
                }
            }
            catch (APIException aex) {
                LOGGER.fine("Caught API Exception when releasing Command Runner!");
                LOGGER.log(Level.SEVERE, "APIException", aex);
            }
            catch (Exception ex) {
                LOGGER.fine("Caught Exception when releasing Command Runner!");
                LOGGER.log(Level.SEVERE, "Exception", ex);
            }
            try {
                if (null != this.session) {
                    this.session.release(true);
                    sessionKilled = true;
                } else {
                    sessionKilled = true;
                }
            }
            catch (APIException aex) {
                LOGGER.fine("Caught API Exception when releasing session!");
                LOGGER.log(Level.SEVERE, "APIException", aex);
            }
            catch (IOException ioe) {
                LOGGER.fine("Caught IO Exception when releasing session!");
                LOGGER.log(Level.SEVERE, "IOException", ioe);
            }
            if (null != this.ip) {
                this.ip.release();
                intPointKilled = true;
            } else {
                intPointKilled = true;
            }
            if (cmdRunnerKilled && sessionKilled && intPointKilled) {
                this.terminated = true;
                LOGGER.fine("Successfully disconnected connection " + this.userName + "@" + this.hostName + ":" + this.port);
            } else {
                LOGGER.warning("Failed to disconnect connection " + this.userName + "@" + this.hostName + ":" + this.port);
            }
        }
    }

    public String getIPHostName() {
        return this.ipHostName;
    }

    public String getIPPort() {
        return String.valueOf(this.ipPort);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return String.valueOf(this.port);
    }

    public String getUserName() {
        return this.userName;
    }
}

