/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.CM_PROJECT;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegrityCheckoutTask;
import hudson.scm.IntegrityConfigurable;
import hudson.scm.IntegritySCM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckoutTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1240357991626897900L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private static final int CHECKOUT_TRESHOLD = 500;
    private final List<Hashtable<CM_PROJECT, Object>> projectMembersList;
    private final List<String> dirList;
    private final String lineTerminator;
    private final boolean restoreTimestamp;
    private final boolean cleanCopy;
    private final String alternateWorkspaceDir;
    private final boolean fetchChangedWorkspaceFiles;
    private final BuildListener listener;
    private IntegrityConfigurable integrityConfig;
    private ConcurrentHashMap<String, String> checksumHash;
    private int addCount;
    private int updateCount;
    private int dropCount;
    private int fetchCount;
    private int checkoutThreadPoolSize;

    public IntegrityCheckoutTask(List<Hashtable<CM_PROJECT, Object>> projectMembersList, List<String> dirList, String alternateWorkspaceDir, String lineTerminator, boolean restoreTimestamp, boolean cleanCopy, boolean fetchChangedWorkspaceFiles, int checkoutThreadPoolSize, BuildListener listener, IntegrityConfigurable integrityConfig) {
        this.projectMembersList = projectMembersList;
        this.dirList = dirList;
        this.alternateWorkspaceDir = alternateWorkspaceDir;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.cleanCopy = cleanCopy;
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
        this.listener = listener;
        this.integrityConfig = integrityConfig;
        this.addCount = 0;
        this.updateCount = 0;
        this.dropCount = 0;
        this.fetchCount = 0;
        this.checkoutThreadPoolSize = checkoutThreadPoolSize;
        this.checksumHash = new ConcurrentHashMap();
        LOGGER.fine("Integrity Checkout Task Created!");
    }

    private void createFolderStructure(FilePath workspace) {
        Iterator folders = this.dirList.iterator();
        while (folders.hasNext()) {
            File dir = new File(workspace + (String)folders.next());
            if (dir.isDirectory()) continue;
            LOGGER.fine("Creating folder: " + dir.getAbsolutePath());
            dir.mkdirs();
        }
    }

    public ConcurrentHashMap<String, String> getChecksumUpdates() {
        return this.checksumHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File workspaceFile, VirtualChannel channel) throws IOException {
        File checkOutDir = null != this.alternateWorkspaceDir && this.alternateWorkspaceDir.length() > 0 ? new File(this.alternateWorkspaceDir) : workspaceFile;
        FilePath workspace = new FilePath(checkOutDir.isAbsolute() ? checkOutDir : new File(workspaceFile.getAbsolutePath() + IntegritySCM.FS + checkOutDir.getPath()));
        this.listener.getLogger().println("Checkout directory is " + workspace);
        ThreadLocalAPISession generateAPISession = new ThreadLocalAPISession(this.integrityConfig);
        ThreadLocalOpenFileHandler openFileHandler = new ThreadLocalOpenFileHandler(null);
        ExecutorService executor = Executors.newFixedThreadPool(this.checkoutThreadPoolSize);
        ArrayList coThreads = new ArrayList();
        try {
            if (this.cleanCopy) {
                this.listener.getLogger().println("A clean copy is requested; deleting contents of " + workspace);
                LOGGER.fine("Deleting contents of workspace " + workspace);
                workspace.deleteContents();
                this.listener.getLogger().println("Populating clean workspace...");
            }
            this.createFolderStructure(workspace);
            for (Hashtable memberInfo : this.projectMembersList) {
                String checksum;
                int deltaFlag = null == memberInfo.get(CM_PROJECT.DELTA) ? -1 : (int)Short.valueOf(memberInfo.get(CM_PROJECT.DELTA).toString()).shortValue();
                File targetFile = new File(workspace + memberInfo.get(CM_PROJECT.RELATIVE_FILE).toString());
                String memberName = memberInfo.get(CM_PROJECT.NAME).toString();
                String memberID = memberInfo.get(CM_PROJECT.MEMBER_ID).toString();
                String memberRev = memberInfo.get(CM_PROJECT.REVISION).toString();
                String configPath = memberInfo.get(CM_PROJECT.CONFIG_PATH).toString();
                String string = checksum = null == memberInfo.get(CM_PROJECT.CHECKSUM) ? "" : memberInfo.get(CM_PROJECT.CHECKSUM).toString();
                if (this.cleanCopy && deltaFlag != 3) {
                    LOGGER.fine("Attempting to checkout file: " + targetFile.getAbsolutePath() + " at revision " + memberRev);
                    coThreads.add(executor.submit(new CheckOutTask(this, generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, this.fetchChangedWorkspaceFiles)));
                    continue;
                }
                if (deltaFlag == 0 && this.fetchChangedWorkspaceFiles && checksum.length() > 0) {
                    if (!checksum.equals(IntegrityCMMember.getMD5Checksum((File)targetFile))) {
                        LOGGER.fine("Attempting to restore changed workspace file: " + targetFile.getAbsolutePath() + " to revision " + memberRev);
                        coThreads.add(executor.submit(new CheckOutTask(this, generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, false)));
                        ++this.fetchCount;
                    }
                    continue;
                }
                if (deltaFlag == 1) {
                    LOGGER.fine("Attempting to get new file: " + targetFile.getAbsolutePath() + " at revision " + memberRev);
                    coThreads.add(executor.submit(new CheckOutTask(this, generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, this.fetchChangedWorkspaceFiles)));
                    ++this.addCount;
                    continue;
                }
                if (deltaFlag == 2) {
                    LOGGER.fine("Attempting to update file: " + targetFile.getAbsolutePath() + " to revision " + memberRev);
                    coThreads.add(executor.submit(new CheckOutTask(this, generateAPISession, openFileHandler, memberName, configPath, memberID, memberRev, targetFile, this.fetchChangedWorkspaceFiles)));
                    ++this.updateCount;
                    continue;
                }
                if (deltaFlag != 3) continue;
                LOGGER.fine("Attempting to drop file: " + targetFile.getAbsolutePath() + " was at revision " + memberRev);
                ++this.dropCount;
                if (!targetFile.exists() || targetFile.delete()) continue;
                this.listener.getLogger().println("Failed to clean up workspace file " + targetFile.getAbsolutePath() + "!");
                Boolean bl = false;
                return bl;
            }
            int checkoutMembers = 0;
            int previousCount = 0;
            int canceledMembers = 0;
            int totalMembers = coThreads.size();
            while (!coThreads.isEmpty()) {
                Iterator iter = coThreads.iterator();
                while (iter.hasNext()) {
                    block26: {
                        Future future = (Future)iter.next();
                        if (future.isCancelled()) {
                            this.listener.getLogger().println("Checkout thread " + future.toString() + " was cancelled");
                            ++canceledMembers;
                            iter.remove();
                            continue;
                        }
                        if (!future.isDone()) continue;
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            this.listener.getLogger().println(e.getMessage());
                            LOGGER.log(Level.SEVERE, "ExecutionException", e);
                            StackTraceElement[] st = e.getStackTrace();
                            for (int i = 0; i < st.length; ++i) {
                                LOGGER.severe("\tat " + st[i].getClassName() + "." + st[i].getMethodName() + "(" + st[i].getFileName() + ":" + st[i].getLineNumber() + ")");
                            }
                            if (null != e.getMessage() && e.getMessage().indexOf("Unbuffered entity enclosing request can not be repeated") > 0) break block26;
                            Boolean bl = false;
                            if (generateAPISession != null) {
                                generateAPISession.remove();
                            }
                            return bl;
                        }
                    }
                    ++checkoutMembers;
                    iter.remove();
                }
                if (previousCount != checkoutMembers + canceledMembers) {
                    LOGGER.fine("Checkout process: " + checkoutMembers + " of " + totalMembers + (canceledMembers > 0 ? "(Canceled: " + canceledMembers + ")" : ""));
                }
                previousCount = checkoutMembers + canceledMembers;
                Thread.sleep(2000L);
            }
            executor.shutdown();
            executor.awaitTermination(2L, TimeUnit.MINUTES);
            if (this.cleanCopy) {
                this.listener.getLogger().println("Successfully checked out " + this.projectMembersList.size() + " files!");
            } else {
                this.listener.getLogger().println("Successfully updated workspace with " + (this.addCount + this.updateCount) + " updates and cleaned up " + this.dropCount + " files!");
                if (this.fetchChangedWorkspaceFiles && this.fetchCount > 0) {
                    this.listener.getLogger().println("Additionally, a total of " + this.fetchCount + " files were restored to their original repository state!");
                }
            }
        }
        catch (InterruptedException iex) {
            LOGGER.severe("Interrupted Exception caught...");
            this.listener.getLogger().println("An Interrupted Exception was caught!");
            LOGGER.severe(iex.getMessage());
            this.listener.getLogger().println(iex.getMessage());
            this.listener.getLogger().println("Failed to clean up workspace (" + workspace + ") contents!");
            Boolean bl = false;
            return bl;
        }
        finally {
            if (generateAPISession != null) {
                generateAPISession.remove();
            }
        }
        return true;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ boolean access$100(IntegrityCheckoutTask x0) {
        return x0.restoreTimestamp;
    }

    static /* synthetic */ String access$200(IntegrityCheckoutTask x0) {
        return x0.lineTerminator;
    }

    static /* synthetic */ ConcurrentHashMap access$300(IntegrityCheckoutTask x0) {
        return x0.checksumHash;
    }
}

