/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.DerbyUtils;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegrityCheckpointAction;
import hudson.scm.IntegrityConfigurable;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IntegrityCheckpointAction
extends Notifier
implements Serializable {
    private static final long serialVersionUID = 3344676447487492553L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private String checkpointLabel;
    private final Log logger = LogFactory.getLog(this.getClass());
    private String serverConfig;
    private String configurationName;
    @Extension
    public static final IntegrityCheckpointDescriptorImpl CHECKPOINT_DESCRIPTOR = new IntegrityCheckpointDescriptorImpl();

    @DataBoundConstructor
    public IntegrityCheckpointAction(String serverConfig, String checkpointLabel) {
        this.setCheckpointLabel(checkpointLabel);
        this.setServerConfig(serverConfig);
    }

    public static String evalGroovyExpression(Map<String, String> env, String expression) {
        Binding binding = new Binding();
        binding.setVariable("env", env);
        binding.setVariable("sys", (Object)System.getProperties());
        CompilerConfiguration config = new CompilerConfiguration();
        GroovyShell shell = new GroovyShell(binding, config);
        Object result = shell.evaluate("return \"" + expression + "\"");
        if (result == null) {
            return "";
        }
        return result.toString().trim();
    }

    public static String isInvalidTag(String checkpointLabel) {
        if (checkpointLabel == null || checkpointLabel.length() == 0) {
            return "The label string is empty!";
        }
        char ch = checkpointLabel.charAt(0);
        if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
            return "The label must start with an alpha character!";
        }
        for (char invalid : "$,.:;/\\@".toCharArray()) {
            if (checkpointLabel.indexOf(invalid) < 0) continue;
            return "The label may cannot contain one of the following characters: $ , . : ; / \\ @";
        }
        return null;
    }

    public String getCheckpointLabel() {
        if (this.checkpointLabel == null || this.checkpointLabel.length() == 0) {
            return "${env['JOB_NAME']}-${env['BUILD_NUMBER']}-${new java.text.SimpleDateFormat(\"yyyy_MM_dd\").format(new Date())}";
        }
        return this.checkpointLabel;
    }

    public void setCheckpointLabel(String checkpointLabel) {
        this.checkpointLabel = checkpointLabel;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    private void setConfigurationName(AbstractBuild<?, ?> thisBuild) {
        AbstractProject thisProject = thisBuild.getProject();
        if (thisProject.getScm() instanceof IntegritySCM) {
            this.configurationName = ((IntegritySCM)thisProject.getScm()).getConfigurationName();
            LOGGER.fine("IntegrityCheckpointAction - Configuration Name = " + this.configurationName);
        } else {
            LOGGER.severe("IntegrityCheckpointAction - Configuration Name could not be initialized!");
        }
    }

    private void applyProjectLabel(APISession api, BuildListener listener, IntegrityCMProject siProject, String fullConfigPath, String projectName, String revision, String chkptLabel) throws APIException {
        listener.getLogger().println("Preparing to execute si addprojectlabel for " + fullConfigPath);
        listener.getLogger().println(" (" + projectName + ", " + revision + ")");
        Response res = siProject.addProjectLabel(api, chkptLabel, projectName, revision);
        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
        listener.getLogger().println("Successfully added label '" + chkptLabel + "' to revision " + revision);
    }

    private IntegrityConfigurable getProjectSettings(AbstractBuild<?, ?> thisBuild) {
        IntegrityConfigurable desSettings = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(this.serverConfig);
        IntegrityConfigurable ciSettings = new IntegrityConfigurable("TEMP_ID", desSettings.getIpHostName(), desSettings.getIpPort(), desSettings.getHostName(), desSettings.getPort(), desSettings.getSecure(), "", "");
        AbstractProject thisProject = thisBuild.getProject();
        if (!(thisProject.getScm() instanceof IntegritySCM)) {
            LOGGER.severe("IntegrityCheckpointAction - Failed to initialize project specific connection settings!");
            return desSettings;
        }
        String userName = ((IntegritySCM)thisProject.getScm()).getUserName();
        ciSettings.setUserName(userName);
        LOGGER.fine("IntegrityCheckpointAction - Project Userame = " + userName);
        Secret password = ((IntegritySCM)thisProject.getScm()).getSecretPassword();
        ciSettings.setPassword(password.getEncryptedValue());
        LOGGER.fine("IntegrityCheckpointAction - Project User password = " + password.getEncryptedValue());
        return ciSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.setConfigurationName(build);
        if (!Result.SUCCESS.equals((Object)build.getResult())) {
            listener.getLogger().println("Build failed!  Skipping Integrity Checkpoint step!");
            return true;
        }
        APISession api = APISession.create((IntegrityConfigurable)this.getProjectSettings(build));
        if (null != api) {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            String chkptLabel = IntegrityCheckpointAction.evalGroovyExpression((Map)env, (String)this.checkpointLabel);
            try {
                IntegrityCMProject siProject = IntegritySCM.findProject((String)this.getConfigurationName());
                if (null != siProject) {
                    if (!siProject.isBuild()) {
                        listener.getLogger().println("Preparing to execute si checkpoint for " + siProject.getConfigurationPath());
                        Response res = siProject.checkpoint(api, chkptLabel);
                        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
                        WorkItem wi = res.getWorkItem(siProject.getConfigurationPath());
                        String chkpt = wi.getResult().getField("resultant").getItem().getId();
                        listener.getLogger().println("Successfully checkpointed project " + siProject.getConfigurationPath() + " with label '" + chkptLabel + "', new revision is " + chkpt);
                    }
                    if (siProject.getCheckpointBeforeBuild()) {
                        this.applyProjectLabel(api, listener, siProject, siProject.getConfigurationPath(), siProject.getProjectName(), siProject.getProjectRevision(), chkptLabel);
                        for (Hashtable memberInfo : DerbyUtils.viewSubProjects((String)siProject.getProjectCacheTable())) {
                            String fullConfigPath = (String)String.class.cast(memberInfo.get(CM_PROJECT.CONFIG_PATH));
                            String projectName = (String)String.class.cast(memberInfo.get(CM_PROJECT.NAME));
                            String revision = (String)String.class.cast(memberInfo.get(CM_PROJECT.REVISION));
                            this.applyProjectLabel(api, listener, siProject, fullConfigPath, projectName, revision, chkptLabel);
                        }
                    }
                    listener.getLogger().println("Cannot checkpoint a build project configuration: " + siProject.getConfigurationPath() + "!");
                }
                LOGGER.severe("Cannot find Integrity CM Project information for configuration '" + this.getConfigurationName() + "'");
                listener.getLogger().println("ERROR: Cannot find Integrity CM Project information for configuration '" + this.getConfigurationName() + "'!");
            }
            catch (APIException aex) {
                LOGGER.severe("API Exception caught...");
                ExceptionHandler eh = new ExceptionHandler(aex);
                aex.printStackTrace(listener.fatalError(eh.getMessage()));
                LOGGER.severe(eh.getMessage());
                LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
                boolean bl = false;
                return bl;
            }
            catch (SQLException sqlex) {
                LOGGER.severe("SQL Exception caught...");
                listener.getLogger().println("A SQL Exception was caught!");
                listener.getLogger().println(sqlex.getMessage());
                LOGGER.log(Level.SEVERE, "SQLException", sqlex);
                boolean bl = false;
                return bl;
            }
            finally {
                api.Terminate();
            }
        } else {
            LOGGER.severe("An API Session could not be established!  Cannot perform checkpoint operation!");
            listener.getLogger().println("An API Session could not be established!  Cannot perform checkpoint operation!");
            return false;
        }
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return CHECKPOINT_DESCRIPTOR;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

