/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.util.Secret;
import java.io.Serializable;
import java.util.UUID;
import org.kohsuke.stapler.DataBoundConstructor;

public final class IntegrityConfigurable
implements Serializable {
    private static final long serialVersionUID = 3627193531372714191L;
    private String configId;
    private String name;
    private String ipHostName;
    private int ipPort = 0;
    private String hostName;
    private int port;
    private boolean secure;
    private String userName;
    private Secret password;

    @DataBoundConstructor
    public IntegrityConfigurable(String configId, String ipHostName, int ipPort, String hostName, int port, boolean secure, String userName, String password) {
        this.configId = null == configId || configId.length() == 0 ? UUID.randomUUID().toString() : configId;
        this.ipHostName = ipHostName;
        this.ipPort = ipPort;
        this.hostName = hostName;
        this.port = port;
        this.secure = secure;
        this.userName = userName;
        this.password = Secret.fromString((String)password);
        this.name = String.format("%s@%s:%d", userName, hostName, port);
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setConfigId(String id) {
        this.configId = id;
    }

    public String getIpHostName() {
        return this.ipHostName;
    }

    public void setIpHostName(String ipHostName) {
        this.ipHostName = ipHostName;
    }

    public int getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(int ipPort) {
        this.ipPort = ipPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password.getEncryptedValue();
    }

    public Secret getSecretPassword() {
        return this.password;
    }

    public String getPasswordInPlainText() {
        return this.password.getPlainText();
    }

    public void setPassword(String password) {
        this.password = Secret.fromString((String)password);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getName() {
        this.name = String.format("%s@%s:%d", this.userName, this.hostName, this.port);
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof IntegrityConfigurable) {
            return ((IntegrityConfigurable)o).getHostName().equals(this.hostName) && ((IntegrityConfigurable)o).getPort() == this.port && ((IntegrityConfigurable)o).getUserName().equals(this.userName) && ((IntegrityConfigurable)o).getPasswordInPlainText().equals(this.password.getPlainText());
        }
        return false;
    }
}

