/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.remoting.VirtualChannel;
import hudson.scm.CM_PROJECT;
import hudson.scm.DerbyUtils;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegritySCM;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityDeleteNonMembersTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 6452098989064436149L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private final BuildListener listener;
    private final AbstractBuild<?, ?> build;
    private String alternateWorkspaceDir;
    private final IntegrityCMProject siProject;

    public IntegrityDeleteNonMembersTask(AbstractBuild<?, ?> build, BuildListener listener, String alternateWorkspaceDir, IntegrityCMProject siProject) {
        this.build = build;
        this.listener = listener;
        this.alternateWorkspaceDir = alternateWorkspaceDir;
        this.siProject = siProject;
    }

    public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        AbstractProject rootProject = this.getRootProject(this.build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            this.listener.getLogger().println("Integrity DeleteNonMembers is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        try {
            this.deleteNonMembers(this.build, this.listener);
        }
        catch (SQLException e) {
            this.listener.getLogger().println("A SQL Exception was caught!");
            this.listener.getLogger().println(e.getMessage());
            LOGGER.log(Level.SEVERE, "SQLException", e);
            return false;
        }
        return true;
    }

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    public void deleteNonMembers(AbstractBuild<?, ?> build, BuildListener listener) throws SQLException, IOException, InterruptedException {
        List projectMembersList = DerbyUtils.viewProject((String)this.siProject.getProjectCacheTable());
        FilePath workspace = build.getWorkspace();
        if (null != this.alternateWorkspaceDir && this.alternateWorkspaceDir.length() > 0) {
            workspace = new FilePath(new File(this.alternateWorkspaceDir));
        }
        ArrayList<FilePath> projectMembers = new ArrayList<FilePath>();
        for (Hashtable memberInfo : projectMembersList) {
            File targetFile = new File(workspace + memberInfo.get(CM_PROJECT.RELATIVE_FILE).toString());
            LOGGER.fine("Project Member: " + targetFile.getAbsolutePath());
            projectMembers.add(new FilePath(targetFile));
        }
        List folderList = DerbyUtils.getDirList((String)this.siProject.getProjectCacheTable());
        for (String folder : folderList) {
            File targetFile = new File(workspace + folder);
            LOGGER.fine("Project Folder: " + targetFile.getAbsolutePath());
            projectMembers.add(new FilePath(targetFile));
        }
        this.deleteNonMembers(workspace, projectMembers, listener);
    }

    private void deleteNonMembers(FilePath workspaceFolder, List<FilePath> projectMembers, BuildListener listener) throws IOException, InterruptedException {
        List workspaceMembers = workspaceFolder.list();
        for (FilePath workspaceMember : workspaceMembers) {
            LOGGER.fine("Workspace Member: " + workspaceMember);
            if (workspaceMember.exists() && !projectMembers.contains(workspaceMember)) {
                if (workspaceMember.isDirectory()) continue;
                listener.getLogger().println("Deleting file " + workspaceMember + " because the member does not exist in the Integrity project");
                workspaceMember.delete();
                continue;
            }
            if (!workspaceMember.isDirectory()) continue;
            this.deleteNonMembers(workspaceMember, projectMembers, listener);
        }
    }
}

