/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.ChangeLogParser;
import hudson.scm.DerbyUtils;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegrityChangeLogParser;
import hudson.scm.IntegrityCheckoutTask;
import hudson.scm.IntegrityCheckpointAction;
import hudson.scm.IntegrityConfigurable;
import hudson.scm.IntegrityDeleteNonMembersTask;
import hudson.scm.IntegrityRepositoryBrowser;
import hudson.scm.IntegrityRevisionState;
import hudson.scm.IntegritySCM;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.scm.browsers.IntegrityWebUI;
import hudson.util.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IntegritySCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = 7559894846609712683L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private static final Map<String, IntegrityCMProject> projects = new ConcurrentHashMap();
    public static final String NL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final int MIN_PORT_VALUE = 1;
    public static final int MAX_PORT_VALUE = 65535;
    public static final int DEFAULT_THREAD_POOL_SIZE = 5;
    public static final SimpleDateFormat SDF = new SimpleDateFormat("MMM dd, yyyy h:mm:ss a");
    private String ciServerURL;
    private String integrityURL;
    private IntegrityRepositoryBrowser browser;
    private String serverConfig;
    private String userName;
    private Secret password;
    private String configPath;
    private String includeList;
    private String excludeList;
    private String checkpointLabel;
    private String configurationName;
    private boolean cleanCopy;
    private boolean skipAuthorInfo = false;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private boolean checkpointBeforeBuild = false;
    private String alternateWorkspace;
    private boolean fetchChangedWorkspaceFiles = false;
    private boolean deleteNonMembers = false;
    private int checkoutThreadPoolSize = 5;

    @DataBoundConstructor
    public IntegritySCM(IntegrityRepositoryBrowser browser, String serverConfig, String userName, String password, String configPath, String includeList, String excludeList, boolean cleanCopy, String lineTerminator, boolean restoreTimestamp, boolean skipAuthorInfo, boolean checkpointBeforeBuild, String checkpointLabel, String alternateWorkspace, boolean fetchChangedWorkspaceFiles, boolean deleteNonMembers, int checkoutThreadPoolSize, String configurationName) {
        LOGGER.fine("IntegritySCM constructor has been invoked!");
        this.ciServerURL = Hudson.getInstance().getRootUrlFromRequest();
        this.browser = browser;
        this.serverConfig = serverConfig;
        this.userName = null != userName && userName.length() > 0 ? userName : DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(serverConfig).getUserName();
        this.password = null != password && password.length() > 0 ? Secret.fromString((String)password) : DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(serverConfig).getSecretPassword();
        this.configPath = configPath;
        this.includeList = includeList;
        this.excludeList = excludeList;
        this.cleanCopy = cleanCopy;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.skipAuthorInfo = skipAuthorInfo;
        this.checkpointBeforeBuild = checkpointBeforeBuild;
        this.checkpointLabel = checkpointLabel;
        this.alternateWorkspace = alternateWorkspace;
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
        this.deleteNonMembers = deleteNonMembers;
        this.checkoutThreadPoolSize = checkoutThreadPoolSize > 0 ? checkoutThreadPoolSize : 5;
        this.configurationName = configurationName;
        this.initIntegrityURL();
        LOGGER.fine("CI Server URL: " + this.ciServerURL);
        LOGGER.fine("URL: " + this.integrityURL);
        LOGGER.fine("Server Configuration: " + this.serverConfig);
        LOGGER.fine("Project User: " + this.userName);
        LOGGER.fine("Project User Password: " + this.password);
        LOGGER.fine("Configuration Name: " + this.configurationName);
        LOGGER.fine("Configuration Path: " + this.configPath);
        LOGGER.fine("Include Filter: " + this.includeList);
        LOGGER.fine("Exclude Filter: " + this.excludeList);
        LOGGER.fine("Line Terminator: " + this.lineTerminator);
        LOGGER.fine("Restore Timestamp: " + this.restoreTimestamp);
        LOGGER.fine("Clean: " + this.cleanCopy);
        LOGGER.fine("Skip Author Info: " + this.skipAuthorInfo);
        LOGGER.fine("Checkpoint Before Build: " + this.checkpointBeforeBuild);
        LOGGER.fine("Tag Name: " + this.checkpointLabel);
        LOGGER.fine("Alternate Workspace Directory: " + this.alternateWorkspace);
        LOGGER.fine("Fetch Changed Workspace Files: " + this.fetchChangedWorkspaceFiles);
        LOGGER.fine("Delete Non Members: " + this.deleteNonMembers);
        LOGGER.fine("Checkout Thread Pool Size: " + this.checkoutThreadPoolSize);
    }

    @Exported
    public IntegrityRepositoryBrowser getBrowser() {
        return this.browser == null ? new IntegrityWebUI(null) : this.browser;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password.getEncryptedValue();
    }

    public Secret getSecretPassword() {
        return this.password;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getIncludeList() {
        return this.includeList;
    }

    public String getExcludeList() {
        return this.excludeList;
    }

    public boolean getCleanCopy() {
        return this.cleanCopy;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public boolean getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public boolean getSkipAuthorInfo() {
        return this.skipAuthorInfo;
    }

    public boolean getCheckpointBeforeBuild() {
        return this.checkpointBeforeBuild;
    }

    public String getCheckpointLabel() {
        if (this.checkpointLabel == null || this.checkpointLabel.length() == 0) {
            return "${env['JOB_NAME']}-${env['BUILD_NUMBER']}-${new java.text.SimpleDateFormat(\"yyyy_MM_dd\").format(new Date())}";
        }
        return this.checkpointLabel;
    }

    public String getAlternateWorkspace() {
        return this.alternateWorkspace;
    }

    public boolean getFetchChangedWorkspaceFiles() {
        return this.fetchChangedWorkspaceFiles;
    }

    public boolean getDeleteNonMembers() {
        return this.deleteNonMembers;
    }

    public int getCheckoutThreadPoolSize() {
        return this.checkoutThreadPoolSize;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
        IntegrityConfigurable ic = ((DescriptorImpl)this.getDescriptor()).getConfiguration(serverConfig);
        this.integrityURL = (ic.getSecure() ? "https://" : "http://") + ic.getHostName() + ":" + String.valueOf(ic.getPort());
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Secret.fromString((String)password);
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setIncludeList(String includeList) {
        this.includeList = includeList;
    }

    public void setExcludeList(String excludeList) {
        this.excludeList = excludeList;
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public void setSkipAuthorInfo(boolean skipAuthorInfo) {
        this.skipAuthorInfo = skipAuthorInfo;
    }

    public void setCheckpointBeforeBuild(boolean checkpointBeforeBuild) {
        this.checkpointBeforeBuild = checkpointBeforeBuild;
    }

    public void setCheckpointLabel(String checkpointLabel) {
        this.checkpointLabel = checkpointLabel;
    }

    public void setAlternateWorkspace(String alternateWorkspace) {
        this.alternateWorkspace = alternateWorkspace;
    }

    public void setFetchChangedWorkspaceFiles(boolean fetchChangedWorkspaceFiles) {
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
    }

    public void setDeleteNonMembers(boolean deleteNonMembers) {
        this.deleteNonMembers = deleteNonMembers;
    }

    public void setCheckoutThreadPoolSize(int checkoutThreadPoolSize) {
        this.checkoutThreadPoolSize = checkoutThreadPoolSize;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    private void initIntegrityURL() {
        IntegrityConfigurable ic = ((DescriptorImpl)this.getDescriptor()).getConfiguration(this.serverConfig);
        this.integrityURL = (ic.getSecure() ? "https://" : "http://") + ic.getHostName() + ":" + String.valueOf(ic.getPort());
    }

    public IntegrityCMProject getIntegrityProject() {
        return IntegritySCM.findProject((String)this.configurationName);
    }

    public static IntegrityCMProject findProject(String configurationName) {
        return IntegritySCM.hasProject((String)configurationName) ? (IntegrityCMProject)projects.get(configurationName) : null;
    }

    public static boolean hasProject(String configurationName) {
        return projects.containsKey(configurationName);
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        LOGGER.fine("buildEnvVars() invoked...!");
        IntegrityConfigurable ic = ((DescriptorImpl)this.getDescriptor()).getConfiguration(this.serverConfig);
        env.put("MKSSI_PROJECT", IntegrityCheckpointAction.evalGroovyExpression(env, (String)this.configPath));
        env.put("MKSSI_HOST", ic.getHostName());
        env.put("MKSSI_PORT", String.valueOf(ic.getPort()));
        env.put("MKSSI_USER", ic.getUserName());
        IntegrityCMProject siProject = this.getIntegrityProject();
        if (null != siProject && siProject.isBuild()) {
            env.put("MKSSI_BUILD", this.getIntegrityProject().getProjectRevision());
        }
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        LOGGER.fine("calcRevisionsFromBuild() invoked...!");
        String projectCacheTable = null;
        String jobName = build.getProject().getName();
        try {
            projectCacheTable = DerbyUtils.getProjectCache((ConnectionPoolDataSource)((DescriptorImpl)this.getDescriptor()).getDataSource(), (String)jobName, (String)this.configurationName, (long)build.getNumber());
        }
        catch (SQLException sqlex) {
            LOGGER.severe("SQL Exception caught...");
            listener.getLogger().println("A SQL Exception was caught!");
            listener.getLogger().println(sqlex.getMessage());
            LOGGER.log(Level.SEVERE, "SQLException", sqlex);
        }
        return new IntegrityRevisionState(jobName, this.configurationName, projectCacheTable);
    }

    private Response initializeCMProject(APISession api, String projectCacheTable, String resolvedConfigPath) throws APIException {
        Command siProjectInfoCmd = new Command("si", "projectinfo");
        siProjectInfoCmd.addOption(new Option("project", resolvedConfigPath));
        LOGGER.fine("Preparing to execute si projectinfo for " + resolvedConfigPath);
        Response infoRes = api.runCommand(siProjectInfoCmd);
        LOGGER.fine(infoRes.getCommandString() + " returned " + infoRes.getExitCode());
        IntegrityCMProject siProject = new IntegrityCMProject(infoRes.getWorkItems().next(), projectCacheTable);
        siProject.setLineTerminator(this.lineTerminator);
        siProject.setRestoreTimestamp(this.restoreTimestamp);
        siProject.setSkipAuthorInfo(this.skipAuthorInfo);
        siProject.setCheckpointBeforeBuild(this.checkpointBeforeBuild);
        projects.put(this.configurationName, siProject);
        return infoRes;
    }

    private void applyMemberFilters(Command siViewProjectCmd) {
        if (null != this.includeList && this.includeList.length() > 0) {
            StringBuilder filterString = new StringBuilder();
            String[] filterTokens = this.includeList.split(",|;");
            for (int i = 0; i < filterTokens.length; ++i) {
                filterString.append(i > 0 ? "," : "");
                filterString.append("file:");
                filterString.append(filterTokens[i]);
            }
            siViewProjectCmd.addOption(new Option("filter", filterString.toString()));
        }
        if (null != this.excludeList && this.excludeList.length() > 0) {
            String[] filterTokens = this.excludeList.split(",|;");
            for (int i = 0; i < filterTokens.length; ++i) {
                if (filterTokens[i] == null) continue;
                siViewProjectCmd.addOption(new Option("filter", "!file:" + filterTokens[i]));
            }
        }
    }

    private Response initializeCMProjectMembers(APISession api) throws APIException, SQLException {
        IntegrityCMProject siProject = this.getIntegrityProject();
        Command siViewProjectCmd = new Command("si", "viewproject");
        siViewProjectCmd.addOption(new Option("recurse"));
        siViewProjectCmd.addOption(new Option("project", siProject.getConfigurationPath()));
        MultiValue mvFields = new MultiValue(",");
        mvFields.add("name");
        mvFields.add("context");
        mvFields.add("cpid");
        mvFields.add("memberrev");
        mvFields.add("membertimestamp");
        mvFields.add("memberdescription");
        mvFields.add("type");
        siViewProjectCmd.addOption(new Option("fields", mvFields));
        this.applyMemberFilters(siViewProjectCmd);
        LOGGER.fine("Preparing to execute si viewproject for " + siProject.getConfigurationPath());
        Response viewRes = api.runCommandWithInterim(siViewProjectCmd);
        DerbyUtils.parseProject((IntegrityCMProject)siProject, (WorkItemIterator)viewRes.getWorkItems());
        return viewRes;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        block21: {
            LOGGER.fine("Start execution of checkout() routine...!");
            String resolvedConfigPath = IntegrityCheckpointAction.evalGroovyExpression((Map)build.getEnvironment((TaskListener)listener), (String)this.configPath);
            listener.getLogger().println("Change Log: " + this.ciServerURL + build.getUrl() + "changes");
            listener.getLogger().println("Build Log: " + this.ciServerURL + build.getUrl() + "console");
            IntegrityConfigurable desSettings = DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(this.serverConfig);
            IntegrityConfigurable coSettings = new IntegrityConfigurable("TEMP_ID", desSettings.getIpHostName(), desSettings.getIpPort(), desSettings.getHostName(), desSettings.getPort(), desSettings.getSecure(), this.userName, this.password.getPlainText());
            APISession api = APISession.create((IntegrityConfigurable)coSettings);
            if (null == api) {
                listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
                return false;
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(changeLogFile), "UTF-8"));
            try {
                String projectCacheTable = DerbyUtils.registerProjectCache((ConnectionPoolDataSource)((DescriptorImpl)this.getDescriptor()).getDataSource(), (String)build.getProject().getName(), (String)this.configurationName, (long)build.getNumber());
                listener.getLogger().println("Preparing to execute si projectinfo for " + resolvedConfigPath);
                this.initializeCMProject(api, projectCacheTable, resolvedConfigPath);
                IntegrityCMProject siProject = this.getIntegrityProject();
                if (this.checkpointBeforeBuild) {
                    if (!siProject.isBuild()) {
                        listener.getLogger().println("Preparing to execute pre-build si checkpoint for " + siProject.getConfigurationPath());
                        Response res = siProject.checkpoint(api, IntegrityCheckpointAction.evalGroovyExpression((Map)build.getEnvironment((TaskListener)listener), (String)this.checkpointLabel));
                        LOGGER.fine(res.getCommandString() + " returned " + res.getExitCode());
                        WorkItem wi = res.getWorkItem(siProject.getConfigurationPath());
                        String chkpt = wi.getResult().getField("resultant").getItem().getId();
                        listener.getLogger().println("Successfully executed pre-build checkpoint for project " + siProject.getConfigurationPath() + ", new revision is " + chkpt);
                        Command siProjectInfoCmd = new Command("si", "projectinfo");
                        siProjectInfoCmd.addOption(new Option("project", siProject.getConfigurationPath() + "#forceJump=#b=" + chkpt));
                        Response infoRes = api.runCommand(siProjectInfoCmd);
                        siProject.initializeProject(infoRes.getWorkItems().next());
                    } else {
                        listener.getLogger().println("Cannot perform a pre-build checkpoint for build project configuration!");
                    }
                }
                listener.getLogger().println("Preparing to execute si viewproject for " + siProject.getConfigurationPath());
                this.initializeCMProjectMembers(api);
                String prevProjectCache = null;
                for (AbstractBuild previousBuild = build.getPreviousBuild(); null != previousBuild; previousBuild = previousBuild.getPreviousBuild()) {
                    prevProjectCache = DerbyUtils.getProjectCache((ConnectionPoolDataSource)((DescriptorImpl)this.getDescriptor()).getDataSource(), (String)build.getProject().getName(), (String)this.configurationName, (long)previousBuild.getNumber());
                    if (null == prevProjectCache || prevProjectCache.length() <= 0) continue;
                    LOGGER.fine("Found previous project state in build " + previousBuild.getNumber());
                    break;
                }
                if (null != prevProjectCache && prevProjectCache.length() > 0) {
                    DerbyUtils.compareBaseline((String)prevProjectCache, (String)projectCacheTable, (boolean)this.skipAuthorInfo, (APISession)api);
                } else {
                    LOGGER.fine("Cannot construct project state for any of the pevious builds!");
                    if (!this.skipAuthorInfo) {
                        DerbyUtils.primeAuthorInformation((String)projectCacheTable, (APISession)api);
                    }
                }
                List projectMembersList = DerbyUtils.viewProject((String)projectCacheTable);
                List dirList = DerbyUtils.getDirList((String)projectCacheTable);
                IntegrityCheckoutTask coTask = null;
                coTask = null == prevProjectCache || prevProjectCache.length() == 0 ? new IntegrityCheckoutTask(projectMembersList, dirList, this.alternateWorkspace, this.lineTerminator, this.restoreTimestamp, true, this.fetchChangedWorkspaceFiles, this.checkoutThreadPoolSize, listener, ((DescriptorImpl)this.getDescriptor()).getConfiguration(this.serverConfig)) : new IntegrityCheckoutTask(projectMembersList, dirList, this.alternateWorkspace, this.lineTerminator, this.restoreTimestamp, this.cleanCopy, this.fetchChangedWorkspaceFiles, this.checkoutThreadPoolSize, listener, ((DescriptorImpl)this.getDescriptor()).getConfiguration(this.serverConfig));
                if (((Boolean)workspace.act((FilePath.FileCallable)coTask)).booleanValue()) {
                    listener.getLogger().println("Saving current Integrity Project configuration...");
                    if (this.fetchChangedWorkspaceFiles) {
                        DerbyUtils.updateChecksum((String)projectCacheTable, (ConcurrentHashMap)coTask.getChecksumUpdates());
                    }
                    listener.getLogger().println("Writing build change log...");
                    writer.println(siProject.getChangeLog(String.valueOf(build.getNumber()), projectMembersList));
                    listener.getLogger().println("Change log successfully generated: " + changeLogFile.getAbsolutePath());
                    if (this.deleteNonMembers) {
                        IntegrityDeleteNonMembersTask deleteNonMembers = new IntegrityDeleteNonMembersTask(build, listener, this.alternateWorkspace, this.getIntegrityProject());
                        if (!((Boolean)workspace.act((FilePath.FileCallable)deleteNonMembers)).booleanValue()) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    break block21;
                }
                boolean bl = false;
                return bl;
            }
            catch (APIException aex) {
                LOGGER.severe("API Exception caught...");
                listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                LOGGER.severe(eh.getMessage());
                listener.getLogger().println(eh.getMessage());
                LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
                listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                boolean bl = false;
                return bl;
            }
            catch (SQLException sqlex) {
                LOGGER.severe("SQL Exception caught...");
                listener.getLogger().println("A SQL Exception was caught!");
                listener.getLogger().println(sqlex.getMessage());
                LOGGER.log(Level.SEVERE, "SQLException", sqlex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                api.Terminate();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        LOGGER.fine("compareRemoteRevisionWith() invoked...!");
        if (_baseline instanceof IntegrityRevisionState) {
            IntegrityRevisionState baseline = (IntegrityRevisionState)_baseline;
            AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
            if (null == lastBuild) {
                LOGGER.fine("No prior successful builds found!  Advise to build now!");
                return PollingResult.BUILD_NOW;
            }
            baseline = (IntegrityRevisionState)this.calcRevisionsFromBuild(lastBuild, launcher, listener);
            if (null != baseline && null != baseline.getProjectCache()) {
                IntegrityConfigurable desSettings = DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(this.serverConfig);
                IntegrityConfigurable coSettings = new IntegrityConfigurable("TEMP_ID", desSettings.getIpHostName(), desSettings.getIpPort(), desSettings.getHostName(), desSettings.getPort(), desSettings.getSecure(), this.userName, this.password.getPlainText());
                APISession api = APISession.create((IntegrityConfigurable)coSettings);
                if (null != api) {
                    try {
                        String projectCacheTable = DerbyUtils.registerProjectCache((ConnectionPoolDataSource)((DescriptorImpl)this.getDescriptor()).getDataSource(), (String)project.getName(), (String)this.configurationName, (long)0L);
                        String resolvedConfigPath = IntegrityCheckpointAction.evalGroovyExpression((Map)lastBuild.getBuildVariables(), (String)this.configPath);
                        listener.getLogger().println("Preparing to execute si projectinfo for " + resolvedConfigPath);
                        this.initializeCMProject(api, projectCacheTable, resolvedConfigPath);
                        listener.getLogger().println("Preparing to execute si viewproject for " + resolvedConfigPath);
                        this.initializeCMProjectMembers(api);
                        int changeCount = DerbyUtils.compareBaseline((String)baseline.getProjectCache(), (String)projectCacheTable, (boolean)this.skipAuthorInfo, (APISession)api);
                        if (changeCount > 0) {
                            listener.getLogger().println("Project contains changes a total of " + changeCount + " changes!");
                            PollingResult pollingResult = PollingResult.SIGNIFICANT;
                            return pollingResult;
                        }
                        listener.getLogger().println("No new changes detected in project!");
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    catch (APIException aex) {
                        LOGGER.severe("API Exception caught...");
                        listener.getLogger().println("An API Exception was caught!");
                        ExceptionHandler eh = new ExceptionHandler(aex);
                        LOGGER.severe(eh.getMessage());
                        listener.getLogger().println(eh.getMessage());
                        LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
                        listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                        aex.printStackTrace();
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    catch (SQLException sqlex) {
                        LOGGER.severe("SQL Exception caught...");
                        listener.getLogger().println("A SQL Exception was caught!");
                        listener.getLogger().println(sqlex.getMessage());
                        LOGGER.log(Level.SEVERE, "SQLException", sqlex);
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    finally {
                        api.Terminate();
                    }
                }
                listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
                return PollingResult.NO_CHANGES;
            }
            LOGGER.fine("No prior Integrity Project state can be found!  Advice to build now!");
            return PollingResult.BUILD_NOW;
        }
        LOGGER.severe("This method was called with the wrong SCMRevisionState class!");
        return PollingResult.NO_CHANGES;
    }

    public ChangeLogParser createChangeLogParser() {
        LOGGER.fine("createChangeLogParser() invoked...!");
        return new IntegrityChangeLogParser(this.integrityURL);
    }

    public SCMDescriptor<IntegritySCM> getDescriptor() {
        LOGGER.fine("IntegritySCM.getDescriptor() invoked...!");
        return DescriptorImpl.INTEGRITY_DESCRIPTOR;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ IntegrityRepositoryBrowser access$102(IntegritySCM x0, IntegrityRepositoryBrowser x1) {
        x0.browser = x1;
        return x0.browser;
    }

    static /* synthetic */ IntegrityRepositoryBrowser access$100(IntegritySCM x0) {
        return x0.browser;
    }
}

