/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegritySCM;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyUtils {
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_SYS_HOME_PROPERTY = "derby.system.home";
    public static final String DERBY_URL_PREFIX = "jdbc:derby:";
    private static final String DERBY_DB_NAME = "IntegritySCM";
    public static final String CREATE_INTEGRITY_SCM_REGISTRY = "CREATE TABLE INTEGRITY_SCM_REGISTRY (ID INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), JOB_NAME VARCHAR(256) NOT NULL, CONFIGURATION_NAME VARCHAR(50) NOT NULL, PROJECT_CACHE_TABLE VARCHAR(50) NOT NULL, BUILD_NUMBER BIGINT NOT NULL)";
    public static final String SELECT_REGISTRY_1 = "SELECT ID FROM INTEGRITY_SCM_REGISTRY WHERE ID = 1";
    public static final String SELECT_REGISTRY_TABLE = "SELECT PROJECT_CACHE_TABLE FROM INTEGRITY_SCM_REGISTRY WHERE JOB_NAME = ? AND CONFIGURATION_NAME = ? AND BUILD_NUMBER = ?";
    public static final String INSERT_REGISTRY_ENTRY = "INSERT INTO INTEGRITY_SCM_REGISTRY (JOB_NAME, CONFIGURATION_NAME, PROJECT_CACHE_TABLE, BUILD_NUMBER) VALUES (?, ?, ?, ?)";
    public static final String SELECT_REGISTRY_DISTINCT_PROJECTS = "SELECT DISTINCT JOB_NAME FROM INTEGRITY_SCM_REGISTRY";
    public static final String SELECT_REGISTRY_PROJECTS = "SELECT PROJECT_CACHE_TABLE FROM INTEGRITY_SCM_REGISTRY WHERE JOB_NAME = ? AND CONFIGURATION_NAME = ? ORDER BY BUILD_NUMBER DESC";
    public static final String SELECT_REGISTRY_PROJECT = "SELECT PROJECT_CACHE_TABLE FROM INTEGRITY_SCM_REGISTRY WHERE JOB_NAME = ?";
    public static final String DROP_REGISTRY_ENTRY = "DELETE FROM INTEGRITY_SCM_REGISTRY WHERE PROJECT_CACHE_TABLE = ?";
    public static final String CREATE_PROJECT_TABLE = "CREATE TABLE CM_PROJECT (" + (Object)((Object)CM_PROJECT.ID) + " INTEGER NOT NULL " + "PRIMARY KEY GENERATED ALWAYS AS IDENTITY " + "(START WITH 1, INCREMENT BY 1), " + (Object)((Object)CM_PROJECT.TYPE) + " SMALLINT NOT NULL, " + (Object)((Object)CM_PROJECT.NAME) + " VARCHAR(32500) NOT NULL, " + (Object)((Object)CM_PROJECT.MEMBER_ID) + " VARCHAR(32500), " + (Object)((Object)CM_PROJECT.TIMESTAMP) + " TIMESTAMP, " + (Object)((Object)CM_PROJECT.DESCRIPTION) + " CLOB(4 M), " + (Object)((Object)CM_PROJECT.AUTHOR) + " VARCHAR(100), " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + " VARCHAR(32500), " + (Object)((Object)CM_PROJECT.REVISION) + " VARCHAR(32500), " + (Object)((Object)CM_PROJECT.OLD_REVISION) + " VARCHAR(32500), " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + " VARCHAR(32500), " + (Object)((Object)CM_PROJECT.CHECKSUM) + " VARCHAR(32), " + (Object)((Object)CM_PROJECT.DELTA) + " SMALLINT)";
    public static final String DROP_PROJECT_TABLE = "DROP TABLE CM_PROJECT";
    public static final String SELECT_MEMBER_1 = "SELECT " + (Object)((Object)CM_PROJECT.ID) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.ID) + " = 1";
    public static final String INSERT_MEMBER_RECORD = "INSERT INTO CM_PROJECT (" + (Object)((Object)CM_PROJECT.TYPE) + ", " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.MEMBER_ID) + ", " + (Object)((Object)CM_PROJECT.TIMESTAMP) + ", " + (Object)((Object)CM_PROJECT.DESCRIPTION) + ", " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + ", " + (Object)((Object)CM_PROJECT.REVISION) + ", " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + ") " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String BASELINE_SELECT = "SELECT " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.MEMBER_ID) + ", " + (Object)((Object)CM_PROJECT.TIMESTAMP) + ", " + (Object)((Object)CM_PROJECT.DESCRIPTION) + ", " + (Object)((Object)CM_PROJECT.AUTHOR) + ", " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + ", " + (Object)((Object)CM_PROJECT.REVISION) + ", " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + ", " + (Object)((Object)CM_PROJECT.CHECKSUM) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 0 AND (" + (Object)((Object)CM_PROJECT.DELTA) + " IS NULL OR " + (Object)((Object)CM_PROJECT.DELTA) + " <> 3)";
    public static final String DELTA_SELECT = "SELECT " + (Object)((Object)CM_PROJECT.TYPE) + ", " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.MEMBER_ID) + ", " + (Object)((Object)CM_PROJECT.TIMESTAMP) + ", " + (Object)((Object)CM_PROJECT.DESCRIPTION) + ", " + (Object)((Object)CM_PROJECT.AUTHOR) + ", " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + ", " + (Object)((Object)CM_PROJECT.REVISION) + ", " + (Object)((Object)CM_PROJECT.OLD_REVISION) + ", " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + ", " + (Object)((Object)CM_PROJECT.CHECKSUM) + ", " + (Object)((Object)CM_PROJECT.DELTA) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 0";
    public static final String PROJECT_SELECT = "SELECT " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.MEMBER_ID) + ", " + (Object)((Object)CM_PROJECT.TIMESTAMP) + ", " + (Object)((Object)CM_PROJECT.DESCRIPTION) + ", " + (Object)((Object)CM_PROJECT.AUTHOR) + ", " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + ", " + (Object)((Object)CM_PROJECT.REVISION) + ", " + (Object)((Object)CM_PROJECT.OLD_REVISION) + ", " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + ", " + (Object)((Object)CM_PROJECT.CHECKSUM) + ", " + (Object)((Object)CM_PROJECT.DELTA) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 0 ORDER BY " + (Object)((Object)CM_PROJECT.NAME) + " ASC";
    public static final String SUB_PROJECT_SELECT = "SELECT " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + ", " + (Object)((Object)CM_PROJECT.REVISION) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 1 ORDER BY " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + " ASC";
    public static final String AUTHOR_SELECT = "SELECT " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.MEMBER_ID) + ", " + (Object)((Object)CM_PROJECT.AUTHOR) + ", " + (Object)((Object)CM_PROJECT.CONFIG_PATH) + ", " + (Object)((Object)CM_PROJECT.REVISION) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 0 AND (" + (Object)((Object)CM_PROJECT.DELTA) + " IS NULL OR " + (Object)((Object)CM_PROJECT.DELTA) + " <> 3)";
    public static final String DIR_SELECT = "SELECT DISTINCT " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 1 ORDER BY " + (Object)((Object)CM_PROJECT.RELATIVE_FILE) + " ASC";
    public static final String CHECKSUM_UPDATE = "SELECT " + (Object)((Object)CM_PROJECT.NAME) + ", " + (Object)((Object)CM_PROJECT.CHECKSUM) + " FROM CM_PROJECT WHERE " + (Object)((Object)CM_PROJECT.TYPE) + " = 0 AND (" + (Object)((Object)CM_PROJECT.DELTA) + " IS NULL OR " + (Object)((Object)CM_PROJECT.DELTA) + " <> 3)";

    public static final CM_PROJECT getEnum(String name) {
        CM_PROJECT[] values = CM_PROJECT.values();
        for (int i = 0; i < values.length; ++i) {
            if (!name.equals(values[i].toString())) continue;
            return values[i];
        }
        return CM_PROJECT.UNDEFINED;
    }

    public static final String getUUIDTableName() {
        return "SCM_" + UUID.randomUUID().toString().replace('-', '_');
    }

    public static void loadDerbyDriver() {
        try {
            LOGGER.fine("Loading derby driver: org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName(DERBY_DRIVER);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.severe("Failed to load derby driver: org.apache.derby.jdbc.EmbeddedDriver");
            LOGGER.severe(ex.getMessage());
            LOGGER.log(Level.SEVERE, "ClassNotFoundException", ex);
        }
    }

    public static ConnectionPoolDataSource createConnectionPoolDataSource(String derbyHome) {
        EmbeddedConnectionPoolDataSource dataSource = new EmbeddedConnectionPoolDataSource();
        dataSource.setCreateDatabase("create");
        dataSource.setDataSourceName(DERBY_URL_PREFIX + derbyHome.replace('\\', '/') + "/" + DERBY_DB_NAME);
        dataSource.setDatabaseName(derbyHome.replace('\\', '/') + "/" + DERBY_DB_NAME);
        return dataSource;
    }

    public static synchronized boolean executeStmt(ConnectionPoolDataSource dataSource, String sql) throws SQLException {
        boolean success = false;
        Connection db = null;
        Statement stmt = null;
        try {
            LOGGER.fine("Preparing to execute " + sql);
            db = dataSource.getPooledConnection().getConnection();
            stmt = db.createStatement();
            success = stmt.execute(sql);
            LOGGER.fine("Executed...!");
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        finally {
            if (null != stmt) {
                stmt.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return success;
    }

    public static synchronized boolean createRegistry(ConnectionPoolDataSource dataSource) {
        boolean tableCreated = false;
        try {
            if (DerbyUtils.executeStmt(dataSource, SELECT_REGISTRY_1)) {
                LOGGER.fine("Integrity SCM cache registry table exists...");
                tableCreated = true;
            }
        }
        catch (SQLException ex) {
            LOGGER.fine(ex.getMessage());
            try {
                LOGGER.fine("Integrity SCM cache registry doesn't exist, creating...");
                tableCreated = DerbyUtils.executeStmt(dataSource, CREATE_INTEGRITY_SCM_REGISTRY);
            }
            catch (SQLException sqlex) {
                LOGGER.fine("Failed to create Integrity SCM cache registry table!");
                LOGGER.log(Level.SEVERE, "SQLException", sqlex);
                tableCreated = false;
            }
        }
        return tableCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String registerProjectCache(ConnectionPoolDataSource dataSource, String jobName, String configurationName, long buildNumber) throws SQLException {
        String cacheTableName = "";
        Connection db = null;
        Statement select = null;
        Statement insert = null;
        ResultSet rs = null;
        try {
            db = dataSource.getPooledConnection().getConnection();
            cacheTableName = DerbyUtils.getProjectCache(dataSource, jobName, configurationName, buildNumber);
            if (null == cacheTableName || cacheTableName.length() == 0) {
                String uuid = DerbyUtils.getUUIDTableName();
                insert = db.prepareStatement(INSERT_REGISTRY_ENTRY);
                insert.clearParameters();
                insert.setString(1, jobName);
                insert.setString(2, configurationName);
                insert.setString(3, uuid);
                insert.setLong(4, buildNumber);
                insert.executeUpdate();
                cacheTableName = uuid;
            }
        }
        catch (SQLException sqlex) {
            LOGGER.fine(String.format("Failed to create Integrity SCM cache registry entry for %s/%s/%d!", jobName, configurationName, buildNumber));
            LOGGER.log(Level.SEVERE, "SQLException", sqlex);
        }
        finally {
            if (null != select) {
                select.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != insert) {
                insert.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return cacheTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getProjectCache(ConnectionPoolDataSource dataSource, String jobName, String configurationName, long buildNumber) throws SQLException {
        String cacheTableName = "";
        Connection db = null;
        Statement select = null;
        Statement insert = null;
        ResultSet rs = null;
        try {
            db = dataSource.getPooledConnection().getConnection();
            select = db.prepareStatement(SELECT_REGISTRY_TABLE, 1004, 1007);
            select.setString(1, jobName);
            select.setString(2, configurationName);
            select.setLong(3, buildNumber);
            rs = select.executeQuery();
            if (DerbyUtils.getRowCount(rs) > 0) {
                rs.next();
                cacheTableName = rs.getString("PROJECT_CACHE_TABLE");
            }
        }
        catch (SQLException sqlex) {
            LOGGER.fine(String.format("Failed to get Integrity SCM cache registry entry for %s/%s/%d!", jobName, configurationName, buildNumber));
            LOGGER.log(Level.SEVERE, "SQLException", sqlex);
        }
        finally {
            if (null != select) {
                select.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != insert) {
                insert.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return cacheTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<String> getDistinctJobNames(ConnectionPoolDataSource dataSource) throws SQLException {
        ArrayList<String> jobsList = new ArrayList<String>();
        Connection db = null;
        Statement select = null;
        Statement delete = null;
        ResultSet rs = null;
        try {
            db = dataSource.getPooledConnection().getConnection();
            LOGGER.fine("Preparing to execute SELECT DISTINCT JOB_NAME FROM INTEGRITY_SCM_REGISTRY");
            select = db.prepareStatement(SELECT_REGISTRY_DISTINCT_PROJECTS);
            rs = select.executeQuery();
            LOGGER.fine("Executed!");
            while (rs.next()) {
                String job = rs.getString("JOB_NAME");
                jobsList.add(job);
                LOGGER.fine(String.format("Adding job '%s' from the list of registered projects cache", job));
            }
        }
        catch (SQLException sqlex) {
            LOGGER.fine("Failed to run distinct jobs query!");
            LOGGER.log(Level.SEVERE, "SQLException", sqlex);
        }
        finally {
            if (null != select) {
                select.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != delete) {
                delete.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return jobsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deleteProjectCache(ConnectionPoolDataSource dataSource, String jobName) throws SQLException {
        Connection db = null;
        Statement select = null;
        Statement delete = null;
        ResultSet rs = null;
        try {
            db = dataSource.getPooledConnection().getConnection();
            select = db.prepareStatement(SELECT_REGISTRY_PROJECT, 1004, 1007);
            select.setString(1, jobName);
            delete = db.prepareStatement(DROP_REGISTRY_ENTRY);
            rs = select.executeQuery();
            if (DerbyUtils.getRowCount(rs) > 0) {
                while (rs.next()) {
                    String cacheTableName = rs.getString("PROJECT_CACHE_TABLE");
                    DerbyUtils.executeStmt(dataSource, DROP_PROJECT_TABLE.replaceFirst("CM_PROJECT", cacheTableName));
                    delete.setString(1, cacheTableName);
                    delete.addBatch();
                }
                delete.executeBatch();
            }
        }
        catch (SQLException sqlex) {
            LOGGER.fine("Failed to purge project '" + jobName + "' from Integrity SCM cache registry!");
            LOGGER.log(Level.SEVERE, "SQLException", sqlex);
        }
        finally {
            if (null != select) {
                select.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != delete) {
                delete.close();
            }
            if (null != db) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void cleanupProjectCache(ConnectionPoolDataSource dataSource, String jobName, String configurationName) throws SQLException {
        Connection db = null;
        Statement select = null;
        Statement delete = null;
        ResultSet rs = null;
        try {
            db = dataSource.getPooledConnection().getConnection();
            select = db.prepareStatement(SELECT_REGISTRY_PROJECTS, 1004, 1007);
            select.setString(1, jobName);
            select.setString(2, configurationName);
            delete = db.prepareStatement(DROP_REGISTRY_ENTRY);
            rs = select.executeQuery();
            int rowCount = DerbyUtils.getRowCount(rs);
            LOGGER.fine("Cache entries for " + jobName + "/" + configurationName + " = " + rowCount);
            if (rowCount > 2) {
                int deleteCount = 0;
                rs.next();
                rs.next();
                while (rs.next()) {
                    ++deleteCount;
                    String cacheTableName = rs.getString("PROJECT_CACHE_TABLE");
                    DerbyUtils.executeStmt(dataSource, DROP_PROJECT_TABLE.replaceFirst("CM_PROJECT", cacheTableName));
                    LOGGER.fine(String.format("Deleting old cache entry for %s/%s/%s", jobName, configurationName, cacheTableName));
                    delete.setString(1, cacheTableName);
                    delete.addBatch();
                }
                if (deleteCount > 0) {
                    delete.executeBatch();
                }
            }
        }
        catch (SQLException sqlex) {
            LOGGER.fine(String.format("Failed to clear old cache for project '%s' from Integrity SCM cache registry!", jobName));
            LOGGER.log(Level.SEVERE, "SQLException", sqlex);
        }
        finally {
            if (null != select) {
                select.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != delete) {
                delete.close();
            }
            if (null != db) {
                db.close();
            }
        }
    }

    public static synchronized boolean createCMProjectTables(ConnectionPoolDataSource dataSource, String tableName) {
        boolean tableCreated = false;
        try {
            if (DerbyUtils.executeStmt(dataSource, SELECT_MEMBER_1.replaceFirst("CM_PROJECT", tableName))) {
                try {
                    LOGGER.fine("A prior set of Integrity SCM cache tables detected, dropping...");
                    tableCreated = DerbyUtils.executeStmt(dataSource, DROP_PROJECT_TABLE.replaceFirst("CM_PROJECT", tableName));
                    LOGGER.fine("Recreating a fresh set of Integrity SCM cache tables...");
                    tableCreated = DerbyUtils.executeStmt(dataSource, CREATE_PROJECT_TABLE.replaceFirst("CM_PROJECT", tableName));
                }
                catch (SQLException ex) {
                    LOGGER.fine(String.format("Failed to create Integrity SCM project cache table '%s'", tableName));
                    LOGGER.log(Level.SEVERE, "SQLException", ex);
                    tableCreated = false;
                }
            }
        }
        catch (SQLException ex) {
            LOGGER.fine(ex.getMessage());
            try {
                LOGGER.fine(String.format("Integrity SCM cache table '%s' does not exist, creating...", tableName));
                tableCreated = DerbyUtils.executeStmt(dataSource, CREATE_PROJECT_TABLE.replaceFirst("CM_PROJECT", tableName));
            }
            catch (SQLException sqlex) {
                LOGGER.fine(String.format("Failed to create Integrity SCM project cache table '%s'", tableName));
                LOGGER.log(Level.SEVERE, "SQLException", sqlex);
                tableCreated = false;
            }
        }
        return tableCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<CM_PROJECT, Object> getRowData(ResultSet rs) throws SQLException, IOException {
        Hashtable<CM_PROJECT, Object> rowData = new Hashtable<CM_PROJECT, Object>();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columns = rsMetaData.getColumnCount();
        block24: for (int i = 1; i <= columns; ++i) {
            int columnType = rsMetaData.getColumnType(i);
            Object value = null;
            switch (columnType) {
                case 2003: {
                    value = rs.getArray(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getArray(i));
                    continue block24;
                }
                case -5: 
                case 2: 
                case 7: {
                    value = rs.getLong(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getLong(i));
                    continue block24;
                }
                case 2004: {
                    InputStream is = null;
                    try {
                        is = rs.getBlob(i).getBinaryStream();
                        byte[] bytes = IOUtils.toByteArray((InputStream)is);
                        rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), bytes);
                        continue block24;
                    }
                    finally {
                        if (null != is) {
                            is.close();
                        }
                    }
                }
                case 16: {
                    value = rs.getBoolean(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getBoolean(i));
                    continue block24;
                }
                case 2005: {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(rs.getClob(i).getCharacterStream());
                        String line = null;
                        StringBuilder sb = new StringBuilder();
                        while (null != (line = reader.readLine())) {
                            sb.append(line + IntegritySCM.NL);
                        }
                        rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), sb.toString());
                        continue block24;
                    }
                    finally {
                        if (null != reader) {
                            reader.close();
                        }
                    }
                }
                case 91: {
                    value = rs.getDate(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getDate(i));
                    continue block24;
                }
                case 3: {
                    value = rs.getBigDecimal(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getBigDecimal(i));
                    continue block24;
                }
                case 8: {
                    value = rs.getDouble(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getDouble(i));
                    continue block24;
                }
                case 6: {
                    value = Float.valueOf(rs.getFloat(i));
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), Float.valueOf(rs.getFloat(i)));
                    continue block24;
                }
                case 4: {
                    value = rs.getInt(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getInt(i));
                    continue block24;
                }
                case 2000: {
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getObject(i));
                    continue block24;
                }
                case -6: 
                case 5: {
                    value = rs.getShort(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getShort(i));
                    continue block24;
                }
                case 92: {
                    value = rs.getTime(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getTime(i));
                    continue block24;
                }
                case 93: {
                    value = rs.getTimestamp(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getTimestamp(i));
                    continue block24;
                }
                default: {
                    value = rs.getString(i);
                    if (rs.wasNull()) continue block24;
                    rowData.put(DerbyUtils.getEnum(rsMetaData.getColumnLabel(i)), rs.getString(i));
                }
            }
        }
        return rowData;
    }

    public static int getRowCount(ResultSet rs) throws SQLException {
        int rowCount = 0;
        int currentRow = rs.getRow();
        int n = rowCount = rs.last() ? rs.getRow() : rowCount;
        if (currentRow == 0) {
            rs.beforeFirst();
        } else {
            rs.absolute(currentRow);
        }
        return rowCount;
    }

    public static String fixDescription(String desc) {
        String description = desc.replace('\u2013', '-');
        return description.replaceAll("<!\\[CDATA\\[", "< ! [ CDATA [").replaceAll("\\]\\]>", "] ] >");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int compareBaseline(String baselineProjectCache, String projectCacheTable, boolean skipAuthorInfo, APISession api) throws SQLException, IOException {
        int changeCount = 0;
        Connection db = null;
        Statement baselineSelect = null;
        Statement pjSelect = null;
        ResultSet baselineRS = null;
        ResultSet rs = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            baselineSelect = db.createStatement();
            String baselineSelectSql = BASELINE_SELECT.replaceFirst("CM_PROJECT", baselineProjectCache);
            LOGGER.fine("Attempting to execute query " + baselineSelectSql);
            baselineRS = baselineSelect.executeQuery(baselineSelectSql);
            Hashtable baselinePJ = new Hashtable();
            while (baselineRS.next()) {
                Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(baselineRS);
                Hashtable<CM_PROJECT, Object> memberInfo = new Hashtable<CM_PROJECT, Object>();
                memberInfo.put(CM_PROJECT.MEMBER_ID, null == rowHash.get((Object)CM_PROJECT.MEMBER_ID) ? "" : rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString());
                memberInfo.put(CM_PROJECT.TIMESTAMP, null == rowHash.get((Object)CM_PROJECT.TIMESTAMP) ? "" : (Date)rowHash.get((Object)CM_PROJECT.TIMESTAMP));
                memberInfo.put(CM_PROJECT.DESCRIPTION, null == rowHash.get((Object)CM_PROJECT.DESCRIPTION) ? "" : rowHash.get((Object)CM_PROJECT.DESCRIPTION).toString());
                memberInfo.put(CM_PROJECT.AUTHOR, null == rowHash.get((Object)CM_PROJECT.AUTHOR) ? "" : rowHash.get((Object)CM_PROJECT.AUTHOR).toString());
                memberInfo.put(CM_PROJECT.CONFIG_PATH, null == rowHash.get((Object)CM_PROJECT.CONFIG_PATH) ? "" : rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString());
                memberInfo.put(CM_PROJECT.REVISION, null == rowHash.get((Object)CM_PROJECT.REVISION) ? "" : rowHash.get((Object)CM_PROJECT.REVISION).toString());
                memberInfo.put(CM_PROJECT.RELATIVE_FILE, null == rowHash.get((Object)CM_PROJECT.RELATIVE_FILE) ? "" : rowHash.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                memberInfo.put(CM_PROJECT.CHECKSUM, null == rowHash.get((Object)CM_PROJECT.CHECKSUM) ? "" : rowHash.get((Object)CM_PROJECT.CHECKSUM).toString());
                baselinePJ.put(rowHash.get((Object)CM_PROJECT.NAME).toString(), memberInfo);
            }
            pjSelect = db.createStatement(1004, 1008);
            String pjSelectSql = DELTA_SELECT.replaceFirst("CM_PROJECT", projectCacheTable);
            LOGGER.fine("Attempting to execute query " + pjSelectSql);
            rs = pjSelect.executeQuery(pjSelectSql);
            for (int i = 1; i <= DerbyUtils.getRowCount(rs); ++i) {
                rs.absolute(i);
                Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(rs);
                String memberName = rowHash.get((Object)CM_PROJECT.NAME).toString();
                LOGGER.fine("Comparing file against baseline " + memberName);
                Hashtable baselineMemberInfo = (Hashtable)baselinePJ.get(memberName);
                if (null != baselineMemberInfo) {
                    String oldRevision = baselineMemberInfo.get((Object)CM_PROJECT.REVISION).toString();
                    if (!rowHash.get((Object)CM_PROJECT.REVISION).toString().equals(oldRevision)) {
                        rs.updateString(CM_PROJECT.OLD_REVISION.toString(), oldRevision);
                        if (!skipAuthorInfo) {
                            rs.updateString(CM_PROJECT.AUTHOR.toString(), IntegrityCMMember.getAuthor(api, rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString(), rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString(), rowHash.get((Object)CM_PROJECT.REVISION).toString()));
                        }
                        rs.updateShort(CM_PROJECT.DELTA.toString(), (short)2);
                        LOGGER.fine("... " + memberName + " revision changed - new revision is " + rowHash.get((Object)CM_PROJECT.REVISION).toString());
                        ++changeCount;
                    } else {
                        if (null != baselineMemberInfo.get((Object)CM_PROJECT.AUTHOR)) {
                            rs.updateString(CM_PROJECT.AUTHOR.toString(), baselineMemberInfo.get((Object)CM_PROJECT.AUTHOR).toString());
                        }
                        if (null != baselineMemberInfo.get((Object)CM_PROJECT.CHECKSUM)) {
                            rs.updateString(CM_PROJECT.CHECKSUM.toString(), baselineMemberInfo.get((Object)CM_PROJECT.CHECKSUM).toString());
                        }
                        rs.updateShort(CM_PROJECT.DELTA.toString(), (short)0);
                    }
                    baselinePJ.remove(memberName);
                } else {
                    if (!skipAuthorInfo) {
                        rs.updateString(CM_PROJECT.AUTHOR.toString(), IntegrityCMMember.getAuthor(api, rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString(), rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString(), rowHash.get((Object)CM_PROJECT.REVISION).toString()));
                    }
                    rs.updateShort(CM_PROJECT.DELTA.toString(), (short)1);
                    LOGGER.fine("... " + memberName + " new file - revision is " + rowHash.get((Object)CM_PROJECT.REVISION).toString());
                    ++changeCount;
                }
                rs.updateRow();
            }
            Enumeration deletedMembers = baselinePJ.keys();
            while (deletedMembers.hasMoreElements()) {
                ++changeCount;
                String memberName = (String)deletedMembers.nextElement();
                Hashtable memberInfo = (Hashtable)baselinePJ.get(memberName);
                rs.moveToInsertRow();
                rs.updateShort(CM_PROJECT.TYPE.toString(), (short)0);
                rs.updateString(CM_PROJECT.NAME.toString(), memberName);
                rs.updateString(CM_PROJECT.MEMBER_ID.toString(), memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString());
                if (memberInfo.get((Object)CM_PROJECT.TIMESTAMP) instanceof Date) {
                    Timestamp ts = new Timestamp(((Date)memberInfo.get((Object)CM_PROJECT.TIMESTAMP)).getTime());
                    rs.updateTimestamp(CM_PROJECT.TIMESTAMP.toString(), ts);
                }
                rs.updateString(CM_PROJECT.DESCRIPTION.toString(), memberInfo.get((Object)CM_PROJECT.DESCRIPTION).toString());
                rs.updateString(CM_PROJECT.AUTHOR.toString(), memberInfo.get((Object)CM_PROJECT.AUTHOR).toString());
                rs.updateString(CM_PROJECT.CONFIG_PATH.toString(), memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString());
                rs.updateString(CM_PROJECT.REVISION.toString(), memberInfo.get((Object)CM_PROJECT.REVISION).toString());
                rs.updateString(CM_PROJECT.RELATIVE_FILE.toString(), memberInfo.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                rs.updateShort(CM_PROJECT.DELTA.toString(), (short)3);
                rs.insertRow();
                rs.moveToCurrentRow();
                LOGGER.fine("... " + memberName + " file dropped - revision was " + memberInfo.get((Object)CM_PROJECT.REVISION).toString());
            }
            db.commit();
        }
        finally {
            if (null != baselineRS) {
                baselineRS.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != baselineSelect) {
                baselineSelect.close();
            }
            if (null != pjSelect) {
                pjSelect.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void parseProject(IntegrityCMProject siProject, WorkItemIterator wit) throws APIException, SQLException {
        Connection db = null;
        Statement insert = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            DerbyUtils.createCMProjectTables(IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource(), siProject.getProjectCacheTable());
            Hashtable<String, String> pjConfigHash = new Hashtable<String, String>();
            pjConfigHash.put(siProject.getProjectName(), siProject.getConfigurationPath());
            String projectRoot = siProject.getProjectName().substring(0, siProject.getProjectName().lastIndexOf(47));
            String insertSQL = INSERT_MEMBER_RECORD.replaceFirst("CM_PROJECT", siProject.getProjectCacheTable());
            LOGGER.fine("Attempting to execute query " + insertSQL);
            insert = db.prepareStatement(insertSQL);
            while (wit.hasNext()) {
                String entryType;
                WorkItem wi = wit.next();
                String string = entryType = null != wi.getField("type") ? wi.getField("type").getValueAsString() : "";
                if (wi.getModelType().equals("si.Subproject")) {
                    if (entryType.equalsIgnoreCase("pending-sharesubproject")) {
                        LOGGER.warning("Skipping " + entryType + " " + wi.getId());
                        continue;
                    }
                    pjConfigHash.put(wi.getField("name").getValueAsString(), wi.getId());
                    String pjDir = wi.getField("name").getValueAsString().substring(projectRoot.length());
                    pjDir = pjDir.substring(0, pjDir.lastIndexOf(47));
                    insert.clearParameters();
                    insert.setShort(1, (short)1);
                    insert.setString(2, wi.getField("name").getValueAsString());
                    insert.setString(3, wi.getId());
                    insert.setTimestamp(4, new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    insert.setClob(5, new StringReader(""));
                    insert.setString(6, wi.getId());
                    String subProjectRev = "";
                    if (wi.contains("memberrev")) {
                        subProjectRev = wi.getField("memberrev").getItem().getId();
                    }
                    insert.setString(7, subProjectRev);
                    insert.setString(8, pjDir);
                    insert.executeUpdate();
                    continue;
                }
                if (wi.getModelType().equals("si.Member")) {
                    if (entryType.endsWith("in-pending-sub") || entryType.equalsIgnoreCase("pending-add") || entryType.equalsIgnoreCase("pending-move-to-update") || entryType.equalsIgnoreCase("pending-rename-update")) {
                        LOGGER.warning("Skipping " + entryType + " " + wi.getId());
                        continue;
                    }
                    String parentProject = wi.getField("parent").getValueAsString();
                    String memberName = wi.getField("name").getValueAsString();
                    LOGGER.fine("Member context: " + wi.getContext());
                    LOGGER.fine("Member parent: " + parentProject);
                    LOGGER.fine("Member name: " + memberName);
                    if (memberName.startsWith(projectRoot)) {
                        String description;
                        block18: {
                            description = "";
                            try {
                                if (null == wi.getField("memberdescription") || null == wi.getField("memberdescription").getValueAsString()) break block18;
                                description = DerbyUtils.fixDescription(wi.getField("memberdescription").getValueAsString());
                            }
                            catch (NoSuchElementException e) {
                                LOGGER.warning("Cannot obtain the value for 'memberdescription' in API response for member: " + memberName);
                                LOGGER.info("API Response has the following fields available: ");
                                Iterator fieldsIterator = wi.getFields();
                                while (fieldsIterator.hasNext()) {
                                    Field apiField = (Field)fieldsIterator.next();
                                    LOGGER.info("Name: " + apiField.getName() + ", Value: " + apiField.getValueAsString());
                                }
                            }
                        }
                        Date timestamp = new Date();
                        try {
                            Field timeFld = wi.getField("membertimestamp");
                            if (null != timeFld && null != timeFld.getDateTime()) {
                                timestamp = timeFld.getDateTime();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warning("Cannot obtain the value for 'membertimestamp' in API response for member: " + memberName);
                            LOGGER.warning("Defaulting 'membertimestamp' to now - " + timestamp);
                        }
                        insert.clearParameters();
                        insert.setShort(1, (short)0);
                        insert.setString(2, memberName);
                        insert.setString(3, wi.getId());
                        insert.setTimestamp(4, new Timestamp(timestamp.getTime()));
                        insert.setClob(5, new StringReader(description));
                        insert.setString(6, (String)pjConfigHash.get(parentProject));
                        insert.setString(7, wi.getField("memberrev").getItem().getId());
                        insert.setString(8, memberName.substring(projectRoot.length()));
                        insert.executeUpdate();
                        continue;
                    }
                    LOGGER.warning("Skipping " + memberName + " it doesn't appear to exist within this project " + projectRoot + "!");
                    continue;
                }
                LOGGER.warning("View project output contains an invalid model type: " + wi.getModelType());
            }
            db.commit();
        }
        finally {
            if (null != insert) {
                insert.close();
            }
            if (null != db) {
                db.close();
            }
        }
        LOGGER.fine("Parsing project " + siProject.getConfigurationPath() + " complete!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void primeAuthorInformation(String projectCacheTable, APISession api) throws SQLException, IOException {
        Connection db = null;
        Statement authSelect = null;
        ResultSet rs = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            authSelect = db.createStatement(1004, 1008);
            rs = authSelect.executeQuery(AUTHOR_SELECT.replaceFirst("CM_PROJECT", projectCacheTable));
            while (rs.next()) {
                Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(rs);
                rs.updateString(CM_PROJECT.AUTHOR.toString(), IntegrityCMMember.getAuthor(api, rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString(), rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString(), rowHash.get((Object)CM_PROJECT.REVISION).toString()));
                rs.updateRow();
            }
            db.commit();
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != authSelect) {
                authSelect.close();
            }
            if (null != db) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updateChecksum(String projectCacheTable, ConcurrentHashMap<String, String> checksumHash) throws SQLException, IOException {
        Connection db = null;
        Statement checksumSelect = null;
        ResultSet rs = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            checksumSelect = db.createStatement(1004, 1008);
            rs = checksumSelect.executeQuery(CHECKSUM_UPDATE.replaceFirst("CM_PROJECT", projectCacheTable));
            while (rs.next()) {
                Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(rs);
                String newChecksum = checksumHash.get(rowHash.get((Object)CM_PROJECT.NAME).toString());
                if (null == newChecksum || newChecksum.length() <= 0) continue;
                rs.updateString(CM_PROJECT.CHECKSUM.toString(), newChecksum);
                rs.updateRow();
            }
            db.commit();
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != checksumSelect) {
                checksumSelect.close();
            }
            if (null != db) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Hashtable<CM_PROJECT, Object>> viewProject(String projectCacheTable) throws SQLException, IOException {
        ArrayList<Hashtable<CM_PROJECT, Object>> projectMembersList = new ArrayList<Hashtable<CM_PROJECT, Object>>();
        Connection db = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            stmt = db.createStatement();
            rs = stmt.executeQuery(PROJECT_SELECT.replaceFirst("CM_PROJECT", projectCacheTable));
            while (rs.next()) {
                projectMembersList.add(DerbyUtils.getRowData(rs));
            }
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return projectMembersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Hashtable<CM_PROJECT, Object>> viewSubProjects(String projectCacheTable) throws SQLException, IOException {
        ArrayList<Hashtable<CM_PROJECT, Object>> subprojectsList = new ArrayList<Hashtable<CM_PROJECT, Object>>();
        Connection db = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            stmt = db.createStatement();
            rs = stmt.executeQuery(SUB_PROJECT_SELECT.replaceFirst("CM_PROJECT", projectCacheTable));
            while (rs.next()) {
                subprojectsList.add(DerbyUtils.getRowData(rs));
            }
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return subprojectsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<String> getDirList(String projectCacheTable) throws SQLException, IOException {
        ArrayList<String> dirList = new ArrayList<String>();
        Connection db = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            db = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getDataSource().getPooledConnection().getConnection();
            stmt = db.createStatement();
            rs = stmt.executeQuery(DIR_SELECT.replaceFirst("CM_PROJECT", projectCacheTable));
            while (rs.next()) {
                Hashtable<CM_PROJECT, Object> rowData = DerbyUtils.getRowData(rs);
                dirList.add(rowData.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
            }
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            if (null != db) {
                db.close();
            }
        }
        return dirList;
    }
}

