/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegritySCM;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCMProject
implements Serializable {
    private static final long serialVersionUID = 6452315129657215760L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    public static final String NORMAL_PROJECT = "Normal";
    public static final String VARIANT_PROJECT = "Variant";
    public static final String BUILD_PROJECT = "Build";
    private String projectCacheTable;
    private String projectName;
    private String projectType;
    private String projectRevision;
    private String fullConfigSyntax;
    private Date lastCheckpoint;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private boolean skipAuthorInfo = false;
    private boolean checkpointBeforeBuild;
    private Document xmlDoc;
    private StringBuffer changeLog;

    public IntegrityCMProject(WorkItem wi, String projectCacheTable) {
        this.projectCacheTable = projectCacheTable;
        this.changeLog = new StringBuffer();
        this.initializeProject(wi);
    }

    public void initializeProject(WorkItem wi) {
        try {
            Field pjNameFld = wi.getField("projectName");
            Field pjTypeFld = wi.getField("projectType");
            Field pjCfgPathFld = wi.getField("fullConfigSyntax");
            Field pjChkptFld = wi.getField("lastCheckpoint");
            if (null != pjNameFld && null != pjNameFld.getValueAsString()) {
                this.projectName = pjNameFld.getValueAsString();
            } else {
                LOGGER.warning("Project info did not provide a value for the 'projectName' field!");
                this.projectName = "";
            }
            if (null != pjTypeFld && null != pjTypeFld.getValueAsString()) {
                this.projectType = pjTypeFld.getValueAsString();
                if (this.isBuild()) {
                    Field pjRevFld = wi.getField("revision");
                    if (null != pjRevFld && null != pjRevFld.getItem()) {
                        this.projectRevision = pjRevFld.getItem().getId();
                    } else {
                        this.projectRevision = "";
                        LOGGER.warning("Project info did not provide a vale for the 'revision' field!");
                    }
                }
            } else {
                LOGGER.warning("Project info did not provide a value for the 'projectType' field!");
                this.projectType = "";
            }
            if (null != pjCfgPathFld && null != pjCfgPathFld.getValueAsString()) {
                this.fullConfigSyntax = pjCfgPathFld.getValueAsString();
            } else {
                LOGGER.severe("Project info did not provide a value for the 'fullConfigSyntax' field!");
                this.fullConfigSyntax = "";
            }
            if (null != pjChkptFld && null != pjChkptFld.getDateTime()) {
                this.lastCheckpoint = pjChkptFld.getDateTime();
            } else {
                LOGGER.warning("Project info did not provide a value for the 'lastCheckpoint' field!");
                this.lastCheckpoint = Calendar.getInstance().getTime();
            }
        }
        catch (NoSuchElementException nsee) {
            LOGGER.severe("Project info did not provide a value for field " + nsee.getMessage());
        }
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public boolean getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public void setSkipAuthorInfo(boolean skipAuthorInfo) {
        this.skipAuthorInfo = skipAuthorInfo;
    }

    public boolean getSkipAuthorInfo() {
        return this.skipAuthorInfo;
    }

    public String getChangeLog(String version, List<Hashtable<CM_PROJECT, Object>> projectMembersList) throws DOMException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xmlDoc = docBuilder.newDocument();
            this.changeLog = new StringBuffer();
            Element changeLogElem = this.xmlDoc.createElement("changelog");
            this.xmlDoc.appendChild(changeLogElem);
            Element items = this.xmlDoc.createElement("items");
            items.setAttribute("version", version);
            changeLogElem.appendChild(items);
            for (Hashtable<CM_PROJECT, Object> memberInfo : projectMembersList) {
                short deltaFlag;
                if (null == memberInfo.get((Object)CM_PROJECT.DELTA) || (deltaFlag = Short.valueOf(memberInfo.get((Object)CM_PROJECT.DELTA).toString()).shortValue()) <= 0) continue;
                Element item = this.xmlDoc.createElement("item");
                if (deltaFlag == 1) {
                    item.setAttribute("action", "add");
                } else if (deltaFlag == 2) {
                    item.setAttribute("action", "update");
                } else if (deltaFlag == 3) {
                    item.setAttribute("action", "delete");
                } else {
                    item.setAttribute("action", "undefined");
                }
                items.appendChild(this.writeChangeLog(item, memberInfo));
            }
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            serializer.transform(new DOMSource(this.xmlDoc), new StreamResult(sw));
            this.changeLog.append(sw.toString());
            sw.close();
        }
        catch (ParserConfigurationException pce) {
            LOGGER.warning("Caught Parser Configuration Exception while generating Change Log!");
            LOGGER.warning(pce.getMessage());
        }
        catch (TransformerException tfe) {
            LOGGER.warning("Caught Transformer Exception while generating Change Log!");
            LOGGER.warning(tfe.getMessage());
        }
        catch (IOException ioe) {
            LOGGER.warning("Caught IO Exception while generating Change Log!");
            LOGGER.warning(ioe.getMessage());
        }
        return this.changeLog.toString();
    }

    private Element writeChangeLog(Element item, Hashtable<CM_PROJECT, Object> memberInfo) {
        Object o;
        Element file = this.xmlDoc.createElement("file");
        file.appendChild(this.xmlDoc.createTextNode(memberInfo.get((Object)CM_PROJECT.NAME).toString()));
        item.appendChild(file);
        Element user = this.xmlDoc.createElement("user");
        if (memberInfo != null && (o = memberInfo.get((Object)CM_PROJECT.AUTHOR)) != null) {
            user.appendChild(this.xmlDoc.createTextNode(o.toString()));
            item.appendChild(user);
        }
        Element revision = this.xmlDoc.createElement("rev");
        revision.appendChild(this.xmlDoc.createTextNode(memberInfo.get((Object)CM_PROJECT.REVISION).toString()));
        item.appendChild(revision);
        Element date = this.xmlDoc.createElement("date");
        date.appendChild(this.xmlDoc.createTextNode(IntegritySCM.SDF.format((Timestamp)memberInfo.get((Object)CM_PROJECT.TIMESTAMP))));
        item.appendChild(date);
        try {
            Element annotation = this.xmlDoc.createElement("annotation");
            annotation.appendChild(this.xmlDoc.createCDATASection(IntegrityCMMember.getAnnotatedLink(memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString(), memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString(), memberInfo.get((Object)CM_PROJECT.REVISION).toString())));
            item.appendChild(annotation);
            Element differences = this.xmlDoc.createElement("differences");
            String oldRev = null != memberInfo.get((Object)CM_PROJECT.OLD_REVISION) ? memberInfo.get((Object)CM_PROJECT.OLD_REVISION).toString() : "";
            differences.appendChild(this.xmlDoc.createCDATASection(oldRev.length() > 0 ? IntegrityCMMember.getDifferencesLink(memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString(), memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString(), memberInfo.get((Object)CM_PROJECT.REVISION).toString(), oldRev) : ""));
            item.appendChild(differences);
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warning("Caught Unsupported Encoding Exception while generating Integrity Source links!");
            LOGGER.warning(uee.getMessage());
        }
        Element msg = this.xmlDoc.createElement("msg");
        msg.appendChild(this.xmlDoc.createCDATASection(memberInfo.get((Object)CM_PROJECT.DESCRIPTION).toString()));
        item.appendChild(msg);
        return item;
    }

    public Response checkpoint(APISession api, String chkptLabel) throws APIException {
        Command siCheckpoint = new Command("si", "checkpoint");
        siCheckpoint.addOption(new Option("project", this.fullConfigSyntax));
        if (null != chkptLabel && chkptLabel.length() > 0) {
            siCheckpoint.addOption(new Option("label", chkptLabel));
            siCheckpoint.addOption(new Option("description", chkptLabel));
        }
        return api.runCommand(siCheckpoint);
    }

    public Response addProjectLabel(APISession api, String chkptLabel, String projectName, String projectRevision) throws APIException {
        Command siAddProjectLabel = new Command("si", "addprojectlabel");
        siAddProjectLabel.addOption(new Option("project", projectName));
        siAddProjectLabel.addOption(new Option("projectRevision", projectRevision));
        siAddProjectLabel.addOption(new Option("label", chkptLabel));
        siAddProjectLabel.addOption(new Option("moveLabel"));
        return api.runCommand(siAddProjectLabel);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectRevision() {
        return this.projectRevision;
    }

    public boolean isNormal() {
        return this.projectType.equalsIgnoreCase(NORMAL_PROJECT);
    }

    public boolean isVariant() {
        return this.projectType.equalsIgnoreCase(VARIANT_PROJECT);
    }

    public boolean isBuild() {
        return this.projectType.equalsIgnoreCase(BUILD_PROJECT);
    }

    public String getConfigurationPath() {
        return this.fullConfigSyntax;
    }

    public Date getLastCheckpointDate() {
        return this.lastCheckpoint;
    }

    public void setCheckpointBeforeBuild(boolean checkpointBeforeBuild) {
        this.checkpointBeforeBuild = checkpointBeforeBuild;
    }

    public boolean getCheckpointBeforeBuild() {
        return this.checkpointBeforeBuild;
    }

    public String getProjectCacheTable() {
        return this.projectCacheTable;
    }
}

