/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.scm.IntegrityCheckinTask;
import hudson.scm.IntegrityConfigurable;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckinAction
extends Notifier
implements Serializable {
    private static final long serialVersionUID = 4647604916824363519L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private String ciConfigPath;
    private String ciWorkspaceDir;
    private String includes;
    private String excludes;
    private String serverConfig;
    private String configurationName;
    @Extension
    public static final IntegrityCheckinDescriptorImpl CHECKIN_DESCRIPTOR = new IntegrityCheckinDescriptorImpl();

    @DataBoundConstructor
    public IntegrityCheckinAction(String ciConfigPath, String ciWorkspaceDir, String includes, String excludes, String serverConfig, String configurationName) {
        this.setCiConfigPath(ciConfigPath);
        this.setCiWorkspaceDir(ciWorkspaceDir);
        this.setIncludes(includes);
        this.setExcludes(excludes);
        this.setServerConfig(serverConfig);
        this.setConfigurationName(configurationName);
    }

    public String getCiConfigPath() {
        return this.ciConfigPath;
    }

    public String getCiWorkspaceDir() {
        return this.ciWorkspaceDir;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setCiConfigPath(String ciConfigPath) {
        this.ciConfigPath = ciConfigPath;
    }

    public void setCiWorkspaceDir(String ciWorkspaceDir) {
        this.ciWorkspaceDir = ciWorkspaceDir;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    private IntegrityConfigurable getProjectSettings(AbstractBuild<?, ?> thisBuild) {
        IntegrityConfigurable desSettings = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(this.serverConfig);
        IntegrityConfigurable ciSettings = new IntegrityConfigurable("TEMP_ID", desSettings.getIpHostName(), desSettings.getIpPort(), desSettings.getHostName(), desSettings.getPort(), desSettings.getSecure(), "", "");
        AbstractProject thisProject = thisBuild.getProject();
        if (!(thisProject.getScm() instanceof IntegritySCM)) {
            LOGGER.severe("IntegrityCheckinAction - Failed to initialize project specific connection settings!");
            return desSettings;
        }
        String userName = ((IntegritySCM)thisProject.getScm()).getUserName();
        ciSettings.setUserName(userName);
        LOGGER.fine("IntegrityCheckinAction - Project Userame = " + userName);
        Secret password = ((IntegritySCM)thisProject.getScm()).getSecretPassword();
        ciSettings.setPassword(password.getEncryptedValue());
        LOGGER.fine("IntegrityCheckinAction - Project User password = " + password.getEncryptedValue());
        return ciSettings;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!Result.SUCCESS.equals((Object)build.getResult())) {
            LOGGER.fine("Build failed!  Skipping Integrity Checkin step!");
            listener.getLogger().println("Build failed!  Skipping Integrity Checkin step!");
            return true;
        }
        IntegrityCheckinTask ciTask = new IntegrityCheckinTask(this.ciConfigPath, this.ciWorkspaceDir, this.includes, this.excludes, build, listener, this.getProjectSettings(build));
        return (Boolean)build.getWorkspace().act((FilePath.FileCallable)ciTask);
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return CHECKIN_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegrityCheckinDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public IntegrityCheckinDescriptorImpl() {
            super(IntegrityCheckinAction.class);
            this.load();
            LOGGER.fine("IntegrityCheckinAction.IntegrityCheckinDescriptorImpl() constructed!");
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            IntegrityCheckinAction ciAction = (IntegrityCheckinAction)super.newInstance(req, formData);
            LOGGER.fine("IntegrityCheckinAction.IntegrityCheckinDescriptorImpl.newInstance() executed!");
            return ciAction;
        }

        public String getDisplayName() {
            return "Integrity - CM Checkin";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            LOGGER.fine("IntegrityCheckinAction.IntegrityCheckinDescriptorImpl.configure() executed!");
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            LOGGER.fine("IntegrityCheckinAction.IntegrityCheckinDescriptorImpl.isApplicable executed!");
            return true;
        }

        public ListBoxModel doFillServerConfigItems(@QueryParameter String serverConfig) {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.doFillServerConfigItems(serverConfig);
        }
    }
}

