/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.FileOption;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCheckpointAction;
import hudson.scm.IntegrityConfigurable;
import hudson.scm.IntegritySCM;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckinTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 4165773747683187630L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private final String itemID;
    private final String buildID;
    private final String ciConfigPath;
    private final String ciWorkspaceDir;
    private final String ciIncludes;
    private final String ciExcludes;
    private final BuildListener listener;
    private IntegrityConfigurable integrityConfig;

    public IntegrityCheckinTask(String ciConfigPath, String ciWorkspaceDir, String ciIncludes, String ciExcludes, AbstractBuild<?, ?> build, BuildListener listener, IntegrityConfigurable integrityConfig) throws IOException, InterruptedException {
        this.itemID = null == build.getEnvironment((TaskListener)listener).get((Object)"ItemID") ? "" : ((String)build.getEnvironment((TaskListener)listener).get((Object)"ItemID")).toString();
        this.buildID = build.getFullDisplayName();
        this.ciConfigPath = IntegrityCheckpointAction.evalGroovyExpression((Map<String, String>)build.getEnvironment((TaskListener)listener), ciConfigPath);
        this.ciWorkspaceDir = ciWorkspaceDir;
        this.ciIncludes = ciIncludes;
        this.ciExcludes = ciExcludes;
        this.listener = listener;
        this.integrityConfig = integrityConfig;
        LOGGER.fine("Integrity Checkin Task Created!");
    }

    private String createCP(APISession api) throws APIException {
        String cpid = ":none";
        if (":bypass".equalsIgnoreCase(this.itemID) || "bypass".equalsIgnoreCase(this.itemID)) {
            return ":bypass";
        }
        try {
            int intItemID = Integer.parseInt(this.itemID);
            if (intItemID <= 0) {
                LOGGER.fine("Couldn't determine Integrity Item ID, defaulting cpid to ':none'!");
                return cpid;
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.fine("Couldn't determine Integrity Item ID, defaulting cpid to ':none'!");
            return cpid;
        }
        String desc = "Build updates from " + this.buildID;
        Command cmd = new Command("si", "createcp");
        cmd.addOption(new Option("summary", desc));
        cmd.addOption(new Option("description", desc));
        cmd.addOption(new Option("issueId", this.itemID));
        Response res = api.runCommand(cmd);
        if (null != res) {
            if (res.getExitCode() == 0) {
                cpid = res.getResult().getPrimaryValue().getId();
            } else {
                LOGGER.severe("An error occured creating Change Package to check-in build updates!");
            }
        } else {
            LOGGER.severe("An error occured creating Change Package to check-in build updates!");
        }
        return cpid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean invoke(File workspaceFile, VirtualChannel channel) throws IOException {
        File checkinDir = new File(this.ciWorkspaceDir);
        FilePath workspace = new FilePath(checkinDir.isAbsolute() ? checkinDir : new File(workspaceFile.getAbsolutePath() + IntegritySCM.FS + checkinDir.getPath()));
        this.listener.getLogger().println("Integrity project '" + this.ciConfigPath + "' will be updated from directory " + workspace);
        APISession api = APISession.create(this.integrityConfig);
        if (null != api) {
            try {
                ExceptionHandler eh;
                FilePath[] artifacts = workspace.list(this.ciIncludes, this.ciExcludes);
                if (artifacts.length <= 0) return true;
                String cpid = this.createCP(api);
                for (int i = 0; i < artifacts.length; ++i) {
                    FilePath member = artifacts[i];
                    String relativePath = ("" + member).substring(("" + workspace).length() + 1);
                    if (member.isDirectory()) continue;
                    Command lock = new Command("si", "lock");
                    lock.addOption(new Option("cpid", cpid));
                    lock.addOption(new Option("project", this.ciConfigPath));
                    lock.addSelection(relativePath);
                    try {
                        api.runCommand(lock);
                        LOGGER.fine("Attempting to checkin file: " + member);
                        Command ci = new Command("si", "projectci");
                        ci.addOption(new Option("cpid", cpid));
                        ci.addOption(new Option("project", this.ciConfigPath));
                        ci.addOption((Option)new FileOption("sourceFile", new File("" + member)));
                        ci.addOption(new Option("saveTimestamp"));
                        ci.addOption(new Option("nocloseCP"));
                        ci.addOption(new Option("nodifferentNames"));
                        ci.addOption(new Option("branchVariant"));
                        ci.addOption(new Option("nocheckinUnchanged"));
                        ci.addOption(new Option("description", "Build updates from " + this.buildID));
                        ci.addSelection(relativePath);
                        api.runCommand(ci);
                        continue;
                    }
                    catch (APIException ae) {
                        ExceptionHandler eh2 = new ExceptionHandler(ae);
                        String exceptionString = eh2.getMessage();
                        if (exceptionString.indexOf("is not a current or destined or pending member") <= 0) throw ae;
                        LOGGER.fine("Lock failed: " + exceptionString);
                        LOGGER.fine("Attempting to add file: " + member);
                        Command add = new Command("si", "projectadd");
                        add.addOption(new Option("cpid", cpid));
                        add.addOption(new Option("project", this.ciConfigPath));
                        add.addOption((Option)new FileOption("sourceFile", new File("" + member)));
                        add.addOption(new Option("onExistingArchive", "sharearchive"));
                        add.addOption(new Option("saveTimestamp"));
                        add.addOption(new Option("nocloseCP"));
                        add.addOption(new Option("description", "Build updates from " + this.buildID));
                        add.addSelection(relativePath);
                        api.runCommand(add);
                        continue;
                    }
                }
                if (!cpid.equals(":none") && !cpid.equals(":bypass")) {
                    LOGGER.fine("Submitting Change Package: " + cpid);
                    Command closecp = new Command("si", "closecp");
                    closecp.addOption(new Option("releaseLocks"));
                    closecp.addSelection(cpid);
                    try {
                        api.runCommand(closecp);
                    }
                    catch (APIException ae) {
                        eh = new ExceptionHandler(ae);
                        String exceptionString = eh.getMessage();
                        if (exceptionString.indexOf("has pending entries and can not be closed") <= 0) throw ae;
                        LOGGER.fine("Close cp failed: " + exceptionString);
                        LOGGER.fine("Attempting to submit cp: " + cpid);
                        Command submitcp = new Command("si", "submitcp");
                        submitcp.addOption(new Option("closeCP"));
                        submitcp.addOption(new Option("commit"));
                        submitcp.addSelection(cpid);
                        api.runCommand(submitcp);
                    }
                } else {
                    Command unlock = new Command("si", "unlock");
                    unlock.addOption(new Option("project", this.ciConfigPath));
                    unlock.addOption(new Option("action", "remove"));
                    unlock.addOption(new Option("recurse"));
                    unlock.addOption(new Option("yes"));
                    try {
                        api.runCommand(unlock);
                    }
                    catch (APIException ae) {
                        eh = new ExceptionHandler(ae);
                        LOGGER.severe(eh.getMessage());
                        LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
                    }
                }
                this.listener.getLogger().println("Successfully updated Integrity project '" + this.ciConfigPath + "' with contents of workspace (" + workspace + ")!");
                return true;
            }
            catch (InterruptedException iex) {
                LOGGER.severe("Interrupted Exception caught...");
                this.listener.getLogger().println("An Interrupted Exception was caught!");
                LOGGER.log(Level.SEVERE, "InterruptedException", iex);
                this.listener.getLogger().println(iex.getMessage());
                this.listener.getLogger().println("Failed to update Integrity project '" + this.ciConfigPath + "' with contents of workspace (" + workspace + ")!");
                Boolean cpid = false;
                return cpid;
            }
            catch (APIException aex) {
                LOGGER.severe("API Exception caught...");
                this.listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                LOGGER.severe(eh.getMessage());
                this.listener.getLogger().println(eh.getMessage());
                this.listener.getLogger().println("Failed to update Integrity project '" + this.ciConfigPath + "' with contents of workspace (" + workspace + ")!");
                LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
                LOGGER.log(Level.SEVERE, "APIException", aex);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (null != api) {
                    api.Terminate();
                }
            }
        }
        this.listener.getLogger().println("Couldn't create API Session for check-in task!");
        this.listener.getLogger().println("Failed to update Integrity project '" + this.ciConfigPath + "' with contents of workspace (" + workspace + ")!");
        return false;
    }
}

