/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.Item;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItemIterator;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityConfigurable;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.tasks.test.TestResult;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityItemAction
extends Notifier
implements Serializable {
    private static final long serialVersionUID = 7067049279037277420L;
    private static final Logger LOGGER = Logger.getLogger("IntegritySCM");
    private String serverConfig;
    private String queryDefinition;
    private String stateField;
    private String successValue;
    private String failureValue;
    private String logField;
    private String testSessionField;
    private String testSessionStateField;
    private String testSessionActiveState;
    private String testSessionTestsField;
    private String testCaseTestNameField;
    private String testSuiteContainsField;
    private String testPassedVerdictName;
    private String testFailedVerdictName;
    private String testSkippedVerdictName;
    @Extension
    public static final IntegrityItemDescriptorImpl ITEM_DESCRIPTOR = new IntegrityItemDescriptorImpl();

    public String getServerConfig() {
        return this.serverConfig;
    }

    public String getQueryDefinition() {
        return this.queryDefinition;
    }

    public String getStateField() {
        return this.stateField;
    }

    public String getSuccessValue() {
        return this.successValue;
    }

    public String getFailureValue() {
        return this.failureValue;
    }

    public String getLogField() {
        return this.logField;
    }

    public String getTestSessionField() {
        return this.testSessionField;
    }

    public String getTestSessionStateField() {
        return this.testSessionStateField;
    }

    public String getTestSessionActiveState() {
        return this.testSessionActiveState;
    }

    public String getTestSessionTestsField() {
        return this.testSessionTestsField;
    }

    public String getTestCaseTestNameField() {
        return this.testCaseTestNameField;
    }

    public String getTestSuiteContainsField() {
        return this.testSuiteContainsField;
    }

    public String getTestPassedVerdictName() {
        return this.testPassedVerdictName;
    }

    public String getTestFailedVerdictName() {
        return this.testFailedVerdictName;
    }

    public String getTestSkippedVerdictName() {
        return this.testSkippedVerdictName;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setQueryDefinition(String queryDefinition) {
        this.queryDefinition = queryDefinition;
    }

    public void setStateField(String stateField) {
        this.stateField = stateField;
    }

    public void setSuccessValue(String successValue) {
        this.successValue = successValue;
    }

    public void setFailureValue(String failureValue) {
        this.failureValue = failureValue;
    }

    public void setLogField(String logField) {
        this.logField = logField;
    }

    public void setTestSessionField(String testSessionField) {
        this.testSessionField = testSessionField;
    }

    public void setTestSessionStateField(String testSessionStateField) {
        this.testSessionStateField = testSessionStateField;
    }

    public void setTestSessionActiveState(String testSessionActiveState) {
        this.testSessionActiveState = testSessionActiveState;
    }

    public void setTestSessionTestsField(String testSessionTestsField) {
        this.testSessionTestsField = testSessionTestsField;
    }

    public void setTestCaseTestNameField(String testCaseTestNameField) {
        this.testCaseTestNameField = testCaseTestNameField;
    }

    public void setTestSuiteContainsField(String testSuiteContainsField) {
        this.testSuiteContainsField = testSuiteContainsField;
    }

    public void setTestPassedVerdictName(String testPassedVerdictName) {
        this.testPassedVerdictName = testPassedVerdictName;
    }

    public void setTestFailedVerdictName(String testFailedVerdictName) {
        this.testFailedVerdictName = testFailedVerdictName;
    }

    public void setTestSkippedVerdictName(String testSkippedVerdictName) {
        this.testSkippedVerdictName = testSkippedVerdictName;
    }

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    private boolean editBuildItem(AbstractBuild<?, ?> build, BuildListener listener, APISession api, String buildItemID) throws IOException, APIException {
        Command editIssue = new Command("im", "editissue");
        if (null != this.logField && this.logField.length() > 0) {
            StringWriter writer = new StringWriter();
            build.getLogText().writeHtmlTo(0L, (Writer)writer);
            writer.flush();
            writer.close();
            String log = writer.getBuffer().toString().replace('\u0000', ' ');
            log = log.replaceAll(IntegritySCM.NL, "<br>");
            MultiValue mvLog = new MultiValue("=");
            mvLog.add(this.logField);
            mvLog.add(log);
            editIssue.addOption(new Option("richContentField", mvLog));
        }
        MultiValue mvState = new MultiValue("=");
        mvState.add(this.stateField);
        if (Result.SUCCESS.equals((Object)build.getResult())) {
            listener.getLogger().println("Preparing to update item '" + buildItemID + "' with value " + this.stateField + " = " + this.successValue);
            mvState.add(this.successValue);
        } else {
            listener.getLogger().println("Preparing to update item '" + buildItemID + "' with values " + this.stateField + " = " + this.failureValue);
            mvState.add(this.failureValue);
        }
        editIssue.addOption(new Option("field", mvState));
        editIssue.addSelection(buildItemID);
        Response editIssueResponse = api.runCommand(editIssue);
        int returnCode = editIssueResponse.getExitCode();
        LOGGER.fine(editIssueResponse.getCommandString() + " returned " + returnCode);
        listener.getLogger().println("Updated build item '" + buildItemID + "' with build status!");
        return returnCode == 0;
    }

    private void editTestResult(APISession api, String annotation, String verdict, String testSessionID, String testCaseID) throws APIException {
        Command editresult = new Command("tm", "editresult");
        editresult.addOption(new Option("annotation", annotation));
        editresult.addOption(new Option("verdict", verdict));
        editresult.addOption(new Option("forceCreate"));
        editresult.addOption(new Option("sessionID", testSessionID));
        editresult.addSelection(testCaseID);
        try {
            LOGGER.fine("Attempting to update test result for Integrity Test - " + testCaseID);
            api.runCommand(editresult);
        }
        catch (APIException aex) {
            LOGGER.fine("Caught API Exception...");
            LOGGER.log(Level.SEVERE, "APIException", aex);
            ExceptionHandler eh = new ExceptionHandler(aex);
            LOGGER.fine(eh.getMessage());
            String message = eh.getMessage();
            if (message.indexOf("MKS124746") > 0 || message.indexOf("result for test case") > 0 && message.indexOf("does not exist") > 0) {
                LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
                LOGGER.fine(eh.getMessage());
                LOGGER.warning("An attempt was made to update a Test Result for non-meaningful content.  Perhaps you've incorrectly configured your Tests?");
            }
            throw aex;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception", e);
        }
    }

    private String getJUnitID(String testCaseID) {
        if (testCaseID.indexOf("/") > 0) {
            return testCaseID;
        }
        StringBuilder junitTestCaseID = new StringBuilder("junit/");
        String[] tokens = testCaseID.split("\\.");
        if (tokens.length == 2 && testCaseID.indexOf(46) == testCaseID.lastIndexOf(46)) {
            junitTestCaseID.append("(root)/" + testCaseID.replace('.', '/'));
            return junitTestCaseID.toString();
        }
        if (tokens.length > 2) {
            for (int i = 0; i < tokens.length; ++i) {
                junitTestCaseID.append(tokens[i]);
                if (i >= tokens.length - 1) continue;
                junitTestCaseID.append(i >= tokens.length - 3 ? "/" : ".");
            }
            return junitTestCaseID.toString();
        }
        LOGGER.warning("Invalid format for Test Case ID - should be in the format <packagename>.<classname>.<testname>!");
        junitTestCaseID.append("(root)/" + testCaseID);
        return junitTestCaseID.toString();
    }

    private void updateTestResult(TestResult testResult, BuildListener listener, APISession api, String testSessionID, Response walkResponse, List<Item> testCaseList) throws APIException {
        for (Item test : testCaseList) {
            Field testCaseIDFld = null;
            Field containsFld = null;
            try {
                testCaseIDFld = test.getField(this.testCaseTestNameField);
                containsFld = test.getField(this.testSuiteContainsField);
            }
            catch (NoSuchElementException nsee) {
                testCaseIDFld = walkResponse.getWorkItem(test.getId()).getField(this.testCaseTestNameField);
                containsFld = walkResponse.getWorkItem(test.getId()).getField(this.testSuiteContainsField);
            }
            if (null != testCaseIDFld && null != testCaseIDFld.getValueAsString()) {
                String testCaseID = testCaseIDFld.getValueAsString();
                String junitTestName = this.getJUnitID(testCaseID);
                LOGGER.fine("Looking for external test " + testCaseID + " internal JUnit ID " + junitTestName);
                TestResult caseResult = testResult.findCorrespondingResult(junitTestName);
                if (null != caseResult) {
                    LOGGER.fine("Located internal JUnit Test - " + junitTestName);
                    this.editTestResult(api, caseResult.isPassed() ? "Test " + caseResult.getId() + " has passed" : caseResult.getErrorDetails(), caseResult.isPassed() ? this.testPassedVerdictName : this.testFailedVerdictName, testSessionID, test.getId());
                } else {
                    LOGGER.warning("Could not locate internal JUnit Test - " + junitTestName);
                    this.editTestResult(api, "Test " + this.getJUnitID(testCaseID) + " was not run!", this.testSkippedVerdictName, testSessionID, test.getId());
                }
            }
            if (null == containsFld || null == containsFld.getList()) continue;
            this.updateTestResult(testResult, listener, api, testSessionID, walkResponse, containsFld.getList());
        }
    }

    private TestResult getTestResult(AggregatedTestResultAction testResultAction) {
        List cList = testResultAction.getChildReports();
        for (AggregatedTestResultAction.ChildReport childReport : cList) {
            if (!(childReport.result instanceof TestResult)) continue;
            TestResult testResult = (TestResult)childReport.result;
            LOGGER.fine("Total tests run: " + testResult.getTotalCount());
            LOGGER.fine("Total passed count: " + testResult.getPassCount());
            LOGGER.fine("Total failed count: " + testResult.getFailCount());
            LOGGER.fine("Total skipped count: " + testResult.getSkipCount());
            LOGGER.fine("Failed Test Details:");
            for (TestResult caseResult : testResult.getFailedTests()) {
                LOGGER.fine("ID: " + caseResult.getId() + " " + caseResult.getErrorDetails());
            }
            return testResult;
        }
        return null;
    }

    private boolean collectTestResults(AggregatedTestResultAction testResultAction, BuildListener listener, APISession api, String testSessionID) throws APIException {
        Field testSessionFld;
        Command walk = new Command("im", "relationships");
        walk.addOption(new Option("fields", this.testCaseTestNameField));
        MultiValue traverseFields = new MultiValue(",");
        traverseFields.add(this.testSessionTestsField);
        traverseFields.add(this.testSuiteContainsField);
        walk.addOption(new Option("traverseFields", traverseFields));
        walk.addSelection(testSessionID);
        Response walkResponse = api.runCommand(walk);
        if (null != walkResponse && null != (testSessionFld = walkResponse.getWorkItem(testSessionID).getField(this.testSessionTestsField)) && null != testSessionFld.getList()) {
            this.updateTestResult(this.getTestResult(testResultAction), listener, api, testSessionID, walkResponse, testSessionFld.getList());
        }
        return true;
    }

    private IntegrityConfigurable getProjectSettings(AbstractBuild<?, ?> thisBuild) {
        IntegrityConfigurable desSettings = IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.getConfiguration(this.serverConfig);
        IntegrityConfigurable ciSettings = new IntegrityConfigurable("TEMP_ID", desSettings.getIpHostName(), desSettings.getIpPort(), desSettings.getHostName(), desSettings.getPort(), desSettings.getSecure(), "", "");
        AbstractProject thisProject = thisBuild.getProject();
        if (!(thisProject.getScm() instanceof IntegritySCM)) {
            LOGGER.severe("IntegrityItemAction - Failed to initialize project specific connection settings!");
            return desSettings;
        }
        String userName = ((IntegritySCM)thisProject.getScm()).getUserName();
        ciSettings.setUserName(userName);
        LOGGER.fine("IntegrityItemAction - Project Userame = " + userName);
        Secret password = ((IntegritySCM)thisProject.getScm()).getSecretPassword();
        ciSettings.setPassword(password.getEncryptedValue());
        LOGGER.fine("IntegrityItemAction - Project User password = " + password.getEncryptedValue());
        return ciSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean success = true;
        AbstractProject<?, ?> rootProject = this.getRootProject(build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            listener.getLogger().println("Integrity Item update is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        APISession api = APISession.create(this.getProjectSettings(build));
        if (null == api) {
            LOGGER.severe("An API Session could not be established!  Cannot update Integrity Build Item!");
            listener.getLogger().println("An API Session could not be established!  Cannot update Integrity Build Item!");
            return false;
        }
        try {
            AbstractTestResultAction testResult;
            int intBuildItemID = 0;
            int intTestSessionID = 0;
            Object itemIDObj = build.getEnvironment((TaskListener)listener).get((Object)"ItemID");
            String buildItemID = null == itemIDObj ? "" : itemIDObj.toString();
            try {
                intBuildItemID = Integer.parseInt(buildItemID);
            }
            catch (NumberFormatException nfe) {
                intBuildItemID = 0;
            }
            Object sessionIDObj = build.getEnvironment((TaskListener)listener).get((Object)"SessionID");
            String testSessionID = null == sessionIDObj ? "" : sessionIDObj.toString();
            try {
                intTestSessionID = Integer.parseInt(testSessionID);
            }
            catch (NumberFormatException nfe) {
                intTestSessionID = 0;
            }
            if (intBuildItemID <= 0) {
                if (this.queryDefinition.length() > 0) {
                    Command issues = new Command("im", "issues");
                    issues.addOption(new Option("fields", "ID"));
                    issues.addOption(new Option("queryDefinition", this.queryDefinition));
                    Response issuesResponse = api.runCommand(issues);
                    if (null == issuesResponse) {
                        listener.getLogger().println("Cannot find an Integrity Build Item!  Response from executing custom query is null!");
                        boolean wit = false;
                        return wit;
                    }
                    WorkItemIterator wit = issuesResponse.getWorkItems();
                    if (!wit.hasNext()) {
                        listener.getLogger().println("Cannot find an Integrity Build Item!  Response from executing custom query is null!");
                        boolean nfe = false;
                        return nfe;
                    }
                    buildItemID = wit.next().getField("ID").getValueAsString();
                    try {
                        intBuildItemID = Integer.parseInt(buildItemID);
                    }
                    catch (NumberFormatException nfe) {
                        intBuildItemID = 0;
                    }
                } else {
                    listener.getLogger().println("WARNING: No configuration information provided to locate an Integrity Build Item!");
                }
            }
            if (null != (testResult = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class)) && testResult.getTotalCount() > 0) {
                if (intTestSessionID <= 0 && this.testSessionField.length() > 0 && intBuildItemID > 0) {
                    Field testSessionFld;
                    Command walk = new Command("im", "relationships");
                    walk.addOption(new Option("fields", this.testSessionStateField));
                    walk.addOption(new Option("traverseFields", this.testSessionField));
                    walk.addSelection(buildItemID);
                    Response walkResponse = api.runCommand(walk);
                    if (null != walkResponse && null != (testSessionFld = walkResponse.getWorkItem(buildItemID).getField(this.testSessionField)) && null != testSessionFld.getList()) {
                        List sessionList = testSessionFld.getList();
                        for (Item session : sessionList) {
                            Field stateField = null;
                            try {
                                stateField = session.getField(this.testSessionStateField);
                            }
                            catch (NoSuchElementException nsee) {
                                stateField = walkResponse.getWorkItem(session.getId()).getField(this.testSessionStateField);
                            }
                            if (null == stateField || !this.testSessionActiveState.equals(stateField.getValueAsString())) continue;
                            testSessionID = session.getId();
                            try {
                                intTestSessionID = Integer.parseInt(testSessionID);
                            }
                            catch (NumberFormatException nfe) {
                                intTestSessionID = 0;
                                break;
                            }
                        }
                    }
                }
                if (intTestSessionID > 0) {
                    listener.getLogger().println("Obtained Integrity Test Session Item '" + testSessionID + "' from build environment!");
                    success = this.collectTestResults((AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class), listener, api, testSessionID);
                    listener.getLogger().println("Updated Integrity Test Session Item '" + testSessionID + "' with results from automated test execution!");
                }
            }
            if (intBuildItemID <= 0) return success;
            listener.getLogger().println("Obtained Integrity Build Item '" + buildItemID + "' from build environment!");
            success = this.editBuildItem(build, listener, api, buildItemID);
            return success;
        }
        catch (APIException aex) {
            LOGGER.severe("API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            aex.printStackTrace(listener.fatalError(aex.getMessage()));
            LOGGER.severe(eh.getMessage());
            LOGGER.fine(eh.getCommand() + " returned exit code " + eh.getExitCode());
            boolean bl = false;
            return bl;
        }
        finally {
            api.Terminate();
        }
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return ITEM_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegrityItemDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String defaultQueryDefinition = "((field[Type] = \"Build Request\") and (field[State] = \"Approved\"))";
        public static final String defaultTestSuiteContainsField = "Contains";
        public static final String defaultTestPassedVerdictName = "Passed";
        public static final String defaultTestFailedVerdictName = "Failed";
        public static final String defaultTestSkippedVerdictName = "Skipped";

        public IntegrityItemDescriptorImpl() {
            super(IntegrityItemAction.class);
            this.load();
            LOGGER.fine("IntegrityItemAction.IntegrityItemDescriptorImpl() constructed!");
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            IntegrityItemAction itemAction = new IntegrityItemAction();
            itemAction.setServerConfig(formData.getString("serverConfig"));
            itemAction.setQueryDefinition(formData.getString("queryDefinition"));
            itemAction.setStateField(formData.getString("stateField"));
            itemAction.setSuccessValue(formData.getString("successValue"));
            itemAction.setFailureValue(formData.getString("failureValue"));
            itemAction.setLogField(formData.getString("logField"));
            itemAction.setTestSessionField(formData.getString("testSessionField"));
            itemAction.setTestSessionStateField(formData.getString("testSessionStateField"));
            itemAction.setTestSessionActiveState(formData.getString("testSessionActiveState"));
            itemAction.setTestSessionTestsField(formData.getString("testSessionTestsField"));
            itemAction.setTestCaseTestNameField(formData.getString("testCaseTestNameField"));
            itemAction.setTestSuiteContainsField(formData.getString("testSuiteContainsField"));
            itemAction.setTestPassedVerdictName(formData.getString("testPassedVerdictName"));
            itemAction.setTestFailedVerdictName(formData.getString("testFailedVerdictName"));
            itemAction.setTestSkippedVerdictName(formData.getString("testSkippedVerdictName"));
            LOGGER.fine("IntegrityItemAction.IntegrityItemDescriptorImpl.newInstance() executed!");
            return itemAction;
        }

        public String getDisplayName() {
            return "Integrity - Workflow Item";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            LOGGER.fine("IntegrityItemAction.IntegrityItemDescriptorImpl.configure() executed!");
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            LOGGER.fine("IntegrityItemAction.IntegrityItemDescriptorImpl.isApplicable executed!");
            return true;
        }

        public ListBoxModel doFillServerConfigItems(@QueryParameter String serverConfig) {
            return IntegritySCM.DescriptorImpl.INTEGRITY_DESCRIPTOR.doFillServerConfigItems(serverConfig);
        }

        public String getQueryDefinition() {
            return defaultQueryDefinition;
        }

        public String getTestSuiteContainsField() {
            return defaultTestSuiteContainsField;
        }

        public String getTestPassedVerdictName() {
            return defaultTestPassedVerdictName;
        }

        public String getTestFailedVerdictName() {
            return defaultTestFailedVerdictName;
        }

        public String getTestSkippedVerdictName() {
            return defaultTestSkippedVerdictName;
        }
    }
}

