// CHECKSTYLE:OFF

package hudson.ivy;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Monitor Ivy Process
     * 
     */
    public static String IvyProbeAction_DisplayName() {
        return holder.format("IvyProbeAction.DisplayName");
    }

    /**
     * Monitor Ivy Process
     * 
     */
    public static Localizable _IvyProbeAction_DisplayName() {
        return new Localizable(holder, "IvyProbeAction.DisplayName");
    }

    /**
     * No such file {0}
     * Perhaps you need to specify the correct ivy.xml file path in the project configuration?
     * 
     */
    public static String IvyModuleSetBuild_NoSuchIvyXmlFile(Object arg1) {
        return holder.format("IvyModuleSetBuild.NoSuchIvyXmlFile", arg1);
    }

    /**
     * No such file {0}
     * Perhaps you need to specify the correct ivy.xml file path in the project configuration?
     * 
     */
    public static Localizable _IvyModuleSetBuild_NoSuchIvyXmlFile(Object arg1) {
        return new Localizable(holder, "IvyModuleSetBuild.NoSuchIvyXmlFile", arg1);
    }

    /**
     * Module
     * 
     */
    public static String IvyModule_Pronoun() {
        return holder.format("IvyModule.Pronoun");
    }

    /**
     * Module
     * 
     */
    public static Localizable _IvyModule_Pronoun() {
        return new Localizable(holder, "IvyModule.Pronoun");
    }

    /**
     * Discovered a new module {0} {1}
     * 
     */
    public static String IvyModuleSetBuild_DiscoveredModule(Object arg1, Object arg2) {
        return holder.format("IvyModuleSetBuild.DiscoveredModule", arg1, arg2);
    }

    /**
     * Discovered a new module {0} {1}
     * 
     */
    public static Localizable _IvyModuleSetBuild_DiscoveredModule(Object arg1, Object arg2) {
        return new Localizable(holder, "IvyModuleSetBuild.DiscoveredModule", arg1, arg2);
    }

    /**
     * IvyBuildTrigger external event ({0}): Started by user {1}
     * 
     */
    public static String IvyBuildTrigger_UserCause_ShortDescription(Object arg1, Object arg2) {
        return holder.format("IvyBuildTrigger.UserCause.ShortDescription", arg1, arg2);
    }

    /**
     * IvyBuildTrigger external event ({0}): Started by user {1}
     * 
     */
    public static Localizable _IvyBuildTrigger_UserCause_ShortDescription(Object arg1, Object arg2) {
        return new Localizable(holder, "IvyBuildTrigger.UserCause.ShortDescription", arg1, arg2);
    }

    /**
     * No such settings file {0} exists
     * Please verify that your Ivy settings file is specified properly and exists in the workspace.
     * 
     */
    public static String IvyModuleSetBuild_NoSuchIvySettingsFile(Object arg1) {
        return holder.format("IvyModuleSetBuild.NoSuchIvySettingsFile", arg1);
    }

    /**
     * No such settings file {0} exists
     * Please verify that your Ivy settings file is specified properly and exists in the workspace.
     * 
     */
    public static Localizable _IvyModuleSetBuild_NoSuchIvySettingsFile(Object arg1) {
        return new Localizable(holder, "IvyModuleSetBuild.NoSuchIvySettingsFile", arg1);
    }

    /**
     * The path to the ivy.xml file is required
     * 
     */
    public static String IvyBuildTrigger_CheckIvyFile_PathRequiredError() {
        return holder.format("IvyBuildTrigger.CheckIvyFile.PathRequiredError");
    }

    /**
     * The path to the ivy.xml file is required
     * 
     */
    public static Localizable _IvyBuildTrigger_CheckIvyFile_PathRequiredError() {
        return new Localizable(holder, "IvyBuildTrigger.CheckIvyFile.PathRequiredError");
    }

    /**
     * The path to the ivy.xml file must be relative to the root of the project workspace
     * 
     */
    public static String IvyBuildTrigger_CheckIvyFile_PathAbsoluteError() {
        return holder.format("IvyBuildTrigger.CheckIvyFile.PathAbsoluteError");
    }

    /**
     * The path to the ivy.xml file must be relative to the root of the project workspace
     * 
     */
    public static Localizable _IvyBuildTrigger_CheckIvyFile_PathAbsoluteError() {
        return new Localizable(holder, "IvyBuildTrigger.CheckIvyFile.PathAbsoluteError");
    }

    /**
     * Build an Ivy project
     * 
     */
    public static String IvyModuleSet_DiplayName() {
        return holder.format("IvyModuleSet.DiplayName");
    }

    /**
     * Build an Ivy project
     * 
     */
    public static Localizable _IvyModuleSet_DiplayName() {
        return new Localizable(holder, "IvyModuleSet.DiplayName");
    }

    /**
     * Triggering a new build of {0}
     * 
     */
    public static String IvyBuild_Triggering(Object arg1) {
        return holder.format("IvyBuild.Triggering", arg1);
    }

    /**
     * Triggering a new build of {0}
     * 
     */
    public static Localizable _IvyBuild_Triggering(Object arg1) {
        return new Localizable(holder, "IvyBuild.Triggering", arg1);
    }

    /**
     * The Ivy settings path is required
     * 
     */
    public static String IvyBuildTrigger_CheckIvyConf_PathRequiredError() {
        return holder.format("IvyBuildTrigger.CheckIvyConf.PathRequiredError");
    }

    /**
     * The Ivy settings path is required
     * 
     */
    public static Localizable _IvyBuildTrigger_CheckIvyConf_PathRequiredError() {
        return new Localizable(holder, "IvyBuildTrigger.CheckIvyConf.PathRequiredError");
    }

    /**
     * Aborted
     * 
     */
    public static String IvyBuilder_Aborted() {
        return holder.format("IvyBuilder.Aborted");
    }

    /**
     * Aborted
     * 
     */
    public static Localizable _IvyBuilder_Aborted() {
        return new Localizable(holder, "IvyBuilder.Aborted");
    }

    /**
     * Path {0} is not a file
     * 
     */
    public static String IvyBuildTrigger_CheckIvyConf_PathNotFileError(Object arg1) {
        return holder.format("IvyBuildTrigger.CheckIvyConf.PathNotFileError", arg1);
    }

    /**
     * Path {0} is not a file
     * 
     */
    public static Localizable _IvyBuildTrigger_CheckIvyConf_PathNotFileError(Object arg1) {
        return new Localizable(holder, "IvyBuildTrigger.CheckIvyConf.PathNotFileError", arg1);
    }

    /**
     * An Ivy installation needs to be available for this project to be built.
     * Either your server has no Ivy installations defined, or the requested Ivy version does not exist.
     * 
     */
    public static String IvyModuleSetBuild_NoIvyInstall() {
        return holder.format("IvyModuleSetBuild.NoIvyInstall");
    }

    /**
     * An Ivy installation needs to be available for this project to be built.
     * Either your server has no Ivy installations defined, or the requested Ivy version does not exist.
     * 
     */
    public static Localizable _IvyModuleSetBuild_NoIvyInstall() {
        return new Localizable(holder, "IvyModuleSetBuild.NoIvyInstall");
    }

    /**
     * Build failed before it gets to this module
     * 
     */
    public static String IvyBuild_FailedEarlier() {
        return holder.format("IvyBuild.FailedEarlier");
    }

    /**
     * Build failed before it gets to this module
     * 
     */
    public static Localizable _IvyBuild_FailedEarlier() {
        return new Localizable(holder, "IvyBuild.FailedEarlier");
    }

    /**
     * Upstream module {0} is already building.
     * 
     */
    public static String IvyModule_UpstreamModuleBuildInProgress(Object arg1) {
        return holder.format("IvyModule.UpstreamModuleBuildInProgress", arg1);
    }

    /**
     * Upstream module {0} is already building.
     * 
     */
    public static Localizable _IvyModule_UpstreamModuleBuildInProgress(Object arg1) {
        return new Localizable(holder, "IvyModule.UpstreamModuleBuildInProgress", arg1);
    }

    /**
     * Failed to parse ivy.xml files
     * 
     */
    public static String IvyModuleSetBuild_FailedToParseIvyXml() {
        return holder.format("IvyModuleSetBuild.FailedToParseIvyXml");
    }

    /**
     * Failed to parse ivy.xml files
     * 
     */
    public static Localizable _IvyModuleSetBuild_FailedToParseIvyXml() {
        return new Localizable(holder, "IvyModuleSetBuild.FailedToParseIvyXml");
    }

    /**
     * No such property file {0} exists
     * Please verify that your Ivy settings property files are specified properly and exist in the workspace.
     * 
     */
    public static String IvyModuleSetBuild_NoSuchPropertyFile(Object arg1) {
        return holder.format("IvyModuleSetBuild.NoSuchPropertyFile", arg1);
    }

    /**
     * No such property file {0} exists
     * Please verify that your Ivy settings property files are specified properly and exist in the workspace.
     * 
     */
    public static Localizable _IvyModuleSetBuild_NoSuchPropertyFile(Object arg1) {
        return new Localizable(holder, "IvyModuleSetBuild.NoSuchPropertyFile", arg1);
    }

    /**
     * Trigger the build of other projects based on the Ivy dependency management system
     * 
     */
    public static String IvyBuildTrigger_DisplayName() {
        return holder.format("IvyBuildTrigger.DisplayName");
    }

    /**
     * Trigger the build of other projects based on the Ivy dependency management system
     * 
     */
    public static Localizable _IvyBuildTrigger_DisplayName() {
        return new Localizable(holder, "IvyBuildTrigger.DisplayName");
    }

    /**
     * Ivy failed with error.
     * 
     */
    public static String IvyBuilder_Failed() {
        return holder.format("IvyBuilder.Failed");
    }

    /**
     * Ivy failed with error.
     * 
     */
    public static Localizable _IvyBuilder_Failed() {
        return new Localizable(holder, "IvyBuilder.Failed");
    }

    /**
     * Waiting for Hudson to finish collecting data
     * 
     */
    public static String IvyBuilder_Waiting() {
        return holder.format("IvyBuilder.Waiting");
    }

    /**
     * Waiting for Hudson to finish collecting data
     * 
     */
    public static Localizable _IvyBuilder_Waiting() {
        return new Localizable(holder, "IvyBuilder.Waiting");
    }

    /**
     * Module {0} is still building.
     * 
     */
    public static String IvyModuleSet_ModuleBuildInProgress(Object arg1) {
        return holder.format("IvyModuleSet.ModuleBuildInProgress", arg1);
    }

    /**
     * Module {0} is still building.
     * 
     */
    public static Localizable _IvyModuleSet_ModuleBuildInProgress(Object arg1) {
        return new Localizable(holder, "IvyModuleSet.ModuleBuildInProgress", arg1);
    }

}
