/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ivy.IvyBuildTrigger;
import hudson.ivy.IvyMessageImpl;
import hudson.ivy.IvyThresholdDependency;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IvyBuildTrigger
extends Notifier
implements DependecyDeclarer {
    private static final String BACKUP_IVY_FILE_NAME = "ivy.xml";
    private static final String BACKUP_IVY_PROPERTIES_NAME = "ivy.properties";
    private static final Logger LOGGER = Logger.getLogger(IvyBuildTrigger.class.getName());
    private String ivyFile = "ivy.xml";
    private final String ivyProperties;
    private final String ivyConfName;
    private final boolean triggerWhenUnstable;
    private final boolean useUpstreamParameters;
    private transient long lastmodified = 0L;
    private transient ModuleDescriptor moduleDescriptor;
    private transient VersionMatcher versionMatcher;
    @Extension
    public static final DescriptorImpl DESCRIPTOR;

    @DataBoundConstructor
    public IvyBuildTrigger(String ivyFile, String ivyConfName, String ivyPropertiesFile, boolean triggerWhenUnstable, boolean useUpstreamParameters) {
        this.ivyFile = ivyFile;
        this.ivyConfName = ivyConfName;
        this.ivyProperties = ivyPropertiesFile;
        this.triggerWhenUnstable = triggerWhenUnstable;
        this.useUpstreamParameters = useUpstreamParameters;
    }

    @Deprecated
    public IvyBuildTrigger(String ivyFile, String ivyConfName) {
        this(ivyFile, ivyConfName, null, false, false);
    }

    public String getIvyPropertiesFile() {
        return this.ivyProperties;
    }

    public String getIvyFile() {
        return this.ivyFile;
    }

    public String getIvyConfName() {
        return this.ivyConfName;
    }

    private IvyConfiguration getIvyConfiguration() {
        IvyConfiguration conf = null;
        if (this.ivyConfName != null) {
            for (IvyConfiguration i : DESCRIPTOR.getConfigurations()) {
                if (!i.getName().equals(this.ivyConfName)) continue;
                conf = i;
                break;
            }
        }
        return conf;
    }

    public boolean isTriggerWhenUnstable() {
        return this.triggerWhenUnstable;
    }

    public boolean isUseUpstreamParameters() {
        return this.useUpstreamParameters;
    }

    public Ivy getIvy(File localFilePath, String propertyFile) {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        IvyConfiguration ivyConf = this.getIvyConfiguration();
        try {
            IvySettings ivySettings = new IvySettings();
            if (propertyFile != null) {
                File f = new File(localFilePath, propertyFile);
                ivySettings.loadProperties(f);
                LOGGER.log(Level.INFO, "Configured Ivy using custom properties " + f);
            }
            if (ivyConf != null) {
                ivySettings.load(new File(ivyConf.getIvyConfPath()));
                LOGGER.log(Level.INFO, "Configured Ivy using custom settings " + ivyConf.getIvyConfPath());
            } else {
                ivySettings.loadDefault();
                LOGGER.log(Level.INFO, "Configured Ivy using default 2.1 settings");
            }
            return Ivy.newInstance((IvySettings)ivySettings);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while reading the default Ivy 2.1 settings: " + e.getMessage(), e);
            return null;
        }
    }

    private ModuleDescriptor getModuleDescriptor(AbstractProject p) {
        if (this.moduleDescriptor == null) {
            this.recomputeModuleDescriptor(p.getSomeBuildWithWorkspace());
        }
        return this.moduleDescriptor;
    }

    private boolean copyFileFromWorkspaceIfNecessary(FilePath workspace, String fileToCopy, File localFile, String localDestFile) throws IOException, InterruptedException {
        boolean copied = false;
        if (workspace != null) {
            FilePath f = workspace.child(fileToCopy);
            FilePath backupCopy = new FilePath(localFile).child(localDestFile);
            long flastModified = f.lastModified();
            if (flastModified == 0L) {
                throw new FileNotFoundException("Can't stat file " + f);
            }
            if (flastModified > this.lastmodified) {
                f.copyTo(backupCopy);
                localFile.setLastModified(flastModified);
                copied = true;
                LOGGER.info("Copied the workspace file " + fileToCopy + " to backup " + localFile.getCanonicalFile().toString() + "/" + localDestFile);
            }
        }
        return copied;
    }

    private void recomputeModuleDescriptor(AbstractBuild<?, ?> b) {
        File fivyF;
        File ivyF;
        Ivy ivy;
        block13: {
            String propertyFileToLoadIntoIvy;
            File destDir;
            block12: {
                if (b == null) {
                    return;
                }
                LOGGER.fine("Recomputing Moduledescriptor for Project " + b.getProject().getFullDisplayName());
                destDir = b.getProject().getRootDir();
                propertyFileToLoadIntoIvy = null;
                String propertyFile = this.getIvyPropertiesFile();
                if (propertyFile != null && !propertyFile.trim().isEmpty()) {
                    try {
                        this.copyFileFromWorkspaceIfNecessary(b.getWorkspace(), propertyFile, destDir, "ivy.properties");
                        propertyFileToLoadIntoIvy = "ivy.properties";
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to access the workspace ivy properties file '" + propertyFile + "'", e);
                        LOGGER.log(Level.WARNING, "Removing ModuleDescriptor");
                        this.setModuleDescriptor(null);
                        return;
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Interupted while accessing the workspace ivy properties file '" + propertyFile + "'", e);
                        File ivyP = new File(destDir, "ivy.properties");
                        if (!ivyP.canRead()) break block12;
                        LOGGER.log(Level.WARNING, "Will try to use use existing ivy properties backup");
                        propertyFileToLoadIntoIvy = "ivy.properties";
                    }
                }
            }
            if ((ivy = this.getIvy(destDir, propertyFileToLoadIntoIvy)) == null) {
                this.setModuleDescriptor(null);
                return;
            }
            this.versionMatcher = ivy.getSettings().getVersionMatcher();
            String ivyDesc = this.getIvyFile();
            ivyF = null;
            if (ivyDesc != null && !ivyDesc.trim().isEmpty()) {
                ivyF = new File(destDir, "ivy.xml");
                try {
                    this.copyFileFromWorkspaceIfNecessary(b.getWorkspace(), ivyDesc, destDir, "ivy.xml");
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to access the workspace ivy file '" + ivyDesc + "'", e);
                    LOGGER.log(Level.WARNING, "Removing ModuleDescriptor");
                    this.setModuleDescriptor(null);
                    return;
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Interupted while accessing the workspace ivy file '" + ivyDesc + "'", e);
                    if (!ivyF.canRead()) break block13;
                    LOGGER.log(Level.WARNING, "Will try to use use existing ivy file backup");
                }
            }
        }
        if ((fivyF = ivyF) == null || !fivyF.canRead()) {
            LOGGER.log(Level.WARNING, "Cannot read ivy file backup...removing ModuleDescriptor");
            this.setModuleDescriptor(null);
            return;
        }
        if (this.moduleDescriptor == null || fivyF.lastModified() > this.lastmodified) {
            this.lastmodified = fivyF.lastModified();
            this.setModuleDescriptor((ModuleDescriptor)ivy.execute((Ivy.IvyCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private void setModuleDescriptor(ModuleDescriptor d) {
        ModuleDescriptor old = this.moduleDescriptor;
        this.moduleDescriptor = d;
        if (old == this.moduleDescriptor) {
            return;
        }
        if (old == null || !old.equals(this.moduleDescriptor)) {
            DescriptorImpl.access$100((DescriptorImpl)DESCRIPTOR);
            Hudson.getInstance().rebuildDependencyGraph();
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.recomputeModuleDescriptor(build);
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        DependencyDescriptor[] deps;
        ModuleDescriptor md = this.getModuleDescriptor(owner);
        if (md == null) {
            return;
        }
        for (DependencyDescriptor depDesc : deps = md.getDependencies()) {
            ModuleId id = depDesc.getDependencyId();
            ModuleRevisionId rid = depDesc.getDependencyRevisionId();
            List possibleDeps = DescriptorImpl.access$200((DescriptorImpl)DESCRIPTOR, (ModuleId)id);
            for (AbstractProject p : possibleDeps) {
                if (p.isDisabled()) {
                    p = null;
                }
                if (p == null || !(p instanceof Project) || !this.captures(rid, (Project)p)) continue;
                graph.addDependency((DependencyGraph.Dependency)new IvyThresholdDependency(p, owner, this.triggerWhenUnstable ? Result.UNSTABLE : Result.SUCCESS, this.useUpstreamParameters));
            }
        }
    }

    private boolean captures(ModuleRevisionId depRevId, Project candidate) {
        boolean captures;
        IvyBuildTrigger t = (IvyBuildTrigger)candidate.getPublisher((Descriptor)DESCRIPTOR);
        boolean bl = captures = t != null;
        if (captures && DESCRIPTOR.isExtendedVersionMatching()) {
            ModuleDescriptor cmd = t.getModuleDescriptor((AbstractProject)candidate);
            ModuleRevisionId cmrid = cmd.getModuleRevisionId();
            VersionMatcher matcher = this.versionMatcher;
            boolean bl2 = captures = matcher != null && matcher.isDynamic(depRevId);
            if (captures) {
                String dbranch = depRevId.getBranch();
                String cbranch = cmrid.getBranch();
                if (dbranch != null) {
                    captures = dbranch.equals(cbranch);
                } else {
                    boolean bl3 = captures = cbranch == null;
                }
                if (captures && (captures = matcher.accept(depRevId, cmrid)) && matcher.needModuleDescriptor(depRevId, cmrid)) {
                    captures = matcher.accept(depRevId, cmd);
                }
            }
        }
        return captures;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ ModuleDescriptor access$300(IvyBuildTrigger x0, AbstractProject x1) {
        return x0.getModuleDescriptor(x1);
    }

    static {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        DESCRIPTOR = new DescriptorImpl();
    }
}

