/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.Functions;
import hudson.Util;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.IvyBuild;
import hudson.ivy.IvyClonerWrapper;
import hudson.ivy.IvyDependency;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleInfo;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.IvyReporter;
import hudson.ivy.IvyThresholdDependency;
import hudson.ivy.IvyVirtualDependency;
import hudson.ivy.Messages;
import hudson.ivy.ModuleDependency;
import hudson.ivy.ModuleName;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Resource;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.queue.CauseOfBlockage;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.LogRotator;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IvyModule
extends AbstractIvyProject<IvyModule, IvyBuild>
implements Saveable {
    private static final String IVY_XML_PATH = "ivy.xml";
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private String displayName;
    private String revision;
    private String ivyBranch;
    private transient ModuleName moduleName;
    private String relativePathToDescriptorFromWorkspace;
    private String targets;
    private String relativePathToDescriptorFromModuleRoot;
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    private volatile Set<ModuleDependency> dependencies;
    private static final Logger LOGGER = Logger.getLogger(IvyModule.class.getName());

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        if (this.buildWrappers == null) {
            this.buildWrappers = new DescribableList((Saveable)this);
        }
        return this.buildWrappers;
    }

    IvyModule(IvyModuleSet parent, IvyModuleInfo moduleInfo, int firstBuildNumber) throws IOException {
        super((ItemGroup)parent, moduleInfo.name.toFileSystemName());
        this.reconfigure(moduleInfo);
        this.updateNextBuildNumber(firstBuildNumber);
        this.copyParentBuildWrappers(parent);
    }

    private void copyParentBuildWrappers(IvyModuleSet parent) {
        if (!parent.isAggregatorStyleBuild()) {
            List parentWrappers = parent.getBuildWrappersList().getAll(BuildWrapper.class);
            for (BuildWrapper buildWrapper : parentWrappers) {
                try {
                    IvyClonerWrapper cloner = new IvyClonerWrapper();
                    cloner.dontClone(new Class[]{Descriptor.class});
                    this.getBuildWrappersList().add(cloner.deepClone((Object)buildWrapper));
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not copy build wrappers", e);
                }
            }
        }
    }

    public LogRotator getLogRotator() {
        return this.getParent().getLogRotator();
    }

    @Deprecated
    public void setLogRotator(LogRotator logRotator) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsLogRotator() {
        return false;
    }

    public boolean isBuildable() {
        return super.isBuildable() && this.getParent().isBuildable();
    }

    final void reconfigure(IvyModuleInfo moduleInfo) {
        this.displayName = moduleInfo.displayName;
        this.revision = moduleInfo.revision;
        this.ivyBranch = moduleInfo.branch;
        this.relativePathToDescriptorFromWorkspace = moduleInfo.relativePathToDescriptor;
        this.dependencies = moduleInfo.dependencies;
        this.disabled = false;
    }

    protected void doSetName(String name) {
        this.moduleName = ModuleName.fromFileSystemName((String)name);
        super.doSetName(this.moduleName.toString());
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (this.publishers == null) {
            this.publishers = new DescribableList((Saveable)this);
        }
        this.publishers.setOwner((Saveable)this);
        if (this.dependencies == null) {
            this.dependencies = Collections.emptySet();
        }
    }

    public String getRelativePath() {
        return this.relativePathToDescriptorFromWorkspace;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getIvyBranch() {
        return this.ivyBranch;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getRelativePathToDescriptorFromModuleRoot() {
        if (this.relativePathToDescriptorFromModuleRoot != null) {
            return this.relativePathToDescriptorFromModuleRoot;
        }
        return this.getParent().getRelativePathToDescriptorFromModuleRoot();
    }

    public String getUserConfiguredRelativePathToDescriptorFromModuleRoot() {
        return this.relativePathToDescriptorFromModuleRoot;
    }

    public String getRelativePathToModuleRoot() {
        return StringUtils.removeEnd((String)this.relativePathToDescriptorFromWorkspace, (String)StringUtils.defaultString((String)this.getRelativePathToDescriptorFromModuleRoot(), (String)IVY_XML_PATH));
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        if (this.getParent().isAggregatorStyleBuild()) {
            return this.publishers;
        }
        DescribableList publishersList = new DescribableList(Saveable.NOOP);
        try {
            publishersList.addAll((Collection)this.createModulePublishers());
        }
        catch (IOException e) {
            LOGGER.warning("Failed to load module publisher list");
        }
        return publishersList;
    }

    public JDK getJDK() {
        return this.getParent().getJDK();
    }

    protected Class<IvyBuild> getBuildClass() {
        return IvyBuild.class;
    }

    protected IvyBuild newBuild() throws IOException {
        return (IvyBuild)super.newBuild();
    }

    public ModuleName getModuleName() {
        return this.moduleName;
    }

    public ModuleDependency asDependency() {
        return new ModuleDependency(this.moduleName, (String)Functions.defaulted((Object)this.revision, (Object)"*"), (String)Functions.defaulted((Object)this.ivyBranch, (Object)"*"));
    }

    public String getShortUrl() {
        return this.moduleName.toFileSystemName() + '/';
    }

    @Exported(visibility=2)
    public String getDisplayName() {
        return this.displayName;
    }

    public String getPronoun() {
        return Messages.IvyModule_Pronoun();
    }

    public boolean isNameEditable() {
        return false;
    }

    public IvyModuleSet getParent() {
        return (IvyModuleSet)super.getParent();
    }

    public Label getAssignedLabel() {
        Node n = this.getParent().getLastBuiltOn();
        if (n == null) {
            return null;
        }
        return n.getSelfLabel();
    }

    @Deprecated
    public Resource getWorkspaceResource() {
        return new Resource(this.getParent().getWorkspaceResource(), this.getDisplayName() + " workspace");
    }

    public boolean isFingerprintConfigured() {
        return true;
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        ModuleDependency moduleDependency;
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        if (!this.isBuildable() || this.getParent().ignoreUpstreamChanges() && this.getParent().isAggregatorStyleBuild()) {
            return;
        }
        IvyDependencyComputationData data = null;
        if (!this.getParent().ignoreUpstreamChanges() && data == null) {
            HashMap<ModuleDependency, IvyModule> modules = new HashMap<ModuleDependency, IvyModule>();
            for (IvyModule m : this.getAllIvyModules()) {
                if (!m.isBuildable() || !m.getParent().isAllowedToTriggerDownstream()) continue;
                moduleDependency = m.asDependency();
                modules.put(moduleDependency, m);
                modules.put(moduleDependency.withUnknownRevision(), m);
            }
            data = new IvyDependencyComputationData(modules);
        }
        HashMap<ModuleDependency, IvyModule> myParentsModules = new HashMap<ModuleDependency, IvyModule>();
        for (IvyModule m : this.getParent().getModules()) {
            if (m.isDisabled()) continue;
            moduleDependency = m.asDependency();
            myParentsModules.put(moduleDependency, m);
            myParentsModules.put(moduleDependency.withUnknownRevision(), m);
        }
        IvyModule downstream = this.getParent().isAggregatorStyleBuild() ? this.getParent() : this;
        for (ModuleDependency d : this.dependencies) {
            IvyModuleSet upstream;
            IvyModule src = (IvyModule)myParentsModules.get(d);
            if (src == null) {
                src = (IvyModule)myParentsModules.get(d.withUnknownRevision());
            }
            if (src == null && !this.getParent().ignoreUpstreamChanges() && (src = (IvyModule)data.allModules.get(d)) == null) {
                src = (IvyModule)data.allModules.get(d.withUnknownRevision());
            }
            if (src == null) continue;
            if (src.getParent().isAggregatorStyleBuild()) {
                upstream = src.getParent();
            } else {
                if (!this.getParent().equals(src.getParent()) && !this.hasDependency(graph, (AbstractProject)src.getParent(), (AbstractProject)downstream)) {
                    graph.addDependency((DependencyGraph.Dependency)new IvyVirtualDependency((AbstractProject)src.getParent(), (AbstractProject)downstream));
                }
                upstream = src;
            }
            if (upstream == downstream || this.hasDependency(graph, (AbstractProject)upstream, (AbstractProject)downstream)) continue;
            graph.addDependency((DependencyGraph.Dependency)new IvyThresholdDependency((AbstractProject)upstream, (AbstractProject)downstream, Result.SUCCESS, this.isUseUpstreamParameters()));
        }
    }

    protected Collection<IvyModule> getAllIvyModules() {
        return Hudson.getInstance().getAllItems(IvyModule.class);
    }

    private boolean hasDependency(DependencyGraph graph, AbstractProject upstream, AbstractProject downstream) {
        for (DependencyGraph.Dependency dep : graph.getDownstreamDependencies(upstream)) {
            if (!(dep instanceof IvyDependency) || !dep.getDownstreamProject().equals(downstream)) continue;
            return true;
        }
        return false;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        CauseOfBlockage cob = super.getCauseOfBlockage();
        if (cob != null) {
            return cob;
        }
        if (!this.getParent().isAggregatorStyleBuild()) {
            DependencyGraph graph = Hudson.getInstance().getDependencyGraph();
            for (AbstractProject tup : graph.getTransitiveUpstream((AbstractProject)this)) {
                if (this.getParent() != tup.getParent() || !tup.isBuilding() && !tup.isInQueue()) continue;
                return new BecauseOfUpstreamModuleBuildInProgress(tup);
            }
        }
        return null;
    }

    protected void addTransientActionsFromBuild(IvyBuild build, List<Action> collection, Set<Class> added) {
        if (build == null) {
            return;
        }
        List list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (IvyReporter step : list) {
            if (!added.add(step.getClass())) continue;
            try {
                collection.addAll(step.getProjectActions(this));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to getProjectAction from " + step + ". Report issue to plugin developers.", e);
            }
        }
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishers() {
        return this.publishers;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        this.targets = Util.fixEmptyAndTrim((String)req.getParameter("targets"));
        this.relativePathToDescriptorFromModuleRoot = Util.fixEmptyAndTrim((String)req.getParameter("relativePathToDescriptorFromModuleRoot"));
        this.publishers.rebuild(req, req.getSubmittedForm(), BuildStepDescriptor.filter((List)Publisher.all(), this.getClass()));
        Hudson.getInstance().rebuildDependencyGraph();
    }

    protected void performDelete() throws IOException, InterruptedException {
        super.performDelete();
        this.getParent().onModuleDeleted(this);
    }

    protected final List<Publisher> createModulePublishers() {
        ArrayList<Publisher> modulePublisherList = new ArrayList<Publisher>();
        this.getPublishers().addAllTo(modulePublisherList);
        if (!this.getParent().isAggregatorStyleBuild()) {
            this.getParent().getPublishers().addAllTo(modulePublisherList);
        }
        return modulePublisherList;
    }

    public boolean isUseUpstreamParameters() {
        return this.getParent().isUseUpstreamParameters();
    }
}

