/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.ivy.IvyDependency;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyThresholdDependency
extends IvyDependency {
    private Result threshold;
    private boolean useUpstreamParameters;

    public IvyThresholdDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, Result threshold, boolean useUpstreamParameters) {
        super(upstream, downstream);
        this.threshold = threshold;
        this.useUpstreamParameters = useUpstreamParameters;
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        if (build.getResult().isBetterOrEqualTo(this.threshold)) {
            if (this.useUpstreamParameters) {
                List paramActions = build.getActions(ParametersAction.class);
                for (ParametersAction parametersAction : paramActions) {
                    actions.add((Action)parametersAction);
                }
            }
            return true;
        }
        return false;
    }
}

