/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.LoggingFilterReader;
import hudson.plugins.jabber.im.LoggingFilterWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.util.StringUtils;

public class JabberConnectionDebugger
implements SmackDebugger {
    private static final Logger LOGGER = Logger.getLogger(JabberConnectionDebugger.class.getName());
    private static final Level MIN_LOG_LEVEL = Level.FINE;
    private final Connection connection;
    private Writer writer;
    private Reader reader;
    private PacketListener listener;
    private ConnectionListener connListener;

    public JabberConnectionDebugger(Connection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.writer = writer;
        this.reader = reader;
        this.init();
    }

    private void init() {
        LoggingFilterReader debugReader = new LoggingFilterReader(this.reader, LOGGER, MIN_LOG_LEVEL);
        this.reader = debugReader;
        LoggingFilterWriter debugWriter = new LoggingFilterWriter(this.writer, LOGGER, MIN_LOG_LEVEL);
        this.writer = debugWriter;
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.connListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public Reader getReader() {
        return this.reader;
    }

    public PacketListener getReaderListener() {
        return this.listener;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public PacketListener getWriterListener() {
        return null;
    }

    public Reader newConnectionReader(Reader newReader) {
        LoggingFilterReader debugReader = new LoggingFilterReader(newReader, LOGGER, MIN_LOG_LEVEL);
        this.reader = debugReader;
        return this.reader;
    }

    public Writer newConnectionWriter(Writer newWriter) {
        LoggingFilterWriter debugWriter = new LoggingFilterWriter(newWriter, LOGGER, MIN_LOG_LEVEL);
        this.writer = debugWriter;
        return this.writer;
    }

    public void userHasLogged(String user) {
        if (LOGGER.isLoggable(MIN_LOG_LEVEL)) {
            boolean isAnonymous = "".equals(StringUtils.parseName((String)user));
            String title = "User logged in (" + this.connection.hashCode() + "): " + (isAnonymous ? "" : StringUtils.parseBareAddress((String)user)) + "@" + this.connection.getServiceName() + ":" + this.connection.getPort();
            title = title + "/" + StringUtils.parseResource((String)user);
            LOGGER.fine(title);
        }
        this.connection.addConnectionListener(this.connListener);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Level access$100() {
        return MIN_LOG_LEVEL;
    }
}

