/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;
import org.jivesoftware.smack.util.StringUtils;

public class JabberUtil {
    private JabberUtil() {
    }

    public static String getUserPart(String jabberId) {
        int idx = jabberId.indexOf(64);
        if (idx == -1) {
            return jabberId;
        }
        String userPart = jabberId.substring(0, idx);
        if (Util.fixEmptyAndTrim((String)userPart) == null) {
            throw new IllegalArgumentException("Missing user part in " + jabberId);
        }
        return userPart;
    }

    public static String getDomainPart(String jabberId) {
        int atIdx = jabberId.indexOf(64);
        if (atIdx == -1) {
            return null;
        }
        int slashIdx = jabberId.indexOf(47, atIdx);
        if (slashIdx == -1) {
            if (atIdx + 1 < jabberId.length()) {
                return jabberId.substring(atIdx + 1);
            }
            return null;
        }
        return jabberId.substring(atIdx + 1, slashIdx);
    }

    public static String getResourcePart(String jabberId) {
        String resource = StringUtils.parseResource((String)jabberId);
        return resource.length() > 0 ? resource : null;
    }
}

