/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Extension;
import hudson.Util;
import hudson.model.User;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberIMMessageTargetConverter;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.user.JabberUserProperty;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import java.util.List;

public class JabberPublisher
extends IMPublisher {
    @Extension
    public static final JabberPublisherDescriptor DESCRIPTOR = new JabberPublisherDescriptor();
    static final IMMessageTargetConverter CONVERTER = new JabberIMMessageTargetConverter();

    public JabberPublisher(List<IMMessageTarget> targets, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier, MatrixJobMultiplier matrixJobMultiplier) throws IMMessageTargetConversionException {
        super(targets, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, buildToChatNotifier, matrixJobMultiplier);
    }

    public JabberPublisherDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    protected IMConnection getIMConnection() throws IMException {
        return JabberIMConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "Jabber notifier plugin";
    }

    protected String getConfiguredIMId(User user) {
        String emailAddress;
        Mailer.UserProperty mailProperty;
        JabberUserProperty jabberUserProperty = (JabberUserProperty)((Object)user.getProperties().get((Object)JabberUserProperty.DESCRIPTOR));
        if (jabberUserProperty != null && jabberUserProperty.getJid() != null) {
            return jabberUserProperty.getJid();
        }
        if (this.getDescriptor().isEmailAddressAsJabberId() && (mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) != null && Util.fixEmpty((String)(emailAddress = mailProperty.getAddress())) != null) {
            return emailAddress;
        }
        return null;
    }

    public String getTargets() {
        List notificationTargets = this.getNotificationTargets();
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget target : notificationTargets) {
            if (target instanceof GroupChatIMMessageTarget && !target.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(this.getIMDescriptor().getIMMessageTargetConverter().toString(target));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected Object readResolve() {
        super.readResolve();
        return this;
    }
}

