/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.plugins.jabber.im.transport.JabberUtil;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.util.Assert;

public class JabberPublisherDescriptor
extends BuildStepDescriptor<Publisher>
implements IMPublisherDescriptor {
    private static final Logger LOGGER = Logger.getLogger(JabberPublisherDescriptor.class.getName());
    private static final String PREFIX = "jabberPlugin.";
    private static final int DEFAULT_PROXYPORT = 3128;
    public static final String PARAMETERNAME_ENABLED = "jabberPlugin.enabled";
    public static final String PARAMETERNAME_PORT = "jabberPlugin.port";
    public static final String PARAMETERNAME_HOSTNAME = "jabberPlugin.hostname";
    public static final String PARAMETERNAME_USEPROXY = "jabberPlugin.useProxy";
    public static final String PARAMETERNAME_PROXYTYPE = "jabberPlugin.proxyType";
    public static final String PARAMETERNAME_PROXYHOST = "jabberPlugin.proxyHost";
    public static final String PARAMETERNAME_PROXYPORT = "jabberPlugin.proxyPort";
    public static final String PARAMETERNAME_PROXYUSER = "jabberPlugin.proxyUser";
    public static final String PARAMETERNAME_PROXYPASS = "jabberPlugin.proxyPass";
    public static final String PARAMETERNAME_SSL = "jabberPlugin.ssl";
    public static final String PARAMETERNAME_SASL = "jabberPlugin.enableSASL";
    public static final String PARAMETERNAME_PRESENCE = "jabberPlugin.exposePresence";
    public static final String PARAMETERNAME_PASSWORD = "jabberPlugin.password";
    public static final String PARAMETERNAME_JABBERID = "jabberPlugin.jabberId";
    public static final String PARAMETERNAME_GROUP_NICKNAME = "jabberPlugin.groupNick";
    public static final String PARAMETERNAME_TARGETS = "jabberPlugin.targets";
    public static final String PARAMETERNAME_INITIAL_GROUPCHATS = "jabberPlugin.initialGroupChats";
    public static final String PARAMETERNAME_COMMAND_PREFIX = "jabberPlugin.commandPrefix";
    public static final String PARAMETERNAME_DEFAULT_ID_SUFFIX = "jabberPlugin.defaultIdSuffix";
    public static final String PARAMETERNAME_SUBSCRIPTION_MODE = "jabberPlugin.subscriptionMode";
    public static final String PARAMETERNAME_EMAIL_ADDRESS_AS_JABBERID = "jabberPlugin.emailAsJabberId";
    public static final String[] PARAMETERVALUE_SUBSCRIPTION_MODE;
    public static final String[] PARAMETERVALUE_PROXYTYPES;
    public static final String[] PARAMETERVALUE_STRATEGY_VALUES;
    public static final String PARAMETERVALUE_STRATEGY_DEFAULT;
    public static final String DEFAULT_COMMAND_PREFIX = "!";
    private static final int DEFAULT_PORT = 5222;
    private Boolean enabled;
    private int port = 5222;
    private String hostname;
    @Deprecated
    private transient boolean legacySSL;
    private String hudsonNickname;
    private String hudsonPassword;
    private String groupChatNickname;
    private boolean exposePresence = true;
    private boolean enableSASL = true;
    private boolean scrambledPasswords = false;
    @Deprecated
    private String initialGroupChats;
    private List<IMMessageTarget> defaultTargets;
    private String commandPrefix = "!";
    private String defaultIdSuffix;
    private String hudsonCiLogin;
    private String subscriptionMode = Roster.SubscriptionMode.accept_all.name();
    private boolean emailAddressAsJabberId;
    private ProxyInfo.ProxyType proxyType = ProxyInfo.ProxyType.NONE;
    private int proxyPort = 3128;
    private String proxyHost = null;
    private String proxyUser = null;
    private String proxyPass = null;

    public JabberPublisherDescriptor() {
        super(JabberPublisher.class);
        this.load();
        if (this.isEnabled()) {
            try {
                JabberIMConnectionProvider.setDesc(this);
            }
            catch (Exception e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        } else {
            try {
                JabberIMConnectionProvider.setDesc(null);
            }
            catch (IMException e) {
                LOGGER.info(ExceptionHelper.dump((Throwable)e));
            }
        }
    }

    public void load() {
        super.load();
        if (this.enabled == null) {
            this.enabled = Util.fixEmptyAndTrim((String)this.hudsonNickname) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.subscriptionMode == null) {
            this.subscriptionMode = Roster.SubscriptionMode.accept_all.name();
        }
    }

    private void applyHostname(HttpServletRequest req, boolean check) throws Descriptor.FormException {
        String s = req.getParameter(PARAMETERNAME_HOSTNAME);
        if (check && s != null && s.trim().length() > 0) {
            try {
                InetAddress.getByName(s);
                this.hostname = s;
            }
            catch (UnknownHostException e) {
                throw new Descriptor.FormException("Cannot find Host '" + s + "'.", PARAMETERNAME_HOSTNAME);
            }
        } else {
            this.hostname = null;
        }
    }

    private void applyNickname(HttpServletRequest req, boolean check) throws Descriptor.FormException {
        this.hudsonNickname = req.getParameter(PARAMETERNAME_JABBERID);
        if (check && this.hostname != null && (this.hudsonNickname == null || this.hudsonNickname.trim().length() == 0)) {
            throw new Descriptor.FormException("Account/Nickname cannot be empty.", PARAMETERNAME_JABBERID);
        }
    }

    private void applyPassword(HttpServletRequest req, boolean check) throws Descriptor.FormException {
        this.scrambledPasswords = true;
        String password = req.getParameter(PARAMETERNAME_PASSWORD);
        if (check && this.hostname != null && (password == null || password.trim().length() == 0)) {
            throw new Descriptor.FormException("Password cannot be empty.", PARAMETERNAME_PASSWORD);
        }
        this.hudsonPassword = Scrambler.scramble((String)password);
    }

    private void applyGroupChatNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.groupChatNickname = req.getParameter(PARAMETERNAME_GROUP_NICKNAME);
        if (this.groupChatNickname != null && this.groupChatNickname.trim().length() == 0) {
            this.groupChatNickname = null;
        }
    }

    private void applyPort(HttpServletRequest req, boolean check) throws Descriptor.FormException {
        String p = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_PORT));
        if (p != null) {
            try {
                int i = Integer.parseInt(p);
                if (check && (i < 0 || i > 65535)) {
                    throw new Descriptor.FormException("Port out of range.", PARAMETERNAME_PORT);
                }
                this.port = i;
            }
            catch (NumberFormatException e) {
                throw new Descriptor.FormException("Port cannot be parsed.", PARAMETERNAME_PORT);
            }
        } else {
            this.port = 5222;
        }
    }

    private void applyInitialGroupChats(HttpServletRequest req) {
        String[] chatNames = req.getParameterValues("jabberPlugin.chat.name");
        String[] chatPasswords = req.getParameterValues("jabberPlugin.chat.password");
        String[] notifyOnlys = req.getParameterValues("jabberPlugin.chat.notificationOnly");
        this.defaultTargets = new ArrayList<IMMessageTarget>();
        if (chatNames != null) {
            for (int i = 0; i < chatNames.length; ++i) {
                String chatName = chatNames[i];
                String chatPassword = Util.fixEmptyAndTrim((String)chatPasswords[i]);
                boolean notifyOnly = notifyOnlys != null ? "on".equalsIgnoreCase(notifyOnlys[i]) : false;
                this.defaultTargets.add((IMMessageTarget)new GroupChatIMMessageTarget(chatName, chatPassword, notifyOnly));
            }
        }
    }

    private void applyCommandPrefix(HttpServletRequest req) {
        String prefix = req.getParameter(PARAMETERNAME_COMMAND_PREFIX);
        this.commandPrefix = prefix != null && prefix.trim().length() > 0 ? prefix : DEFAULT_COMMAND_PREFIX;
    }

    private void applyDefaultIdSuffix(HttpServletRequest req) {
        String suffix = req.getParameter(PARAMETERNAME_DEFAULT_ID_SUFFIX);
        this.defaultIdSuffix = suffix != null && suffix.trim().length() > 0 ? suffix.trim() : "";
    }

    private void applyHudsonLoginPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonCiLogin = Util.fixEmptyAndTrim((String)req.getParameter("im.hudsonLogin"));
    }

    private void applyProxy(HttpServletRequest req) throws Descriptor.FormException {
        boolean enabled = "on".equals(req.getParameter(PARAMETERNAME_USEPROXY));
        if (!enabled) {
            this.proxyType = ProxyInfo.ProxyType.NONE;
            return;
        }
        this.proxyType = ProxyInfo.ProxyType.NONE;
        String s = req.getParameter(PARAMETERNAME_PROXYTYPE);
        if (s != null) {
            try {
                this.proxyType = ProxyInfo.ProxyType.valueOf((String)s);
            }
            catch (RuntimeException e) {
                throw new Descriptor.FormException("Proxy type cannot be parsed.", PARAMETERNAME_PROXYTYPE);
            }
        }
        if (ProxyInfo.ProxyType.NONE == this.proxyType) {
            return;
        }
        s = req.getParameter(PARAMETERNAME_PROXYHOST);
        if (s != null && s.trim().length() > 0) {
            try {
                InetAddress.getByName(s);
                this.proxyHost = s;
            }
            catch (UnknownHostException e) {
                this.proxyType = ProxyInfo.ProxyType.NONE;
                throw new Descriptor.FormException("Cannot find Proxy host '" + s + "'.", PARAMETERNAME_PROXYHOST);
            }
        } else {
            this.proxyType = ProxyInfo.ProxyType.NONE;
        }
        if (ProxyInfo.ProxyType.NONE == this.proxyType) {
            return;
        }
        s = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_PROXYPORT));
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                if (i < 0 || i > 65535) {
                    throw new Descriptor.FormException("Proxy port out of range.", PARAMETERNAME_PROXYPORT);
                }
                this.proxyPort = i;
            }
            catch (NumberFormatException e) {
                this.proxyType = ProxyInfo.ProxyType.NONE;
                throw new Descriptor.FormException("Proxy port cannot be parsed.", PARAMETERNAME_PROXYPORT);
            }
        } else {
            this.proxyPort = 3128;
        }
        this.proxyUser = req.getParameter(PARAMETERNAME_PROXYUSER);
        this.proxyPass = req.getParameter(PARAMETERNAME_PROXYPASS);
        if (null != this.proxyUser && this.proxyUser.length() > 0 && null == this.proxyPass) {
            this.proxyPass = "";
        }
    }

    public String getDisplayName() {
        return "Jabber Notification";
    }

    public String getPluginDescription() {
        return "Jabber plugin";
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.enabled);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHost() {
        if (StringUtils.isNotBlank((String)this.hostname)) {
            return this.hostname;
        }
        return this.getServiceName();
    }

    public String getJabberId() {
        return this.hudsonNickname;
    }

    public String getPassword() {
        return Scrambler.descramble((String)this.hudsonPassword);
    }

    public String getGroupChatNickname() {
        return this.groupChatNickname;
    }

    public int getPort() {
        return this.port;
    }

    public String getPortString() {
        if (this.port == 5222) {
            return null;
        }
        return String.valueOf(this.port);
    }

    public boolean isEnableSASL() {
        return this.enableSASL;
    }

    public boolean isExposePresence() {
        return this.exposePresence;
    }

    public String getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public boolean isEmailAddressAsJabberId() {
        return this.emailAddressAsJabberId;
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public ProxyInfo.ProxyType getProxyType() {
        return this.proxyType;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyPortString() {
        return String.valueOf(this.proxyPort);
    }

    public String getProxyTypeString() {
        return this.proxyType.name();
    }

    public JabberPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        Assert.notNull((Object)req, (String)"Parameter 'req' must not be null.");
        String t = req.getParameter(PARAMETERNAME_TARGETS);
        String[] split = t != null ? t.split("\\s") : new String[]{};
        ArrayList<IMMessageTarget> targets = new ArrayList<IMMessageTarget>(split.length);
        try {
            IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
            for (String fragment : split) {
                IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
                if (createIMMessageTarget == null) continue;
                targets.add(createIMMessageTarget);
            }
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException("Invalid Jabber address", (Throwable)e, PARAMETERNAME_TARGETS);
        }
        String n = req.getParameter("im.strategy");
        if (n == null) {
            n = PARAMETERVALUE_STRATEGY_DEFAULT;
        } else {
            boolean foundStrategyValueMatch = false;
            for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                if (!strategyValue.equals(n)) continue;
                foundStrategyValueMatch = true;
                break;
            }
            if (!foundStrategyValueMatch) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            }
        }
        boolean notifyStart = "on".equals(req.getParameter("im.notifyStart"));
        boolean notifySuspects = "on".equals(req.getParameter("im.notifySuspects"));
        boolean notifyCulprits = "on".equals(req.getParameter("im.notifyCulprits"));
        boolean notifyFixers = "on".equals(req.getParameter("im.notifyFixers"));
        boolean notifyUpstream = "on".equals(req.getParameter("im.notifyUpstreamCommitters"));
        MatrixJobMultiplier matrixJobMultiplier = MatrixJobMultiplier.ONLY_CONFIGURATIONS;
        if (formData.has("matrixNotifier")) {
            String o = formData.getString("matrixNotifier");
            matrixJobMultiplier = MatrixJobMultiplier.valueOf((String)o);
        }
        try {
            return new JabberPublisher(targets, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream, (BuildToChatNotifier)req.bindJSON(BuildToChatNotifier.class, formData.getJSONObject("buildToChatNotifier")), matrixJobMultiplier);
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException((Throwable)e, PARAMETERNAME_TARGETS);
        }
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        String en = req.getParameter(PARAMETERNAME_ENABLED);
        this.enabled = en != null;
        this.exposePresence = req.getParameter(PARAMETERNAME_PRESENCE) != null;
        this.enableSASL = req.getParameter(PARAMETERNAME_SASL) != null;
        this.subscriptionMode = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_SUBSCRIPTION_MODE));
        this.emailAddressAsJabberId = req.getParameter(PARAMETERNAME_EMAIL_ADDRESS_AS_JABBERID) != null;
        this.applyHostname((HttpServletRequest)req, this.enabled);
        this.applyPort((HttpServletRequest)req, this.enabled);
        this.applyNickname((HttpServletRequest)req, this.enabled);
        this.applyPassword((HttpServletRequest)req, this.enabled);
        this.applyGroupChatNickname((HttpServletRequest)req);
        this.applyInitialGroupChats((HttpServletRequest)req);
        this.applyCommandPrefix((HttpServletRequest)req);
        this.applyDefaultIdSuffix((HttpServletRequest)req);
        this.applyHudsonLoginPassword((HttpServletRequest)req);
        this.applyProxy((HttpServletRequest)req);
        if (this.isEnabled()) {
            try {
                JabberIMConnectionProvider.setDesc(this);
                JabberIMConnectionProvider.getInstance().currentConnection();
            }
            catch (Exception e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        } else {
            JabberIMConnectionProvider.getInstance().releaseConnection();
            try {
                JabberIMConnectionProvider.setDesc(null);
            }
            catch (IMException e) {
                LOGGER.info(ExceptionHelper.dump((Throwable)e));
            }
            LOGGER.info("No hostname specified.");
        }
        this.save();
        return super.configure(req, json);
    }

    public FormValidation doJabberIdCheck(@QueryParameter String jabberId, @QueryParameter String hostname, @QueryParameter String port, @QueryParameter String proxyType) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        if (jabberId == null || jabberId.trim().length() == 0) {
            return FormValidation.error((String)"Jabber ID must not be empty!");
        }
        if (Util.fixEmptyAndTrim((String)hostname) != null) {
            return FormValidation.ok();
        }
        if (JabberUtil.getDomainPart(jabberId) != null) {
            String pts = Util.fixEmptyAndTrim((String)proxyType);
            String host = JabberUtil.getDomainPart(jabberId);
            ProxyInfo.ProxyType pt = ProxyInfo.ProxyType.NONE;
            try {
                if (pts != null) {
                    pt = ProxyInfo.ProxyType.valueOf((String)pts);
                }
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)("Invalid proxy type " + proxyType));
            }
            try {
                JabberPublisherDescriptor.checkHostAccessibility(host, port, pt);
                return FormValidation.ok();
            }
            catch (UnknownHostException e) {
                return FormValidation.error((String)("Unknown host " + host));
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)("Invalid port " + port));
            }
            catch (IOException e) {
                return FormValidation.error((String)("Unable to connect to " + hostname + ":" + port + " : " + e.getMessage()));
            }
        }
        return FormValidation.error((String)"No hostname specified - neither via 'Jabber ID' nor via 'Server'!");
    }

    public FormValidation doProxyCheck(@QueryParameter String proxyType, @QueryParameter String proxyHost, @QueryParameter String proxyPort) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        String host = Util.fixEmptyAndTrim((String)proxyHost);
        String p = Util.fixEmptyAndTrim((String)proxyPort);
        String pts = Util.fixEmptyAndTrim((String)proxyType);
        if (host == null) {
            return FormValidation.ok();
        }
        ProxyInfo.ProxyType pt = ProxyInfo.ProxyType.NONE;
        try {
            if (pts != null) {
                pt = ProxyInfo.ProxyType.valueOf((String)pts);
            }
        }
        catch (IllegalArgumentException e) {
            return FormValidation.error((String)("Invalid proxy type " + proxyType));
        }
        if (pt != ProxyInfo.ProxyType.NONE) {
            try {
                JabberPublisherDescriptor.checkHostAccessibility(host, p, ProxyInfo.ProxyType.NONE);
            }
            catch (UnknownHostException e) {
                return FormValidation.error((String)("Unknown proxy host " + proxyHost));
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)("Invalid proxy port " + proxyPort));
            }
            catch (IOException e) {
                return FormValidation.error((String)("Unable to connect to " + host + ":" + p + " : " + e.getMessage()));
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doServerCheck(@QueryParameter String hostname, @QueryParameter String port, @QueryParameter String proxyType) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        String host = Util.fixEmptyAndTrim((String)hostname);
        String p = Util.fixEmptyAndTrim((String)port);
        String pts = Util.fixEmptyAndTrim((String)proxyType);
        if (host == null) {
            return FormValidation.ok();
        }
        ProxyInfo.ProxyType pt = ProxyInfo.ProxyType.NONE;
        try {
            if (pts != null) {
                pt = ProxyInfo.ProxyType.valueOf((String)pts);
            }
        }
        catch (IllegalArgumentException e) {
            return FormValidation.error((String)("Invalid proxy type " + proxyType));
        }
        try {
            JabberPublisherDescriptor.checkHostAccessibility(host, port, pt);
            return FormValidation.ok();
        }
        catch (UnknownHostException e) {
            return FormValidation.error((String)("Unknown host " + host));
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)("Invalid port " + port));
        }
        catch (IOException e) {
            return FormValidation.error((String)("Unable to connect to " + hostname + ":" + p + " : " + e.getMessage()));
        }
    }

    private static void checkHostAccessibility(String hostname, String port, ProxyInfo.ProxyType pt) throws UnknownHostException, IOException, NumberFormatException {
        hostname = Util.fixEmptyAndTrim((String)hostname);
        port = Util.fixEmptyAndTrim((String)port);
        int iPort = 5222;
        InetAddress address = InetAddress.getByName(hostname);
        if (port != null) {
            iPort = Integer.parseInt(port);
        }
        if (pt == ProxyInfo.ProxyType.NONE) {
            Socket s = new Socket(address, iPort);
            s.close();
        }
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getUserName() {
        return JabberUtil.getUserPart(this.getJabberId());
    }

    String getServiceName() {
        return JabberUtil.getDomainPart(this.getJabberId());
    }

    public String getHudsonUserName() {
        return this.hudsonCiLogin;
    }

    public IMMessageTargetConverter getIMMessageTargetConverter() {
        return JabberPublisher.CONVERTER;
    }

    public List<IMMessageTarget> getDefaultTargets() {
        return this.defaultTargets;
    }

    private Object readResolve() {
        if (this.defaultTargets == null) {
            this.defaultTargets = new ArrayList<IMMessageTarget>();
        }
        if (this.initialGroupChats != null) {
            String[] split;
            for (String chatName : split = this.initialGroupChats.trim().split("\\s")) {
                this.defaultTargets.add((IMMessageTarget)new GroupChatIMMessageTarget(chatName, null, false));
            }
            this.initialGroupChats = null;
            this.save();
        }
        if (!this.scrambledPasswords) {
            this.hudsonPassword = Scrambler.scramble((String)this.hudsonPassword);
            this.scrambledPasswords = true;
            this.save();
        }
        return this;
    }

    static {
        Roster.SubscriptionMode[] modes = Roster.SubscriptionMode.values();
        PARAMETERVALUE_SUBSCRIPTION_MODE = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            JabberPublisherDescriptor.PARAMETERVALUE_SUBSCRIPTION_MODE[i] = modes[i].name();
        }
        ProxyInfo.ProxyType[] ptypes = ProxyInfo.ProxyType.values();
        PARAMETERVALUE_PROXYTYPES = new String[ptypes.length];
        for (int i = 0; i < ptypes.length; ++i) {
            JabberPublisherDescriptor.PARAMETERVALUE_PROXYTYPES[i] = ptypes[i].name();
        }
        PARAMETERVALUE_STRATEGY_VALUES = NotificationStrategy.getDisplayNames();
        PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
    }
}

