/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import hudson.plugins.im.AbstractIMConnection;
import hudson.plugins.im.AuthenticationHolder;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberConnectionDebugger;
import hudson.plugins.jabber.im.transport.JabberMessage;
import hudson.plugins.jabber.im.transport.JabberMultiUserChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberUtil;
import hudson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.VCard;
import org.springframework.util.Assert;

class JabberIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Map<String, WeakReference<MultiUserChat>> groupChatCache = new HashMap<String, WeakReference<MultiUserChat>>();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap<String, WeakReference<Chat>>();
    private final Set<Bot> bots = new HashSet<Bot>();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    @Nullable
    private final String groupChatNick;
    private final String hostnameOverride;
    private final int port;
    private final List<IMMessageTarget> groupChats;
    private IMPresence impresence;
    private String imStatusMessage;
    private boolean enableSASL;
    private final JabberPublisherDescriptor desc;
    private final AuthenticationHolder authentication;
    private Roster roster;
    private final ProxyInfo.ProxyType proxytype;
    private final String proxyhost;
    private final String proxyuser;
    private final String proxypass;
    private final int proxyport;
    private final Map<IMConnectionListener, ConnectionListener> listeners = new ConcurrentHashMap<IMConnectionListener, ConnectionListener>();

    JabberIMConnection(JabberPublisherDescriptor desc, AuthenticationHolder authentication) throws IMException {
        super((IMPublisherDescriptor)desc);
        Assert.notNull((Object)((Object)desc), (String)"Parameter 'desc' must not be null.");
        this.desc = desc;
        this.authentication = authentication;
        this.hostnameOverride = desc.getHostname();
        this.port = desc.getPort();
        this.nick = JabberUtil.getUserPart(desc.getJabberId());
        this.passwd = desc.getPassword();
        this.enableSASL = desc.isEnableSASL();
        this.proxytype = desc.getProxyType();
        this.proxyhost = desc.getProxyHost();
        this.proxyport = desc.getProxyPort();
        this.proxyuser = desc.getProxyUser();
        this.proxypass = desc.getProxyPass();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getDefaultTargets();
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        this.lock();
        try {
            if (!this.isConnected()) {
                if (this.createConnection()) {
                    LOGGER.info("Connected to XMPP on " + this.connection.getHost() + ":" + this.connection.getPort() + "/" + this.connection.getServiceName() + (this.connection.isUsingTLS() ? " using TLS" : "") + (this.connection.isUsingCompression() ? " using compression" : ""));
                    this.sendPresence();
                    this.groupChatCache.clear();
                    for (IMMessageTarget chat : this.groupChats) {
                        GroupChatIMMessageTarget groupChat = (GroupChatIMMessageTarget)chat;
                        try {
                            this.getOrCreateGroupChat(groupChat);
                            LOGGER.info("Joined groupchat " + groupChat.getName());
                        }
                        catch (IMException e) {
                            LOGGER.warning("Unable to connect to groupchat '" + groupChat.getName() + "'. Did you append @conference or so to the name?\n" + "Exception: " + ExceptionHelper.dump((Throwable)e));
                        }
                    }
                } else {
                    if (this.connection != null) {
                        try {
                            this.connection.disconnect();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    boolean e = false;
                    return e;
                }
            }
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        try {
            try {
                for (WeakReference<MultiUserChat> entry : this.groupChatCache.values()) {
                    MultiUserChat chat = (MultiUserChat)entry.get();
                    if (chat == null || !chat.isJoined()) continue;
                    chat.leave();
                }
                this.groupChatCache.clear();
                this.chatCache.clear();
                if (this.connection.isConnected()) {
                    this.connection.disconnect();
                }
            }
            catch (Exception e) {
                LOGGER.fine(e.toString());
            }
            finally {
                this.connection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean createConnection() throws XMPPException {
        ProxyInfo pi;
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        switch (this.proxytype) {
            case HTTP: {
                pi = ProxyInfo.forHttpProxy((String)this.proxyhost, (int)this.proxyport, (String)this.proxyuser, (String)this.proxypass);
                break;
            }
            case SOCKS4: {
                pi = ProxyInfo.forSocks4Proxy((String)this.proxyhost, (int)this.proxyport, (String)this.proxyuser, (String)this.proxypass);
                break;
            }
            case SOCKS5: {
                pi = ProxyInfo.forSocks5Proxy((String)this.proxyhost, (int)this.proxyport, (String)this.proxyuser, (String)this.proxypass);
                break;
            }
            default: {
                pi = ProxyInfo.forNoProxy();
            }
        }
        String serviceName = this.desc.getServiceName();
        ConnectionConfiguration cfg = serviceName == null ? new ConnectionConfiguration(this.hostnameOverride, this.port, pi) : (this.hostnameOverride == null ? new ConnectionConfiguration(serviceName, pi) : new ConnectionConfiguration(this.hostnameOverride, this.port, serviceName, pi));
        cfg.setReconnectionAllowed(false);
        cfg.setDebuggerEnabled(true);
        SASLAuthentication.unregisterSASLMechanism((String)"DIGEST-MD5");
        cfg.setSASLAuthenticationEnabled(this.enableSASL);
        LOGGER.info("Trying to connect to XMPP on " + cfg.getHost() + ":" + cfg.getPort() + "/" + cfg.getServiceName() + (cfg.isSASLAuthenticationEnabled() ? " with SASL" : "") + (cfg.isCompressionEnabled() ? " using compression" : "") + (pi.getProxyType() != ProxyInfo.ProxyType.NONE ? " via proxy " + pi.getProxyType() + " " + pi.getProxyAddress() + ":" + pi.getProxyPort() : ""));
        boolean retryWithLegacySSL = false;
        XMPPException originalException = null;
        try {
            this.connection = new XMPPConnection(cfg);
            this.connection.connect();
            if (!this.connection.isConnected()) {
                retryWithLegacySSL = true;
            }
        }
        catch (XMPPException e) {
            retryWithLegacySSL = true;
            originalException = e;
        }
        if (retryWithLegacySSL) {
            this.retryConnectionWithLegacySSL(cfg, (Exception)((Object)originalException));
        }
        if (this.connection.isConnected()) {
            this.connection.login(this.desc.getUserName(), this.passwd, "Jenkins");
            this.setupSubscriptionMode();
            this.createVCardIfNeeded();
            this.listenForPrivateChats();
        }
        return this.connection.isAuthenticated();
    }

    private void retryConnectionWithLegacySSL(ConnectionConfiguration cfg, Exception originalException) throws XMPPException {
        try {
            LOGGER.info("Retrying connection with legacy SSL");
            cfg.setSocketFactory(SSLSocketFactory.getDefault());
            this.connection = new XMPPConnection(cfg);
            this.connection.connect();
        }
        catch (XMPPException e) {
            if (originalException != null) {
                LOGGER.warning("Retrying with legacy SSL failed: " + e.getMessage());
                throw new XMPPException("Exception of original (without legacy SSL) connection attempt", (Throwable)originalException);
            }
            throw new XMPPException((Throwable)e);
        }
    }

    private void setupSubscriptionMode() {
        this.roster = this.connection.getRoster();
        Roster.SubscriptionMode mode = Roster.SubscriptionMode.valueOf((String)this.desc.getSubscriptionMode());
        switch (mode) {
            case accept_all: {
                LOGGER.info("Accepting all subscription requests");
                break;
            }
            case reject_all: {
                LOGGER.info("Rejecting all subscription requests");
                break;
            }
            case manual: {
                LOGGER.info("Subscription requests must be handled manually");
            }
        }
        this.roster.setSubscriptionMode(mode);
    }

    private void createVCardIfNeeded() {
        try {
            if (!this.vCardExists()) {
                this.createVCard();
            }
        }
        catch (XMPPException e) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)e));
        }
    }

    private boolean vCardExists() throws XMPPException {
        try {
            VCard vcard = new VCard();
            vcard.load((Connection)this.connection);
            return Util.fixEmpty((String)vcard.getNickName()) != null;
        }
        catch (XMPPException e) {
            if (e.getXMPPError() != null && XMPPError.Condition.item_not_found.toString().equals(e.getXMPPError().getCondition())) {
                return false;
            }
            throw new XMPPException((Throwable)e);
        }
    }

    private void createVCard() throws XMPPException {
        VCard vCard = new VCard();
        vCard.setFirstName("Mr.");
        vCard.setLastName("Jenkins");
        vCard.setNickName(this.nick);
        this.setAvatarImage(vCard);
        vCard.save((Connection)this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAvatarImage(VCard vCard) {
        InputStream input = null;
        ByteArrayOutputStream output = null;
        try {
            input = JabberIMConnection.class.getResourceAsStream("headshot.png");
            output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
            byte[] avatar = output.toByteArray();
            vCard.setAvatar(avatar, "image/png");
        }
        catch (IOException e) {
            try {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    private void listenForPrivateChats() {
        AndFilter filter = new AndFilter(new PacketFilter[]{new MessageTypeFilter(Message.Type.chat), new ToContainsFilter(this.desc.getUserName())});
        PrivateChatListener listener = new PrivateChatListener();
        this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
    }

    private MultiUserChat getOrCreateGroupChat(GroupChatIMMessageTarget chat) throws IMException {
        WeakReference<MultiUserChat> ref = this.groupChatCache.get(chat.getName());
        MultiUserChat groupChat = null;
        if (ref != null) {
            groupChat = (MultiUserChat)ref.get();
        }
        if (groupChat == null) {
            groupChat = new MultiUserChat((Connection)this.connection, chat.getName());
            try {
                groupChat.join(this.groupChatNick, chat.getPassword());
            }
            catch (XMPPException e) {
                LOGGER.warning("Cannot join group chat '" + chat + "'. Exception:\n" + ExceptionHelper.dump((Throwable)e));
                throw new IMException((Exception)((Object)e));
            }
            while (groupChat.pollMessage() != null) {
            }
            this.bots.add(new Bot((IMChat)new JabberMultiUserChat(groupChat, this, !chat.isNotificationOnly()), this.groupChatNick, this.desc.getHost(), this.botCommandPrefix, this.authentication));
            this.groupChatCache.put(chat.getName(), new WeakReference<MultiUserChat>(groupChat));
        }
        return groupChat;
    }

    private Chat getOrCreatePrivateChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference<Chat> wr = this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.getChatManager().createChat(chatPartner, null);
        Bot bot = new Bot((IMChat)new JabberChat(chat, this), this.groupChatNick, this.desc.getHost(), this.botCommandPrefix, this.authentication);
        this.bots.add(bot);
        if (msg != null) {
            bot.onMessage((IMMessage)new JabberMessage(msg, this.isAuthorized(msg.getFrom())));
        }
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.notNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.notNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.getOrCreateGroupChat((GroupChatIMMessageTarget)target).sendMessage(text);
                } else {
                    Chat chat = this.getOrCreatePrivateChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
            catch (XMPPException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.notNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
            this.sendPresence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                Presence presence;
                if (!this.isConnected()) {
                    return;
                }
                switch (this.impresence) {
                    case AVAILABLE: {
                        presence = new Presence(Presence.Type.available, this.imStatusMessage, 1, Presence.Mode.available);
                        break;
                    }
                    case OCCUPIED: {
                        presence = new Presence(Presence.Type.available, this.imStatusMessage, 1, Presence.Mode.away);
                        break;
                    }
                    case DND: {
                        presence = new Presence(Presence.Type.available, this.imStatusMessage, 1, Presence.Mode.dnd);
                        break;
                    }
                    case UNAVAILABLE: {
                        presence = new Presence(Presence.Type.unavailable);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle " + this.impresence);
                    }
                }
                this.connection.sendPacket((Packet)presence);
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this.lock();
        try {
            boolean bl = this.connection != null && this.connection.isAuthenticated();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isAuthorized(String xmppAddress) {
        String bareAddress = StringUtils.parseBareAddress((String)xmppAddress);
        boolean authorized = this.groupChatCache.containsKey(bareAddress);
        if (!authorized) {
            RosterEntry entry = this.roster.getEntry(bareAddress);
            authorized = entry != null && (entry.getType() == RosterPacket.ItemType.both || entry.getType() == RosterPacket.ItemType.from);
        }
        return authorized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = new ConnectionListener(){

                public void connectionClosedOnError(Exception e) {
                    listener.connectionBroken(e);
                }

                public void connectionClosed() {
                }

                public void reconnectingIn(int paramInt) {
                }

                public void reconnectionFailed(Exception paramException) {
                }

                public void reconnectionSuccessful() {
                }
            };
            this.listeners.put(listener, l);
            this.connection.addConnectionListener(l);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(IMConnectionListener listener) {
        this.lock();
        try {
            ConnectionListener l = this.listeners.remove(listener);
            if (l != null) {
                this.connection.removeConnectionListener(l);
            } else {
                LOGGER.warning("Connection listener " + listener + " not found.");
            }
        }
        finally {
            this.unlock();
        }
    }

    static {
        SmackConfiguration.setPacketReplyTimeout((int)20000);
        System.setProperty("smack.debuggerClass", JabberConnectionDebugger.class.getName());
    }

    private final class PrivateChatListener
    implements PacketListener {
        private PrivateChatListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message m = (Message)packet;
                for (PacketExtension ext : m.getExtensions()) {
                    if (!(ext instanceof DelayInformation)) continue;
                    return;
                }
                if (m.getBody() != null) {
                    LOGGER.fine("Message from " + m.getFrom() + " : " + m.getBody());
                    String chatPartner = m.getFrom();
                    JabberIMConnection.this.getOrCreatePrivateChat(chatPartner, m);
                }
            }
        }
    }
}

