/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.packet.DelayInformation;

class JabberMessageListenerAdapter
implements MessageListener {
    private final IMMessageListener listener;
    private final JabberIMConnection connection;

    public JabberMessageListenerAdapter(IMMessageListener listener, JabberIMConnection connection, Chat chat) {
        this.listener = listener;
        this.connection = connection;
    }

    public void processMessage(Chat chat, Message msg) {
        for (PacketExtension pe : msg.getExtensions()) {
            if (!(pe instanceof DelayInformation)) continue;
            return;
        }
        IMMessage imMessage = new IMMessage(msg.getFrom(), msg.getTo(), msg.getBody(), this.connection.isAuthorized(msg.getFrom()));
        this.listener.onMessage(imMessage);
    }
}

