/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jdepend;

import hudson.plugins.jdepend.JDependParser;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.jdepend.objects.CyclePackage;
import org.codehaus.mojo.jdepend.objects.JDPackage;
import org.codehaus.mojo.jdepend.objects.Stats;

public class JDependReportGenerator {
    private JDependParser jdepend;
    private JDPackage jdpackage;
    private Stats stats;
    private List<?> list;
    private CyclePackage cyclepackage;

    public void doGenerateReport(ResourceBundle bundle, Sink sink, JDependParser jdepend) {
        this.jdepend = jdepend;
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.metricresults"));
        sink.sectionTitle1_();
        this.doSectionLinks(bundle, sink);
        sink.lineBreak();
        sink.lineBreak();
        sink.text(bundle.getString("report.intro"));
        sink.lineBreak();
        sink.lineBreak();
        this.doSummarySection(bundle, sink);
        this.doPackagesSection(bundle, sink);
        this.doCycleSection(bundle, sink);
        this.doExplanationSection(bundle, sink);
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    public void doSectionLinks(ResourceBundle bundle, Sink sink) {
        sink.text(bundle.getString("report.square-open"));
        sink.link(bundle.getString("report.summary.anchor"));
        sink.text(bundle.getString("report.summary.text"));
        sink.link_();
        sink.text(bundle.getString("report.square-close"));
        sink.text(bundle.getString("report.square-open"));
        sink.link(bundle.getString("report.packages.anchor"));
        sink.text(bundle.getString("report.packages.text"));
        sink.link_();
        sink.text(bundle.getString("report.square-close"));
        sink.text(bundle.getString("report.square-open"));
        sink.link(bundle.getString("report.cycles.anchor"));
        sink.text(bundle.getString("report.cycles.text"));
        sink.link_();
        sink.text(bundle.getString("report.square-close"));
        sink.text(bundle.getString("report.square-open"));
        sink.link(bundle.getString("report.explanations.anchor"));
        sink.text(bundle.getString("report.explanations.text"));
        sink.link_();
        sink.text(bundle.getString("report.square-close"));
    }

    public void doSummarySection(ResourceBundle bundle, Sink sink) {
        sink.anchor(bundle.getString("report.summary.text"));
        sink.anchor_();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.summary.title"));
        sink.sectionTitle1_();
        this.doSectionLinks(bundle, sink);
        sink.lineBreak();
        sink.lineBreak();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.package.title"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.TC"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.CC"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.AC"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.Ca"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.Ce"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.A"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.I"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.D"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.V"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.list = this.jdepend.getPackages();
        for (int i = 0; i < this.list.size(); ++i) {
            this.jdpackage = (JDPackage)this.list.get(i);
            this.stats = this.jdpackage.getStats();
            sink.tableRow();
            sink.tableCell();
            sink.link(bundle.getString("report.dash") + this.jdpackage.getPackageName());
            sink.text(this.jdpackage.getPackageName());
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.stats.getTotalClasses());
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.stats.getConcreteClasses());
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.stats.getAbstractClasses());
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.stats.getCa());
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.stats.getCe());
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.convertToPercent(this.stats.getA()));
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.convertToPercent(this.stats.getI()));
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.convertToPercent(this.stats.getD()));
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.stats.getV());
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
    }

    public void doPackagesSection(ResourceBundle bundle, Sink sink) {
        sink.anchor(bundle.getString("report.packages.text"));
        sink.anchor_();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.packages.title"));
        sink.sectionTitle1_();
        this.doSectionLinks(bundle, sink);
        sink.lineBreak();
        this.doPackage(bundle, sink);
    }

    public void doPackage(ResourceBundle bundle, Sink sink) {
        this.list = this.jdepend.getPackages();
        if (this.list.size() <= 0) {
            sink.text(bundle.getString("report.nopackages"));
            sink.lineBreak();
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                int j;
                this.jdpackage = (JDPackage)this.list.get(i);
                this.stats = this.jdpackage.getStats();
                sink.anchor(this.jdpackage.getPackageName());
                sink.anchor_();
                sink.sectionTitle2();
                sink.text(this.jdpackage.getPackageName());
                sink.sectionTitle2_();
                sink.table();
                sink.tableRow();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.afferentcouplings.title"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.efferentcouplings.title"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.abstractness.title"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.instability.title"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.distance.title"));
                sink.tableHeaderCell_();
                sink.tableRow_();
                sink.tableRow();
                sink.tableCell();
                sink.text(this.stats.getCa());
                sink.tableCell_();
                sink.tableCell();
                sink.text(this.stats.getCe());
                sink.tableCell_();
                sink.tableCell();
                sink.text(this.convertToPercent(this.stats.getA()));
                sink.tableCell_();
                sink.tableCell();
                sink.text(this.convertToPercent(this.stats.getI()));
                sink.tableCell_();
                sink.tableCell();
                sink.text(this.convertToPercent(this.stats.getD()));
                sink.tableCell_();
                sink.tableRow_();
                sink.table_();
                sink.table();
                sink.tableRow();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.abstractclasses.title"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.concreteclasses.title"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.usedbypackages"));
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text(bundle.getString("report.usespackage"));
                sink.tableHeaderCell_();
                sink.tableRow_();
                sink.tableRow();
                List abstractList = this.jdpackage.getAbstractClasses();
                sink.tableCell();
                if (abstractList.size() <= 0) {
                    sink.italic();
                    sink.text(bundle.getString("report.none"));
                    sink.italic_();
                } else {
                    for (int j2 = 0; j2 < abstractList.size(); ++j2) {
                        sink.text((String)abstractList.get(j2));
                        sink.lineBreak();
                    }
                }
                sink.tableCell_();
                List concreteList = this.jdpackage.getConcreteClasses();
                sink.tableCell();
                if (concreteList.size() <= 0) {
                    sink.italic();
                    sink.text(bundle.getString("report.none"));
                    sink.italic_();
                } else {
                    for (int j3 = 0; j3 < concreteList.size(); ++j3) {
                        sink.text((String)concreteList.get(j3));
                        sink.lineBreak();
                    }
                }
                sink.tableCell_();
                List aList = this.jdpackage.getUsedBy();
                sink.tableCell();
                if (aList.size() <= 0) {
                    sink.italic();
                    sink.text(bundle.getString("report.none"));
                    sink.italic_();
                } else {
                    for (j = 0; j < aList.size(); ++j) {
                        sink.text((String)aList.get(j));
                        sink.lineBreak();
                    }
                }
                sink.tableCell_();
                aList = null;
                aList = this.jdpackage.getDependsUpon();
                sink.tableCell();
                if (aList.size() <= 0) {
                    sink.italic();
                    sink.text(bundle.getString("report.none"));
                    sink.italic_();
                } else {
                    for (j = 0; j < aList.size(); ++j) {
                        sink.text((String)aList.get(j));
                        sink.lineBreak();
                    }
                }
                sink.tableCell_();
                sink.tableRow_();
                sink.table_();
            }
        }
    }

    public void doCycleSection(ResourceBundle bundle, Sink sink) {
        sink.anchor(bundle.getString("report.cycles.text"));
        sink.anchor_();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.cycles.title"));
        sink.sectionTitle1_();
        this.doSectionLinks(bundle, sink);
        sink.lineBreak();
        sink.lineBreak();
        this.doCycles(bundle, sink);
    }

    public void doCycles(ResourceBundle bundle, Sink sink) {
        List<?> cycleList = this.jdepend.getCycles();
        if (cycleList.size() <= 0) {
            sink.text(bundle.getString("report.nocyclicdependencies"));
            sink.lineBreak();
        } else {
            sink.table();
            sink.tableRow();
            sink.tableHeaderCell();
            sink.text(bundle.getString("report.package.title"));
            sink.tableHeaderCell_();
            sink.tableHeaderCell();
            sink.text(bundle.getString("report.packagedependencies"));
            sink.tableHeaderCell_();
            sink.tableRow_();
            for (int i = 0; i < cycleList.size(); ++i) {
                this.cyclepackage = (CyclePackage)cycleList.get(i);
                sink.tableRow();
                sink.tableCell();
                sink.text(this.cyclepackage.getName());
                sink.tableCell_();
                List packageList = this.cyclepackage.getPackageList();
                sink.tableCell();
                if (packageList.size() <= 0) {
                    sink.italic();
                    sink.text(bundle.getString("report.none"));
                    sink.italic_();
                } else {
                    for (int j = 0; j < packageList.size(); ++j) {
                        sink.text((String)packageList.get(j));
                        sink.lineBreak();
                    }
                }
                sink.tableCell_();
                sink.tableRow_();
            }
            sink.table_();
        }
    }

    public void doExplanationSection(ResourceBundle bundle, Sink sink) {
        sink.anchor(bundle.getString("report.explanations"));
        sink.anchor_();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.explanation.title"));
        sink.sectionTitle1_();
        this.doSectionLinks(bundle, sink);
        sink.lineBreak();
        sink.lineBreak();
        sink.text(bundle.getString("report.explanation.description"));
        sink.lineBreak();
        sink.lineBreak();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.term"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.description"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.numberofclasses.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.numberofclasses.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.afferentcouplings.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.afferentcouplings.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.efferentcouplings.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.efferentcouplings.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.abstractness.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.abstractness.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.instability.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.instability.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.distance.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.distance.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text(bundle.getString("report.cycles.title"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(bundle.getString("report.cycles.description"));
        sink.tableCell_();
        sink.tableRow_();
        sink.table_();
    }

    private String convertToPercent(String value) {
        float ival = 0.0f;
        ival = Float.parseFloat(value);
        value = String.valueOf(ival *= 100.0f) + "%";
        return value;
    }
}

