/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.views;

import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import com.tikal.jenkins.plugins.multijob.views.BuildState;
import com.tikal.jenkins.plugins.multijob.views.MultiJobListViewColumn;
import com.tikal.jenkins.plugins.multijob.views.PhaseWrapper;
import com.tikal.jenkins.plugins.multijob.views.ProjectWrapper;
import hudson.Indenter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.ViewGroup;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.views.ListViewColumn;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJobView
extends ListView {
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns = new DescribableList((Saveable)this, (Collection)MultiJobListViewColumn.createDefaultInitialColumnList());

    @DataBoundConstructor
    public MultiJobView(String name) {
        super(name);
    }

    public MultiJobView(String name, ViewGroup owner) {
        super(name, owner);
    }

    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return this.columns;
    }

    public List<TopLevelItem> getItems() {
        List items = Hudson.getInstance().getItems();
        ArrayList<TopLevelItem> out = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : items) {
            MultiJobProject project;
            if (!(item instanceof MultiJobProject) || !(project = (MultiJobProject)item).isTopMost()) continue;
            this.addTopLevelProject(project, out);
        }
        return out;
    }

    public List<TopLevelItem> getRootItem(MultiJobProject multiJobProject) {
        ArrayList<TopLevelItem> out = new ArrayList<TopLevelItem>();
        this.addTopLevelProject(multiJobProject, out);
        return out;
    }

    private void addTopLevelProject(MultiJobProject project, List<TopLevelItem> out) {
        this.addMultiProject(null, project, this.createBuildState(project), 0, null, out);
    }

    private void addMultiProject(MultiJobProject parent, MultiJobProject project, BuildState buildState, int nestLevel, String phaseName, List<TopLevelItem> out) {
        out.add((TopLevelItem)new ProjectWrapper(parent, (AbstractProject)project, buildState, nestLevel));
        List builders = project.getBuilders();
        for (Builder builder : builders) {
            int phaseNestLevel = nestLevel + 1;
            if (!(builder instanceof MultiJobBuilder)) continue;
            MultiJobBuilder reactorBuilder = (MultiJobBuilder)builder;
            List subProjects = reactorBuilder.getPhaseJobs();
            String currentPhaseName = reactorBuilder.getPhaseName();
            PhaseWrapper phaseWrapper = new PhaseWrapper(phaseNestLevel, currentPhaseName);
            out.add((TopLevelItem)phaseWrapper);
            for (PhaseJobsConfig projectConfig : subProjects) {
                BuildState jobBuildState;
                MultiJobProject subProject;
                TopLevelItem tli = Hudson.getInstance().getItem(projectConfig.getJobName());
                if (tli instanceof MultiJobProject) {
                    subProject = (MultiJobProject)tli;
                    jobBuildState = this.createBuildState(buildState, project, (AbstractProject)subProject);
                    phaseWrapper.addChildBuildState(jobBuildState);
                    this.addMultiProject(project, subProject, jobBuildState, phaseNestLevel + 1, currentPhaseName, out);
                    continue;
                }
                subProject = (AbstractProject)tli;
                jobBuildState = this.createBuildState(buildState, project, (AbstractProject)subProject);
                phaseWrapper.addChildBuildState(jobBuildState);
                this.addSimpleProject(project, (AbstractProject)subProject, jobBuildState, phaseNestLevel + 1, out);
            }
        }
    }

    private void addSimpleProject(MultiJobProject parent, AbstractProject project, BuildState buildState, int nestLevel, List<TopLevelItem> out) {
        out.add((TopLevelItem)new ProjectWrapper(parent, project, buildState, nestLevel));
    }

    private BuildState createBuildState(BuildState parentBuildState, MultiJobProject multiJobProject, AbstractProject project) {
        AbstractBuild build;
        List subBuilds;
        int previousBuildNumber = 0;
        int lastBuildNumber = 0;
        int lastSuccessBuildNumber = 0;
        int lastFailureBuildNumber = 0;
        MultiJobBuild previousParentBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getPreviousBuildNumber());
        MultiJobBuild lastParentBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getLastBuildNumber());
        MultiJobBuild lastParentSuccessBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getLastSuccessBuildNumber());
        MultiJobBuild lastParentFailureBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getLastFailureBuildNumber());
        if (previousParentBuild != null) {
            subBuilds = previousParentBuild.getSubBuilds();
            for (MultiJobBuild.SubBuild subBuild : subBuilds) {
                if (!subBuild.getJobName().equals(project.getName())) continue;
                previousBuildNumber = subBuild.getBuildNumber();
            }
        }
        if (lastParentBuild != null) {
            subBuilds = lastParentBuild.getSubBuilds();
            for (MultiJobBuild.SubBuild subBuild : subBuilds) {
                if (!subBuild.getJobName().equals(project.getName())) continue;
                lastBuildNumber = subBuild.getBuildNumber();
            }
        }
        if (lastParentSuccessBuild != null) {
            subBuilds = lastParentSuccessBuild.getSubBuilds();
            for (MultiJobBuild.SubBuild subBuild : subBuilds) {
                if (!subBuild.getJobName().equals(project.getName())) continue;
                build = (AbstractBuild)project.getBuildByNumber(subBuild.getBuildNumber());
                if (build != null && Result.SUCCESS.equals((Object)build.getResult())) {
                    lastSuccessBuildNumber = subBuild.getBuildNumber();
                    break;
                }
                lastParentSuccessBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getPreviousBuildNumber());
            }
        }
        if (lastParentFailureBuild != null) {
            subBuilds = lastParentFailureBuild.getSubBuilds();
            for (MultiJobBuild.SubBuild subBuild : subBuilds) {
                if (!subBuild.getJobName().equals(project.getName())) continue;
                build = (AbstractBuild)project.getBuildByNumber(subBuild.getBuildNumber());
                if (build != null && Result.FAILURE.equals((Object)build.getResult())) {
                    lastFailureBuildNumber = subBuild.getBuildNumber();
                    break;
                }
                lastParentFailureBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getPreviousBuildNumber());
            }
        }
        return new BuildState(project.getName(), previousBuildNumber, lastBuildNumber, lastSuccessBuildNumber, lastFailureBuildNumber);
    }

    private BuildState createBuildState(MultiJobProject project) {
        MultiJobBuild lastBuild = (MultiJobBuild)project.getLastBuild();
        MultiJobBuild previousBuild = lastBuild == null ? null : (MultiJobBuild)lastBuild.getPreviousBuild();
        MultiJobBuild lastSuccessfulBuild = (MultiJobBuild)project.getLastSuccessfulBuild();
        MultiJobBuild lastFailedBuild = (MultiJobBuild)project.getLastFailedBuild();
        return new BuildState(project.getName(), previousBuild == null ? 0 : previousBuild.getNumber(), lastBuild == null ? 0 : lastBuild.getNumber(), lastSuccessfulBuild == null ? 0 : lastSuccessfulBuild.getNumber(), lastFailedBuild == null ? 0 : lastFailedBuild.getNumber());
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
    }

    protected void initColumns() {
        try {
            Field field = ListView.class.getDeclaredField("columns");
            field.setAccessible(true);
            field.set(this, new DescribableList((Saveable)this, (Collection)MultiJobListViewColumn.createDefaultInitialColumnList()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Indenter<Job> createIndenter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

