/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobChangeLogSet;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BallColor;
import hudson.model.BaseBuildableProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJobBuild
extends Build<MultiJobProject, MultiJobBuild> {
    MultiJobChangeLogSet changeSets = new MultiJobChangeLogSet((AbstractBuild)this);
    private List<SubBuild> subBuilds;

    public MultiJobBuild(MultiJobProject project) throws IOException {
        super((BaseBuildableProject)project);
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return super.getChangeSet();
    }

    public void addChangeLogSet(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        this.changeSets.addChangeLogSet(changeLogSet);
    }

    public MultiJobBuild(MultiJobProject project, File buildDir) throws IOException {
        super((BaseBuildableProject)project, buildDir);
    }

    public void run() {
        this.run((Run.Runner)new MultiJobRunnerImpl());
    }

    public List<SubBuild> getBuilders() {
        MultiJobBuild multiJobBuild = (MultiJobBuild)((MultiJobProject)this.getParent()).getNearestBuild(this.getNumber());
        List<SubBuild> subBuilds = multiJobBuild.getSubBuilds();
        for (SubBuild subBuild : subBuilds) {
            Run build = this.getBuild(subBuild);
            if (build != null) {
                subBuild.setResult(build.getResult());
                subBuild.setIcon(build.getIconColor().getImage());
                subBuild.setDuration(build.getDurationString());
                subBuild.setUrl(build.getUrl());
                continue;
            }
            subBuild.setIcon(BallColor.GREY.getImage());
            subBuild.setDuration("not built yet");
            subBuild.setUrl(null);
        }
        return subBuilds;
    }

    private Run getBuild(SubBuild subBuild) {
        Run build = null;
        List downstreamProjects = ((MultiJobProject)this.getProject()).getDownstreamProjects();
        for (AbstractProject downstreamProject : downstreamProjects) {
            List upstreamProjects = downstreamProject.getUpstreamProjects();
            if (!upstreamProjects.contains(this.getProject()) || !subBuild.getJobName().equalsIgnoreCase(downstreamProject.getName())) continue;
            build = downstreamProject.getBuildByNumber(subBuild.getBuildNumber());
        }
        return build;
    }

    public void addSubBuild(String parentJobName, int parentBuildNumber, String jobName, int buildNumber, String phaseName, AbstractBuild refBuild) {
        SubBuild subBuild = new SubBuild(parentJobName, parentBuildNumber, jobName, buildNumber, phaseName);
        for (SubBuild subbuild : this.getSubBuilds()) {
            if (!subbuild.getJobName().equals(jobName)) continue;
            this.getSubBuilds().remove(subbuild);
            break;
        }
        this.getSubBuilds().add(subBuild);
    }

    public List<SubBuild> getSubBuilds() {
        if (this.subBuilds == null) {
            this.subBuilds = new ArrayList<SubBuild>();
        }
        return this.subBuilds;
    }

    public static class SubBuild {
        private final String parentJobName;
        private final int parentBuildNumber;
        private final String jobName;
        private final int buildNumber;
        private final String phaseName;
        private Result result;
        private String icon;
        private String duration;
        private String url;

        public SubBuild(String parentJobName, int parentBuildNumber, String jobName, int buildNumber, String phaseName) {
            this.parentJobName = parentJobName;
            this.parentBuildNumber = parentBuildNumber;
            this.jobName = jobName;
            this.buildNumber = buildNumber;
            this.phaseName = phaseName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPhaseName() {
            return this.phaseName;
        }

        public String getParentJobName() {
            return this.parentJobName;
        }

        public int getParentBuildNumber() {
            return this.parentBuildNumber;
        }

        public String getJobName() {
            return this.jobName;
        }

        public int getBuildNumber() {
            return this.buildNumber;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }

        public String toString() {
            return "SubBuild [parentJobName=" + this.parentJobName + ", parentBuildNumber=" + this.parentBuildNumber + ", jobName=" + this.jobName + ", buildNumber=" + this.buildNumber + "]";
        }
    }

    protected class MultiJobRunnerImpl
    extends Build.RunnerImpl {
        protected MultiJobRunnerImpl() {
            super((Build)MultiJobBuild.this);
        }

        public Result run(BuildListener listener) throws Exception {
            Result result = super.run(listener);
            if (this.isFailure()) {
                return Result.FAILURE;
            }
            if (this.isUnstable()) {
                return Result.UNSTABLE;
            }
            return result;
        }

        private boolean isFailure() {
            return this.evaluateResult(Result.UNSTABLE);
        }

        private boolean isUnstable() {
            return this.evaluateResult(Result.SUCCESS);
        }

        private boolean evaluateResult(Result result) {
            List<SubBuild> builders = MultiJobBuild.this.getBuilders();
            for (SubBuild subBuild : builders) {
                Result buildResult = subBuild.getResult();
                if (buildResult == null || !buildResult.isWorseThan(result)) continue;
                return true;
            }
            return false;
        }
    }
}

