/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJobBuilder
extends Builder
implements DependecyDeclarer {
    private String phaseName;
    private List<PhaseJobsConfig> phaseJobs;
    private ContinuationCondition continuationCondition = ContinuationCondition.SUCCESSFUL;

    @DataBoundConstructor
    public MultiJobBuilder(String phaseName, List<PhaseJobsConfig> phaseJobs, ContinuationCondition continuationCondition) {
        this.phaseName = phaseName;
        this.phaseJobs = Util.fixNull(phaseJobs);
        this.continuationCondition = continuationCondition;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Hudson hudson = Hudson.getInstance();
        MultiJobBuild thisBuild = (MultiJobBuild)build;
        MultiJobProject thisProject = (MultiJobProject)thisBuild.getProject();
        HashMap<AbstractProjectKey, PhaseJobsConfig> projects = new HashMap<AbstractProjectKey, PhaseJobsConfig>(this.phaseJobs.size());
        for (PhaseJobsConfig project : this.phaseJobs) {
            TopLevelItem item = hudson.getItem(project.getJobName());
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject job = (AbstractProject)item;
            projects.put(new AbstractProjectKey(job), project);
        }
        ArrayList<Future> futuresList = new ArrayList<Future>();
        ArrayList<AbstractProject> projectList = new ArrayList<AbstractProject>();
        for (AbstractProjectKey projectKey : projects.keySet()) {
            AbstractProject project = projectKey.getProject();
            listener.getLogger().printf("Starting build job %s.\n", HyperlinkNote.encodeTo((String)('/' + project.getUrl()), (String)project.getFullName()));
            PhaseJobsConfig projectConfig = (PhaseJobsConfig)projects.get(projectKey);
            ArrayList<Action> actions = new ArrayList<Action>();
            this.prepareActions(build, project, projectConfig, listener, actions);
            Future future = project.scheduleBuild2(project.getQuietPeriod(), (Cause)new Cause.UpstreamCause(build), actions.toArray(new Action[0]));
            if (future != null) {
                futuresList.add(future);
                projectList.add(project);
            }
            Thread.sleep(1000L);
        }
        boolean failed = false;
        boolean canContinue = true;
        while (!futuresList.isEmpty() && !failed) {
            for (Future future : futuresList) {
                AbstractProject project = (AbstractProject)projectList.get(futuresList.indexOf(future));
                if (future.isDone()) {
                    try {
                        AbstractBuild jobBuild = (AbstractBuild)future.get();
                        Result result = jobBuild.getResult();
                        ChangeLogSet changeLogSet = jobBuild.getChangeSet();
                        if (changeLogSet != null) {
                            ((MultiJobBuild)build).addChangeLogSet((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                        }
                        listener.getLogger().println("Finished Build : " + HyperlinkNote.encodeTo((String)("/" + jobBuild.getUrl() + "/"), (String)String.valueOf(jobBuild.getDisplayName())) + " of Job : " + HyperlinkNote.encodeTo((String)('/' + jobBuild.getProject().getUrl()), (String)jobBuild.getProject().getFullName()) + " with status :" + HyperlinkNote.encodeTo((String)('/' + jobBuild.getUrl() + "/console/"), (String)result.toString()));
                        if (!this.continuationCondition.isContinue(jobBuild)) {
                            failed = true;
                        }
                        this.addSubBuild(thisBuild, thisProject, jobBuild);
                        projectList.remove(project);
                        futuresList.remove(future);
                        break;
                    }
                    catch (ExecutionException e) {
                        failed = true;
                        continue;
                    }
                }
                if (!project.isBuilding()) continue;
                this.addSubBuild(thisBuild, thisProject, (AbstractBuild)project.getLastBuild());
            }
            Thread.sleep(1000L);
        }
        if (failed) {
            for (Future future : futuresList) {
                future.cancel(true);
            }
        }
        canContinue = !failed;
        return canContinue;
    }

    private void addSubBuild(MultiJobBuild thisBuild, MultiJobProject thisProject, AbstractBuild jobBuild) {
        thisBuild.addSubBuild(thisProject.getName(), thisBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, jobBuild);
    }

    private void prepareActions(AbstractBuild build, AbstractProject project, PhaseJobsConfig projectConfig, BuildListener listener, List<Action> actions) throws IOException, InterruptedException {
        List<Action> parametersActions = null;
        parametersActions = projectConfig.getActions(build, (TaskListener)listener, project, projectConfig.isCurrParams());
        actions.addAll(parametersActions);
        Object currParametersAction = null;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public List<PhaseJobsConfig> getPhaseJobs() {
        return this.phaseJobs;
    }

    public void setPhaseJobs(List<PhaseJobsConfig> phaseJobs) {
        this.phaseJobs = phaseJobs;
    }

    public boolean phaseNameExist(String phaseName) {
        for (PhaseJobsConfig phaseJob : this.phaseJobs) {
            if (!phaseJob.getDisplayName().equals(phaseName)) continue;
            return true;
        }
        return false;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        Hudson hudson = Hudson.getInstance();
        List<PhaseJobsConfig> phaseJobsConfigs = this.getPhaseJobs();
        if (phaseJobsConfigs == null) {
            return;
        }
        for (PhaseJobsConfig project : phaseJobsConfigs) {
            TopLevelItem topLevelItem = hudson.getItem(project.getJobName());
            if (!(topLevelItem instanceof AbstractProject)) continue;
            DependencyGraph.Dependency dependency = new DependencyGraph.Dependency(owner, (AbstractProject)topLevelItem){

                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    return false;
                }
            };
            graph.addDependency(dependency);
        }
    }

    public boolean onJobRenamed(String oldName, String newName) {
        boolean changed = false;
        Iterator<PhaseJobsConfig> i = this.phaseJobs.iterator();
        while (i.hasNext()) {
            PhaseJobsConfig phaseJobs = i.next();
            String jobName = phaseJobs.getJobName();
            if (!jobName.trim().equals(oldName)) continue;
            if (newName != null) {
                phaseJobs.setJobName(newName);
                changed = true;
                continue;
            }
            i.remove();
            changed = true;
        }
        return changed;
    }

    public boolean onJobDeleted(String oldName) {
        return this.onJobRenamed(oldName, null);
    }

    public ContinuationCondition getContinuationCondition() {
        return this.continuationCondition;
    }

    public void setContinuationCondition(ContinuationCondition continuationCondition) {
        this.continuationCondition = continuationCondition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContinuationCondition {
        SUCCESSFUL("Successful"){

            public boolean isContinue(AbstractBuild build) {
                return build.getResult().equals((Object)Result.SUCCESS);
            }
        }
        ,
        UNSTABLE("Stable or Unstable but not Failed"){

            public boolean isContinue(AbstractBuild build) {
                return build.getResult().isBetterOrEqualTo(Result.UNSTABLE);
            }
        }
        ,
        COMPLETED("Complete (always continue)"){

            public boolean isContinue(AbstractBuild build) {
                return build.getResult().isBetterOrEqualTo(Result.FAILURE);
            }
        };

        private final String label;

        public abstract boolean isContinue(AbstractBuild var1);

        private ContinuationCondition(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType.equals(MultiJobProject.class);
        }

        public String getDisplayName() {
            return "MultiJob Phase";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(MultiJobBuilder.class, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.save();
            return true;
        }
    }

    private static final class AbstractProjectKey {
        private AbstractProject project;

        AbstractProjectKey(AbstractProject project) {
            this.project = project;
        }

        public AbstractProject getProject() {
            return this.project;
        }
    }
}

