/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.FileBuildParameters;
import com.tikal.jenkins.plugins.multijob.PredefinedBuildParameters;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FileParameterValue;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PhaseJobsConfig
implements Describable<PhaseJobsConfig> {
    private String jobName;
    private String jobProperties;
    private boolean currParams;
    private boolean exposedSCM;
    private List<AbstractBuildParameters> configs;

    public boolean isExposedSCM() {
        return this.currParams;
    }

    public void setExposedSCM(boolean exposedSCM) {
        this.exposedSCM = exposedSCM;
    }

    public boolean isCurrParams() {
        return this.currParams;
    }

    public void setCurrParams(boolean currParams) {
        this.currParams = currParams;
    }

    public String getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(String jobProperties) {
        this.jobProperties = jobProperties;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Descriptor<PhaseJobsConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    @DataBoundConstructor
    public PhaseJobsConfig(String jobName, String jobProperties, boolean currParams, List<AbstractBuildParameters> configs) {
        this.jobName = jobName;
        this.jobProperties = jobProperties;
        this.currParams = currParams;
        this.configs = Util.fixNull(configs);
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<ParameterValue> getJobParameters(AbstractBuild<?, ?> build, TaskListener listener) {
        ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>(action.getParameters().size());
        if (action != null) {
            for (ParameterValue value : action.getParameters()) {
                if (value instanceof FileParameterValue) continue;
                values.add(value);
            }
        }
        return values;
    }

    private static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            if (param == null) continue;
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    public List<Action> getActions(AbstractBuild build, TaskListener listener, AbstractProject project, boolean isCurrentInclude) throws IOException, InterruptedException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        LinkedList<ParameterValue> paramsValuesList = new LinkedList<ParameterValue>();
        List originalActions = project.getActions();
        ParametersDefinitionProperty parameters = null;
        for (Object object : originalActions) {
            if (!(object instanceof ParametersDefinitionProperty)) continue;
            parameters = (ParametersDefinitionProperty)object;
        }
        if (parameters != null) {
            for (ParameterDefinition parameterdef : parameters.getParameterDefinitions()) {
                if (parameterdef.getDefaultParameterValue() == null) continue;
                paramsValuesList.add(parameterdef.getDefaultParameterValue());
            }
            params = new ParametersAction(paramsValuesList.toArray(new ParameterValue[paramsValuesList.size()]));
        }
        if (isCurrentInclude) {
            ParametersAction defaultParameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null && defaultParameters != null) {
                params = PhaseJobsConfig.mergeParameters((ParametersAction)params, (ParametersAction)defaultParameters);
            } else if (params == null) {
                params = defaultParameters;
            }
        }
        if (this.configs != null) {
            for (AbstractBuildParameters config : this.configs) {
                try {
                    Action a = config.getAction(build, listener);
                    if (a instanceof ParametersAction) {
                        params = params == null ? (ParametersAction)a : PhaseJobsConfig.mergeParameters((ParametersAction)params, (ParametersAction)((ParametersAction)a));
                        continue;
                    }
                    if (a == null) continue;
                    actions.add(a);
                }
                catch (AbstractBuildParameters.DontTriggerException e) {
                    listener.getLogger().println("[multiJob] DontTriggerException: " + (Object)((Object)e));
                }
            }
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    public boolean hasProperties() {
        return this.jobProperties != null && !this.jobProperties.isEmpty();
    }

    public Object readResolve() {
        if (this.hasProperties()) {
            hudson.plugins.parameterizedtrigger.PredefinedBuildParameters buildParameters = new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(this.jobProperties);
            if (this.configs == null) {
                this.configs = new ArrayList();
            }
            this.configs.add(buildParameters);
        }
        ArrayList<Object> oldParams = new ArrayList<Object>();
        if (this.configs != null && this.configs.size() > 0) {
            Iterator parametersIterator = this.configs.iterator();
            while (parametersIterator.hasNext()) {
                Object param = parametersIterator.next();
                if (param instanceof PredefinedBuildParameters) {
                    PredefinedBuildParameters previosStringParam = (PredefinedBuildParameters)param;
                    parametersIterator.remove();
                    oldParams.add(new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(previosStringParam.getJobProperties()));
                    continue;
                }
                if (!(param instanceof FileBuildParameters)) continue;
                FileBuildParameters previosFileParam = (FileBuildParameters)param;
                parametersIterator.remove();
                oldParams.add(new hudson.plugins.parameterizedtrigger.FileBuildParameters(previosFileParam.getPropertiesFile()));
            }
            this.configs.addAll(oldParams);
        }
        return this;
    }
}

