/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.FileBuildParameters;
import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.PredefinedBuildParameters;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.FileParameterValue;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseJobsConfig
implements Describable<PhaseJobsConfig> {
    private String jobName;
    private String jobProperties;
    private boolean currParams;
    private boolean exposedSCM;
    private List<AbstractBuildParameters> configs;

    public boolean isExposedSCM() {
        return this.currParams;
    }

    public void setExposedSCM(boolean exposedSCM) {
        this.exposedSCM = exposedSCM;
    }

    public boolean isCurrParams() {
        return this.currParams;
    }

    public void setCurrParams(boolean currParams) {
        this.currParams = currParams;
    }

    public String getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(String jobProperties) {
        this.jobProperties = jobProperties;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Descriptor<PhaseJobsConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    @DataBoundConstructor
    public PhaseJobsConfig(String jobName, String jobProperties, boolean currParams, List<AbstractBuildParameters> configs) {
        this.jobName = jobName;
        this.jobProperties = jobProperties;
        this.currParams = currParams;
        this.configs = Util.fixNull(configs);
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<ParameterValue> getJobParameters(AbstractBuild<?, ?> build, TaskListener listener) {
        ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>(action.getParameters().size());
        if (action != null) {
            for (ParameterValue value : action.getParameters()) {
                if (value instanceof FileParameterValue) continue;
                values.add(value);
            }
        }
        return values;
    }

    private static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            if (param == null) continue;
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    public List<Action> getActions(AbstractBuild build, TaskListener listener, AbstractProject project, boolean isCurrentInclude) throws IOException, InterruptedException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        LinkedList<ParameterValue> paramsValuesList = new LinkedList<ParameterValue>();
        List originalActions = project.getActions();
        ParametersDefinitionProperty parameters = null;
        for (Object object : originalActions) {
            if (!(object instanceof ParametersDefinitionProperty)) continue;
            parameters = (ParametersDefinitionProperty)object;
        }
        if (parameters != null) {
            for (ParameterDefinition parameterdef : parameters.getParameterDefinitions()) {
                if (parameterdef.getDefaultParameterValue() == null) continue;
                paramsValuesList.add(parameterdef.getDefaultParameterValue());
            }
            params = new ParametersAction(paramsValuesList.toArray(new ParameterValue[paramsValuesList.size()]));
        }
        if (isCurrentInclude) {
            ParametersAction defaultParameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null && defaultParameters != null) {
                params = PhaseJobsConfig.mergeParameters(params, defaultParameters);
            } else if (params == null) {
                params = defaultParameters;
            }
        }
        if (this.configs != null) {
            for (AbstractBuildParameters config : this.configs) {
                try {
                    Action a = config.getAction(build, listener);
                    if (a instanceof ParametersAction) {
                        params = params == null ? (ParametersAction)a : PhaseJobsConfig.mergeParameters(params, (ParametersAction)a);
                        continue;
                    }
                    if (a == null) continue;
                    actions.add(a);
                }
                catch (AbstractBuildParameters.DontTriggerException e) {
                    listener.getLogger().println("[multiJob] DontTriggerException: " + (Object)((Object)e));
                }
            }
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    public boolean hasProperties() {
        return this.jobProperties != null && !this.jobProperties.isEmpty();
    }

    public Object readResolve() {
        if (this.hasProperties()) {
            hudson.plugins.parameterizedtrigger.PredefinedBuildParameters buildParameters = new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(this.jobProperties);
            if (this.configs == null) {
                this.configs = new ArrayList<AbstractBuildParameters>();
            }
            this.configs.add((AbstractBuildParameters)buildParameters);
        }
        ArrayList<Object> oldParams = new ArrayList<Object>();
        if (this.configs != null && this.configs.size() > 0) {
            Iterator<AbstractBuildParameters> parametersIterator = this.configs.iterator();
            while (parametersIterator.hasNext()) {
                AbstractBuildParameters param = parametersIterator.next();
                if (param instanceof PredefinedBuildParameters) {
                    PredefinedBuildParameters previosStringParam = (PredefinedBuildParameters)param;
                    parametersIterator.remove();
                    oldParams.add(new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(previosStringParam.getJobProperties()));
                    continue;
                }
                if (!(param instanceof FileBuildParameters)) continue;
                FileBuildParameters previosFileParam = (FileBuildParameters)param;
                parametersIterator.remove();
                oldParams.add(new hudson.plugins.parameterizedtrigger.FileBuildParameters(previosFileParam.getPropertiesFile()));
            }
            this.configs.addAll(oldParams);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<PhaseJobsConfig> {
        public String getDisplayName() {
            return "Phase Jobs Config";
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        public AutoCompletionCandidates doAutoCompleteJobName(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            for (String localJobName : Hudson.getInstance().getJobNames()) {
                if (!localJobName.toLowerCase().startsWith(value.toLowerCase())) continue;
                c.add(localJobName);
            }
            return c;
        }

        public FormValidation doCheckJobName(@QueryParameter String value) {
            FormValidation result = FormValidation.errorWithMarkup((String)"Invalid job name");
            if (value.isEmpty()) {
                result = FormValidation.errorWithMarkup((String)"Job name must not be empty");
            } else {
                for (String localJobName : Hudson.getInstance().getJobNames()) {
                    if (!localJobName.toLowerCase().equals(value.toLowerCase())) continue;
                    result = FormValidation.ok();
                }
            }
            return result;
        }

        private void savePhaseJobConfigParameters(String localJobName) {
            MultiJobProject parentProject;
            List builders;
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItem(localJobName);
            List<ParameterDefinition> parameterDefinitions = this.getParameterDefinition(project);
            StringBuilder sb = new StringBuilder();
            for (ParameterDefinition pdef : parameterDefinitions) {
                String paramValue = null;
                if (pdef instanceof StringParameterDefinition) {
                    StringParameterDefinition stringParameterDefinition = (StringParameterDefinition)pdef;
                    paramValue = stringParameterDefinition.getDefaultParameterValue().value;
                } else if (pdef instanceof BooleanParameterDefinition) {
                    BooleanParameterDefinition booleanParameterDefinition = (BooleanParameterDefinition)pdef;
                    paramValue = String.valueOf(booleanParameterDefinition.getDefaultParameterValue().value);
                }
                sb.append(pdef.getName()).append("=").append(paramValue).append("\n");
            }
            AbstractProject item = this.getCurrentJob();
            if (item instanceof MultiJobProject && (builders = (parentProject = (MultiJobProject)item).getBuilders()) != null) {
                for (Builder builder : builders) {
                    if (!(builder instanceof MultiJobBuilder)) continue;
                    MultiJobBuilder multiJobBuilder = (MultiJobBuilder)builder;
                    List<PhaseJobsConfig> phaseJobs = multiJobBuilder.getPhaseJobs();
                    for (PhaseJobsConfig phaseJob : phaseJobs) {
                        if (!phaseJob.getJobName().equals(localJobName)) continue;
                        phaseJob.setJobProperties(sb.toString());
                        this.save();
                    }
                }
            }
        }

        private String getCurrentDescriptorByNameUrl() {
            StaplerRequest req = Stapler.getCurrentRequest();
            Ancestor a = req.findAncestor(DescriptorByNameOwner.class);
            return a.getUrl();
        }

        private AbstractProject getCurrentJob() {
            String nameUrl = this.getCurrentDescriptorByNameUrl();
            String jobName = nameUrl.substring(nameUrl.lastIndexOf("/") + 1);
            return (AbstractProject)Hudson.getInstance().getItem(jobName);
        }

        public List<ParameterDefinition> getParameterDefinition(AbstractProject project) {
            ArrayList<ParameterDefinition> list = new ArrayList<ParameterDefinition>();
            Map map = project.getProperties();
            for (Map.Entry entry : map.entrySet()) {
                JobProperty property = (JobProperty)entry.getValue();
                if (!(property instanceof ParametersDefinitionProperty)) continue;
                ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)property;
                for (ParameterDefinition parameterDefinition : pdp.getParameterDefinitions()) {
                    if (!(parameterDefinition instanceof StringParameterDefinition) && !(parameterDefinition instanceof BooleanParameterDefinition) && !(parameterDefinition instanceof ChoiceParameterDefinition)) continue;
                    list.add(parameterDefinition);
                }
            }
            return list;
        }

        public String doFillJobProperties(@QueryParameter String jobName) {
            return "fill=in";
        }
    }
}

