/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Plugin
extends hudson.Plugin {

    @Extension
    public static final class RenameListener
    extends ItemListener {
        public void onRenamed(Item renamedItem, String oldName, String newName) {
            List items = Hudson.getInstance().getItems();
            for (TopLevelItem item : items) {
                if (!(item instanceof MultiJobProject)) continue;
                boolean changed = false;
                List builders = null;
                MultiJobProject project = (MultiJobProject)item;
                builders = project.getBuilders();
                if (builders == null) continue;
                for (Builder builder : builders) {
                    MultiJobBuilder multiJobBuilder;
                    if (!(builder instanceof MultiJobBuilder) || !(changed |= (multiJobBuilder = (MultiJobBuilder)builder).onJobRenamed(oldName, newName))) continue;
                    try {
                        project.save();
                    }
                    catch (IOException e) {
                        Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }

        public void onDeleted(Item deletedItem) {
            String oldName = deletedItem.getName();
            List items = Hudson.getInstance().getItems();
            for (TopLevelItem item : items) {
                if (!(item instanceof MultiJobProject)) continue;
                boolean changed = false;
                List builders = null;
                MultiJobProject project = (MultiJobProject)item;
                builders = project.getBuilders();
                if (builders == null) continue;
                for (Builder builder : builders) {
                    MultiJobBuilder multiJobBuilder;
                    if (!(builder instanceof MultiJobBuilder) || !(changed |= (multiJobBuilder = (MultiJobBuilder)builder).onJobDeleted(oldName))) continue;
                    try {
                        int phaseJobsCounter = multiJobBuilder.getPhaseJobs().size();
                        if (phaseJobsCounter == 0) {
                            project.getBuildersList().remove((Object)multiJobBuilder);
                        }
                        project.save();
                    }
                    catch (IOException e) {
                        Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during remove of " + oldName, e);
                    }
                }
            }
        }
    }
}

