// CHECKSTYLE:OFF

package hudson.plugins.jira;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Mark a JIRA Version as Released
     * 
     */
    public static String JiraReleaseVersionBuilder_DisplayName() {
        return holder.format("JiraReleaseVersionBuilder.DisplayName");
    }

    /**
     * Mark a JIRA Version as Released
     * 
     */
    public static Localizable _JiraReleaseVersionBuilder_DisplayName() {
        return new Localizable(holder, "JiraReleaseVersionBuilder.DisplayName");
    }

    /**
     * A workflow action is required.
     * 
     */
    public static String JiraIssueUpdateBuilder_NoWorkflowAction() {
        return holder.format("JiraIssueUpdateBuilder.NoWorkflowAction");
    }

    /**
     * A workflow action is required.
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_NoWorkflowAction() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.NoWorkflowAction");
    }

    /**
     * The system configuration does not allow remote JIRA access
     * 
     */
    public static String Updater_NoRemoteAccess() {
        return holder.format("Updater.NoRemoteAccess");
    }

    /**
     * The system configuration does not allow remote JIRA access
     * 
     */
    public static Localizable _Updater_NoRemoteAccess() {
        return new Localizable(holder, "Updater.NoRemoteAccess");
    }

    /**
     * No jira site is configured for this project. This must be a project configuration error
     * 
     */
    public static String Updater_NoJiraSite() {
        return holder.format("Updater.NoJiraSite");
    }

    /**
     * No jira site is configured for this project. This must be a project configuration error
     * 
     */
    public static Localizable _Updater_NoJiraSite() {
        return new Localizable(holder, "Updater.NoJiraSite");
    }

    /**
     * Hudson URL is not configured yet. Go to system configuration to set this value
     * 
     */
    public static String Updater_NoJenkinsUrl() {
        return holder.format("Updater.NoJenkinsUrl");
    }

    /**
     * Hudson URL is not configured yet. Go to system configuration to set this value
     * 
     */
    public static Localizable _Updater_NoJenkinsUrl() {
        return new Localizable(holder, "Updater.NoJenkinsUrl");
    }

    /**
     * [JIRA] Updating issues using workflow action {0}.
     * 
     */
    public static String JiraIssueUpdateBuilder_UpdatingWithAction(Object arg1) {
        return holder.format("JiraIssueUpdateBuilder.UpdatingWithAction", arg1);
    }

    /**
     * [JIRA] Updating issues using workflow action {0}.
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_UpdatingWithAction(Object arg1) {
        return new Localizable(holder, "JiraIssueUpdateBuilder.UpdatingWithAction", arg1);
    }

    /**
     * JIRA URL is a mandatory field
     * 
     */
    public static String JiraProjectProperty_JiraUrlMandatory() {
        return holder.format("JiraProjectProperty.JiraUrlMandatory");
    }

    /**
     * JIRA URL is a mandatory field
     * 
     */
    public static Localizable _JiraProjectProperty_JiraUrlMandatory() {
        return new Localizable(holder, "JiraProjectProperty.JiraUrlMandatory");
    }

    /**
     * [JIRA] Unable to update issue {0}: invalid workflow action "{1}". Perhaps the Hudson user does not have permission to perform the action on the JIRA issue?
     * 
     */
    public static String JiraIssueUpdateBuilder_UnknownWorkflowAction(Object arg1, Object arg2) {
        return holder.format("JiraIssueUpdateBuilder.UnknownWorkflowAction", arg1, arg2);
    }

    /**
     * [JIRA] Unable to update issue {0}: invalid workflow action "{1}". Perhaps the Hudson user does not have permission to perform the action on the JIRA issue?
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_UnknownWorkflowAction(Object arg1, Object arg2) {
        return new Localizable(holder, "JiraIssueUpdateBuilder.UnknownWorkflowAction", arg1, arg2);
    }

    /**
     * Please set the JQL used to select the issues to update.
     * 
     */
    public static String JiraIssueUpdateBuilder_NoJqlSearch() {
        return holder.format("JiraIssueUpdateBuilder.NoJqlSearch");
    }

    /**
     * Please set the JQL used to select the issues to update.
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_NoJqlSearch() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.NoJqlSearch");
    }

    /**
     * Failed to connect to JIRA
     * 
     */
    public static String Updater_FailedToConnect() {
        return holder.format("Updater.FailedToConnect");
    }

    /**
     * Failed to connect to JIRA
     * 
     */
    public static Localizable _Updater_FailedToConnect() {
        return new Localizable(holder, "Updater.FailedToConnect");
    }

    /**
     * This is a valid URL but it doesn''t look like JIRA
     * 
     */
    public static String JiraProjectProperty_NotAJiraUrl() {
        return holder.format("JiraProjectProperty.NotAJiraUrl");
    }

    /**
     * This is a valid URL but it doesn''t look like JIRA
     * 
     */
    public static Localizable _JiraProjectProperty_NotAJiraUrl() {
        return new Localizable(holder, "JiraProjectProperty.NotAJiraUrl");
    }

    /**
     * This looks like a JIRA instance but no WSDL is available. Perhaps SOAP support is not enabled yet?
     * 
     */
    public static String JiraProjectProperty_NoWsdlAvailable() {
        return holder.format("JiraProjectProperty.NoWsdlAvailable");
    }

    /**
     * This looks like a JIRA instance but no WSDL is available. Perhaps SOAP support is not enabled yet?
     * 
     */
    public static Localizable _JiraProjectProperty_NoWsdlAvailable() {
        return new Localizable(holder, "JiraProjectProperty.NoWsdlAvailable");
    }

    /**
     * Associated JIRA
     * 
     */
    public static String JiraProjectProperty_DisplayName() {
        return holder.format("JiraProjectProperty.DisplayName");
    }

    /**
     * Associated JIRA
     * 
     */
    public static Localizable _JiraProjectProperty_DisplayName() {
        return new Localizable(holder, "JiraProjectProperty.DisplayName");
    }

    /**
     * Update relevant JIRA issues
     * 
     */
    public static String JiraIssueUpdater_DisplayName() {
        return holder.format("JiraIssueUpdater.DisplayName");
    }

    /**
     * Update relevant JIRA issues
     * 
     */
    public static Localizable _JiraIssueUpdater_DisplayName() {
        return new Localizable(holder, "JiraIssueUpdater.DisplayName");
    }

    /**
     * [JIRA] An error occurred while progressing issues:
     * 
     */
    public static String JiraIssueUpdateBuilder_Failed() {
        return holder.format("JiraIssueUpdateBuilder.Failed");
    }

    /**
     * [JIRA] An error occurred while progressing issues:
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_Failed() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.Failed");
    }

    /**
     * Progress JIRA issues by workflow action
     * 
     */
    public static String JiraIssueUpdateBuilder_DisplayName() {
        return holder.format("JiraIssueUpdateBuilder.DisplayName");
    }

    /**
     * Progress JIRA issues by workflow action
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_DisplayName() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.DisplayName");
    }

    /**
     * Move issues matching JQL to the specified version
     * 
     */
    public static String JiraReleaseVersionMigrator_DisplayName() {
        return holder.format("JiraReleaseVersionMigrator.DisplayName");
    }

    /**
     * Move issues matching JQL to the specified version
     * 
     */
    public static Localizable _JiraReleaseVersionMigrator_DisplayName() {
        return new Localizable(holder, "JiraReleaseVersionMigrator.DisplayName");
    }

    /**
     * JIRA issues
     * 
     */
    public static String JiraBuildAction_DisplayName() {
        return holder.format("JiraBuildAction.DisplayName");
    }

    /**
     * JIRA issues
     * 
     */
    public static Localizable _JiraBuildAction_DisplayName() {
        return new Localizable(holder, "JiraBuildAction.DisplayName");
    }

    /**
     * [JIRA] At least one issue failed to update.  See log above for more details.
     * 
     */
    public static String JiraIssueUpdateBuilder_SomeIssuesFailed() {
        return holder.format("JiraIssueUpdateBuilder.SomeIssuesFailed");
    }

    /**
     * [JIRA] At least one issue failed to update.  See log above for more details.
     * 
     */
    public static Localizable _JiraIssueUpdateBuilder_SomeIssuesFailed() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.SomeIssuesFailed");
    }

    /**
     * Updating {0}
     * 
     */
    public static String Updater_Updating(Object arg1) {
        return holder.format("Updater.Updating", arg1);
    }

    /**
     * Updating {0}
     * 
     */
    public static Localizable _Updater_Updating(Object arg1) {
        return new Localizable(holder, "Updater.Updating", arg1);
    }

}
