/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.soap.JiraSoapService;
import hudson.plugins.jira.soap.RemoteComment;
import hudson.plugins.jira.soap.RemoteFieldValue;
import hudson.plugins.jira.soap.RemoteGroup;
import hudson.plugins.jira.soap.RemoteIssue;
import hudson.plugins.jira.soap.RemoteIssueType;
import hudson.plugins.jira.soap.RemoteNamedObject;
import hudson.plugins.jira.soap.RemoteProject;
import hudson.plugins.jira.soap.RemoteProjectRole;
import hudson.plugins.jira.soap.RemoteStatus;
import hudson.plugins.jira.soap.RemoteValidationException;
import hudson.plugins.jira.soap.RemoteVersion;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraSession {
    public final JiraSoapService service;
    public final String token;
    private Set<String> projectKeys;
    private final JiraSite site;
    private static final Logger LOGGER = Logger.getLogger(JiraSession.class.getName());
    private HashMap<String, String> knownStatuses = null;

    JiraSession(JiraSite site, JiraSoapService service, String token) {
        this.service = service;
        this.token = token;
        this.site = site;
    }

    public Set<String> getProjectKeys() throws RemoteException {
        if (this.projectKeys == null) {
            LOGGER.fine("Fetching remote project key list from " + this.site.getName());
            RemoteProject[] remoteProjects = this.service.getProjectsNoSchemes(this.token);
            this.projectKeys = new HashSet(remoteProjects.length);
            for (RemoteProject p : remoteProjects) {
                this.projectKeys.add(p.getKey().toUpperCase());
            }
            LOGGER.fine("Project list=" + this.projectKeys);
        }
        return this.projectKeys;
    }

    public void addComment(String issueId, String comment, String groupVisibility, String roleVisibility) throws RemoteException {
        RemoteComment rc = new RemoteComment();
        rc.setBody(comment);
        try {
            if (roleVisibility != null && !roleVisibility.equals("") && this.getRole(roleVisibility) != null) {
                rc.setRoleLevel(roleVisibility);
            }
        }
        catch (RemoteValidationException rve) {
            LOGGER.throwing(this.getClass().toString(), "setRoleLevel", rve);
        }
        try {
            if (groupVisibility != null && !groupVisibility.equals("") && this.getGroup(groupVisibility) != null) {
                rc.setGroupLevel(groupVisibility);
            }
        }
        catch (RemoteValidationException rve) {
            LOGGER.throwing(this.getClass().toString(), "setGroupLevel", rve);
        }
        this.service.addComment(this.token, issueId, rc);
    }

    public RemoteIssue getIssue(String id) throws RemoteException {
        if (this.existsIssue(id)) {
            return this.service.getIssue(this.token, id);
        }
        return null;
    }

    public RemoteIssue[] getIssuesFromJqlSearch(String jqlSearch) throws RemoteException {
        return this.service.getIssuesFromJqlSearch(this.token, jqlSearch, 50);
    }

    public RemoteGroup getGroup(String groupId) throws RemoteException {
        LOGGER.fine("Fetching groupInfo from " + groupId);
        return this.service.getGroup(this.token, groupId);
    }

    public RemoteProjectRole getRole(String roleId) throws RemoteException {
        LOGGER.fine("Fetching roleInfo from " + roleId);
        RemoteProjectRole[] roles = this.service.getProjectRoles(this.token);
        if (roles != null && roles.length > 0) {
            for (RemoteProjectRole role : roles) {
                if (role == null || role.getName() == null || !role.getName().equals(roleId)) continue;
                return role;
            }
        }
        LOGGER.info("Did not find role named " + roleId + ".");
        return null;
    }

    public RemoteVersion[] getVersions(String projectKey) throws RemoteException {
        LOGGER.fine("Fetching versions from project: " + projectKey);
        return this.service.getVersions(this.token, projectKey);
    }

    public RemoteVersion getVersionByName(String projectKey, String name) throws RemoteException {
        LOGGER.fine("Fetching versions from project: " + projectKey);
        RemoteVersion[] versions = this.getVersions(projectKey);
        if (versions == null) {
            return null;
        }
        for (RemoteVersion version : versions) {
            if (!version.getName().equals(name)) continue;
            return version;
        }
        return null;
    }

    public RemoteIssue[] getIssuesWithFixVersion(String projectKey, String version) throws RemoteException {
        return this.getIssuesWithFixVersion(projectKey, version, "");
    }

    public RemoteIssue[] getIssuesWithFixVersion(String projectKey, String version, String filter) throws RemoteException {
        LOGGER.fine("Fetching versions from project: " + projectKey + " with fixVersion:" + version);
        if (filter != null && !filter.isEmpty()) {
            return this.service.getIssuesFromJqlSearch(this.token, String.format("project = \"%s\" and fixVersion = \"%s\" and " + filter, projectKey, version), Integer.MAX_VALUE);
        }
        return this.service.getIssuesFromJqlSearch(this.token, String.format("project = \"%s\" and fixVersion = \"%s\"", projectKey, version), Integer.MAX_VALUE);
    }

    public RemoteIssueType[] getIssueTypes() throws RemoteException {
        LOGGER.fine("Fetching issue types");
        return this.service.getIssueTypes(this.token);
    }

    public boolean existsIssue(String id) throws RemoteException {
        return this.site.existsIssue(id);
    }

    public void releaseVersion(String projectKey, RemoteVersion version) throws RemoteException {
        LOGGER.fine("Releaseing version: " + version.getName());
        this.service.releaseVersion(this.token, projectKey, version);
    }

    public void migrateIssuesToFixVersion(String projectKey, String version, String query) throws RemoteException {
        RemoteVersion newVersion = this.getVersionByName(projectKey, version);
        if (newVersion == null) {
            return;
        }
        LOGGER.fine("Fetching versions with JQL:" + query);
        RemoteIssue[] issues = this.service.getIssuesFromJqlSearch(this.token, query, Integer.MAX_VALUE);
        if (issues == null) {
            return;
        }
        LOGGER.fine("Found issues: " + issues.length);
        RemoteFieldValue value = new RemoteFieldValue("fixVersions", new String[]{newVersion.getId()});
        for (RemoteIssue issue : issues) {
            LOGGER.fine("Migrating issue: " + issue.getKey());
            this.service.updateIssue(this.token, issue.getKey(), new RemoteFieldValue[]{value});
        }
    }

    public String progressWorkflowAction(String issueKey, String workflowActionName, RemoteFieldValue[] fields) throws RemoteException {
        LOGGER.fine("Progressing issue " + issueKey + " with workflow action: " + workflowActionName);
        RemoteIssue issue = this.service.progressWorkflowAction(this.token, issueKey, workflowActionName, fields);
        return this.getStatusById(issue.getStatus());
    }

    public String getActionIdForIssue(String issueKey, String workflowAction) throws RemoteException {
        RemoteNamedObject[] actions = this.service.getAvailableActions(this.token, issueKey);
        if (actions != null) {
            for (RemoteNamedObject action : actions) {
                if (!workflowAction.equalsIgnoreCase(action.getName())) continue;
                return action.getId();
            }
        }
        return null;
    }

    public String getStatusById(String statusId) throws RemoteException {
        String status = (String)this.getKnownStatuses().get(statusId);
        if (status == null) {
            LOGGER.warning("JIRA status could not be found: " + statusId + ". Checking JIRA for new status types.");
            this.knownStatuses = null;
            status = (String)this.getKnownStatuses().get(statusId);
        }
        return status;
    }

    private HashMap<String, String> getKnownStatuses() throws RemoteException {
        if (this.knownStatuses == null) {
            RemoteStatus[] statuses = this.service.getStatuses(this.token);
            this.knownStatuses = new HashMap(statuses.length);
            for (RemoteStatus status : statuses) {
                this.knownStatuses.put(status.getId(), status.getName());
            }
        }
        return this.knownStatuses;
    }
}

