/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraCarryOverAction;
import hudson.plugins.jira.JiraIssue;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.listissuesparameter.JiraIssueParameterValue;
import hudson.plugins.jira.soap.RemotePermissionException;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
class Updater {
    private static final Logger LOGGER = Logger.getLogger(Updater.class.getName());
    public static boolean debug = false;

    Updater() {
    }

    static boolean perform(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        block11: {
            PrintStream logger = listener.getLogger();
            List issues = null;
            try {
                JiraSite site = JiraSite.get((AbstractProject)build.getProject());
                if (site == null) {
                    logger.println(Messages.Updater_NoJiraSite());
                    build.setResult(Result.FAILURE);
                    return true;
                }
                String rootUrl = Hudson.getInstance().getRootUrl();
                if (rootUrl == null) {
                    logger.println(Messages.Updater_NoJenkinsUrl());
                    build.setResult(Result.FAILURE);
                    return true;
                }
                Set ids = Updater.findIssueIdsRecursive(build, (Pattern)site.getIssuePattern(), (BuildListener)listener);
                if (ids.isEmpty()) {
                    if (debug) {
                        logger.println("No JIRA issues found.");
                    }
                    return true;
                }
                JiraSession session = null;
                try {
                    session = site.createSession();
                }
                catch (ServiceException e) {
                    listener.getLogger().println(Messages.Updater_FailedToConnect());
                    e.printStackTrace(listener.getLogger());
                }
                if (session == null) {
                    logger.println(Messages.Updater_NoRemoteAccess());
                    build.setResult(Result.FAILURE);
                    return true;
                }
                boolean doUpdate = false;
                doUpdate = site.updateJiraIssueForAllStatus ? true : build.getResult().isBetterOrEqualTo(Result.UNSTABLE);
                boolean useWikiStyleComments = site.supportsWikiStyleComment;
                issues = Updater.getJiraIssues((Set)ids, (JiraSession)session, (PrintStream)logger);
                build.getActions().add(new JiraBuildAction(build, (Collection)issues));
                if (doUpdate) {
                    Updater.submitComments(build, (PrintStream)logger, (String)rootUrl, (List)issues, (JiraSession)session, (boolean)useWikiStyleComments, (boolean)site.recordScmChanges, (String)site.groupVisibility, (String)site.roleVisibility);
                } else {
                    build.addAction((Action)new JiraCarryOverAction(issues));
                }
            }
            catch (Exception e) {
                logger.println("Error updating JIRA issues. Saving issues for next build.\n" + e);
                if (issues == null || issues.isEmpty()) break block11;
                build.addAction((Action)new JiraCarryOverAction(issues));
            }
        }
        return true;
    }

    static void submitComments(AbstractBuild<?, ?> build, PrintStream logger, String jenkinsRootUrl, List<JiraIssue> issues, JiraSession session, boolean useWikiStyleComments, boolean recordScmChanges, String groupVisibility, String roleVisibility) throws RemoteException {
        ArrayList<JiraIssue> copy = new ArrayList<JiraIssue>(issues);
        for (JiraIssue issue : copy) {
            try {
                logger.println(Messages.Updater_Updating((Object)issue.id));
                StringBuilder aggregateComment = new StringBuilder();
                for (ChangeLogSet.Entry e : build.getChangeSet()) {
                    if (!e.getMsg().toUpperCase().contains(issue.id)) continue;
                    aggregateComment.append(e.getMsg());
                    String revision = Updater.getRevision((ChangeLogSet.Entry)e);
                    if (revision != null) {
                        aggregateComment.append(" (Revision ").append(revision).append(")");
                    }
                    aggregateComment.append("\n");
                }
                session.addComment(issue.id, Updater.createComment(build, (boolean)useWikiStyleComments, (String)jenkinsRootUrl, (String)aggregateComment.toString(), (boolean)recordScmChanges, (JiraIssue)issue), groupVisibility, roleVisibility);
            }
            catch (RemotePermissionException e) {
                logger.println("Looks like " + issue.id + " is no valid JIRA issue or you don't have permission to update the issue.\n" + "Issue will not be updated.\n" + (Object)((Object)e));
                issues.remove(issue);
            }
        }
    }

    private static List<JiraIssue> getJiraIssues(Set<String> ids, JiraSession session, PrintStream logger) throws RemoteException {
        ArrayList<JiraIssue> issues = new ArrayList<JiraIssue>(ids.size());
        for (String id : ids) {
            if (!session.existsIssue(id)) {
                if (!debug) continue;
                logger.println(id + " looked like a JIRA issue but it wasn't");
                continue;
            }
            issues.add(new JiraIssue(session.getIssue(id)));
        }
        return issues;
    }

    private static String createComment(AbstractBuild<?, ?> build, boolean wikiStyle, String jenkinsRootUrl, String scmComments, boolean recordScmChanges, JiraIssue jiraIssue) {
        String comment = String.format(wikiStyle ? "Integrated in !%1$simages/16x16/%3$s! [%2$s|%4$s]\n     %5$s\n     Result = %6$s" : "Integrated in %2$s (See [%4$s])\n    %5$s\n     Result = %6$s", jenkinsRootUrl, build, build.getResult().color.getImage(), Util.encode((String)(jenkinsRootUrl + build.getUrl())), scmComments, build.getResult().toString());
        if (recordScmChanges) {
            List scmChanges = Updater.getScmComments((boolean)wikiStyle, build, (JiraIssue)jiraIssue);
            StringBuilder sb = new StringBuilder(comment);
            for (String scmChange : scmChanges) {
                sb.append("\n").append(scmChange);
            }
            return sb.toString();
        }
        return comment;
    }

    private static List<String> getScmComments(boolean wikiStyle, AbstractBuild<?, ?> build, JiraIssue jiraIssue) {
        RepositoryBrowser repoBrowser = null;
        if (build.getProject().getScm() != null) {
            repoBrowser = build.getProject().getScm().getEffectiveBrowser();
        }
        ArrayList<String> scmChanges = new ArrayList<String>();
        for (ChangeLogSet.Entry change : build.getChangeSet()) {
            if (jiraIssue != null && !StringUtils.contains((String)change.getMsg(), (String)jiraIssue.id)) continue;
            try {
                String uid = change.getAuthor().getId();
                URL url = repoBrowser == null ? null : repoBrowser.getChangeSetLink(change);
                StringBuilder scmChange = new StringBuilder();
                if (StringUtils.isNotBlank((String)uid)) {
                    scmChange.append(uid).append(" : ");
                }
                if (url != null && StringUtils.isNotBlank((String)url.toExternalForm())) {
                    if (wikiStyle) {
                        String revision = Updater.getRevision((ChangeLogSet.Entry)change);
                        if (revision != null) {
                            scmChange.append("[").append(revision);
                            scmChange.append("|");
                            scmChange.append(url.toExternalForm()).append("]");
                        } else {
                            scmChange.append("[").append(url.toExternalForm()).append("]");
                        }
                    } else {
                        scmChange.append(url.toExternalForm());
                    }
                }
                scmChange.append("\nFiles : ").append("\n");
                try {
                    for (ChangeLogSet.AffectedFile affectedFile : change.getAffectedFiles()) {
                        scmChange.append("* ").append(affectedFile.getPath()).append("\n");
                    }
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.warning("Unsupported SCM operation 'getAffectedFiles'. Fall back to getAffectedPaths.");
                    for (String affectedPath : change.getAffectedPaths()) {
                        scmChange.append("* ").append(affectedPath).append("\n");
                    }
                }
                if (scmChange.length() <= 0) continue;
                scmChanges.add(scmChange.toString());
            }
            catch (IOException e) {
                LOGGER.warning("skip failed to calculate scm repo browser link " + e.getMessage());
            }
        }
        return scmChanges;
    }

    private static String getRevision(ChangeLogSet.Entry entry) {
        String commitId = entry.getCommitId();
        if (commitId != null) {
            return commitId;
        }
        try {
            Class<?> clazz = entry.getClass();
            Method method = clazz.getMethod("getRevision", null);
            if (method == null) {
                return null;
            }
            Object revObj = method.invoke((Object)entry, (Object[])null);
            return revObj != null ? revObj.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Set<String> findIssueIdsRecursive(AbstractBuild<?, ?> build, Pattern pattern, BuildListener listener) {
        JiraCarryOverAction a;
        HashSet<String> ids = new HashSet<String>();
        Run prev = build.getPreviousBuild();
        if (prev != null && (a = (JiraCarryOverAction)prev.getAction(JiraCarryOverAction.class)) != null) {
            ids.addAll(a.getIDs());
        }
        Updater.findIssues(build, ids, (Pattern)pattern, (BuildListener)listener);
        for (AbstractBuild.DependencyChange depc : build.getDependencyChanges((AbstractBuild)build.getPreviousBuild()).values()) {
            for (AbstractBuild b : depc.getBuilds()) {
                Updater.findIssues((AbstractBuild)b, ids, (Pattern)pattern, (BuildListener)listener);
            }
        }
        return ids;
    }

    static void findIssues(AbstractBuild<?, ?> build, Set<String> ids, Pattern pattern, BuildListener listener) {
        for (ChangeLogSet.Entry change : build.getChangeSet()) {
            LOGGER.fine("Looking for JIRA ID in " + change.getMsg());
            Matcher m = pattern.matcher(change.getMsg());
            while (m.find()) {
                if (m.groupCount() >= 1) {
                    String content = StringUtils.upperCase((String)m.group(1));
                    ids.add(content);
                    continue;
                }
                listener.getLogger().println("Warning: The JIRA pattern " + pattern + " doesn't define a capturing group!");
            }
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            for (ParameterValue val : parameters.getParameters()) {
                if (!(val instanceof JiraIssueParameterValue)) continue;
                ids.add(((JiraIssueParameterValue)val).getIssue());
            }
        }
    }
}

