/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.listissuesparameter;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.listissuesparameter.JiraIssueParameterDefinition;
import hudson.plugins.jira.listissuesparameter.JiraIssueParameterValue;
import hudson.plugins.jira.soap.RemoteIssue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.rpc.ServiceException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraIssueParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 3927562542249244416L;
    private String jiraIssueFilter;

    @DataBoundConstructor
    public JiraIssueParameterDefinition(String name, String description, String jiraIssueFilter) {
        super(name, description);
        this.jiraIssueFilter = jiraIssueFilter;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new JiraIssueParameterValue(this.getName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        JiraIssueParameterValue value = (JiraIssueParameterValue)req.bindJSON(JiraIssueParameterValue.class, formData);
        return value;
    }

    public List<Result> getIssues() throws IOException, ServiceException {
        AbstractProject context = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        JiraSite site = JiraSite.get((AbstractProject)context);
        if (site == null) {
            throw new IllegalStateException("JIRA site needs to be configured in the project " + context.getFullDisplayName());
        }
        JiraSession session = site.createSession();
        if (session == null) {
            throw new IllegalStateException("Remote SOAP access for JIRA isn't configured in Hudson");
        }
        RemoteIssue[] issues = session.getIssuesFromJqlSearch(this.jiraIssueFilter);
        ArrayList<Result> issueValues = new ArrayList<Result>();
        for (RemoteIssue issue : Util.fixNull(Arrays.asList(issues))) {
            issueValues.add(new Result(issue));
        }
        return issueValues;
    }

    public String getJiraIssueFilter() {
        return this.jiraIssueFilter;
    }

    public void setJiraIssueFilter(String jiraIssueFilter) {
        this.jiraIssueFilter = jiraIssueFilter;
    }
}

