/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.jira.JiraIssue;
import hudson.plugins.jira.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraBuildAction
implements Action {
    public final AbstractBuild<?, ?> owner;
    public JiraIssue[] issues;

    public JiraBuildAction(AbstractBuild<?, ?> owner, Collection<JiraIssue> issues) {
        this.owner = owner;
        this.issues = issues.toArray(new JiraIssue[issues.size()]);
        Arrays.sort(this.issues);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.JiraBuildAction_DisplayName();
    }

    public String getUrlName() {
        return "jira";
    }

    public JiraIssue getIssue(String id) {
        for (JiraIssue issue : this.issues) {
            if (!issue.id.equals(id)) continue;
            return issue;
        }
        return null;
    }

    public void addIssues(Set<JiraIssue> issuesToBeSaved) {
        TreeSet<JiraIssue> allIssues = new TreeSet<JiraIssue>();
        allIssues.addAll(issuesToBeSaved);
        allIssues.addAll(Arrays.asList(this.issues));
        this.issues = allIssues.toArray(new JiraIssue[allIssues.size()]);
    }
}

