/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraIssue;
import hudson.plugins.jira.JiraSite;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JiraChangeLogAnnotator
extends ChangeLogAnnotator {
    private static final Logger LOGGER = Logger.getLogger(JiraChangeLogAnnotator.class.getName());

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        JiraSite site = this.getSiteForProject(build.getProject());
        if (site == null) {
            return;
        }
        JiraBuildAction a = (JiraBuildAction)build.getAction(JiraBuildAction.class);
        HashSet<JiraIssue> issuesToBeSaved = new HashSet<JiraIssue>();
        Pattern pattern = site.getIssuePattern();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Using issue pattern: " + pattern);
        }
        String plainText = text.getText();
        Matcher m = pattern.matcher(plainText);
        while (m.find()) {
            if (m.groupCount() >= 1) {
                URL url;
                String id = m.group(1);
                LOGGER.info("Annotating JIRA id: '" + id + "'");
                if (!site.existsIssue(id)) continue;
                try {
                    url = site.getUrl(id);
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                JiraIssue issue = null;
                if (a != null) {
                    issue = a.getIssue(id);
                }
                if (issue == null) {
                    try {
                        issue = site.getIssue(id);
                        if (issue != null) {
                            issuesToBeSaved.add(issue);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error getting remote issue " + id, e);
                    }
                }
                if (issue == null) {
                    text.addMarkup(m.start(1), m.end(1), "<a href='" + url + "'>", "</a>");
                    continue;
                }
                text.addMarkup(m.start(1), m.end(1), String.format("<a href='%s' tooltip='%s'>", url, Util.escape((String)issue.title)), "</a>");
                continue;
            }
            LOGGER.log(Level.WARNING, "The JIRA pattern " + pattern + " doesn't define a capturing group!");
        }
        if (!issuesToBeSaved.isEmpty()) {
            this.saveIssues(build, a, issuesToBeSaved);
        }
    }

    private void saveIssues(AbstractBuild<?, ?> build, JiraBuildAction a, Set<JiraIssue> issuesToBeSaved) {
        if (a != null) {
            a.addIssues(issuesToBeSaved);
        } else {
            JiraBuildAction action = new JiraBuildAction(build, issuesToBeSaved);
            build.addAction((Action)action);
        }
        try {
            build.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error saving updated build", e);
        }
    }

    JiraSite getSiteForProject(AbstractProject<?, ?> project) {
        return JiraSite.get(project);
    }
}

