/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraCreateReleaseNotes
extends BuildWrapper {
    public static final String DEFAULT_FILTER = "status in (Resolved, Closed)";
    private String jiraEnvironmentVariable;
    private String jiraProjectKey;
    private String jiraRelease;
    private String jiraFilter;

    @DataBoundConstructor
    public JiraCreateReleaseNotes(String jiraProjectKey, String jiraRelease, String jiraEnvironmentVariable) {
        this(jiraProjectKey, jiraRelease, jiraEnvironmentVariable, DEFAULT_FILTER);
    }

    public JiraCreateReleaseNotes(String jiraProjectKey, String jiraRelease, String jiraEnvironmentVariable, String jiraFilter) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
        this.jiraEnvironmentVariable = jiraEnvironmentVariable;
        this.jiraFilter = jiraFilter;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String realRelease = null;
        String releaseNotes = "No Release Notes";
        String realFilter = DEFAULT_FILTER;
        try {
            realRelease = build.getEnvironment((TaskListener)listener).expand(this.jiraRelease);
            if (realRelease == null || realRelease.isEmpty()) {
                throw new IllegalArgumentException("Release is Empty");
            }
            if (this.jiraFilter != null) {
                realFilter = build.getEnvironment((TaskListener)listener).expand(this.jiraFilter);
            }
            JiraSite site = JiraSite.get(build.getProject());
            releaseNotes = site.getReleaseNotesForFixVersion(this.jiraProjectKey, realRelease, realFilter);
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("Unable to generate release notes for JIRA version %s/%s: %s", new Object[]{realRelease, this.jiraProjectKey, e}));
            listener.finished(Result.FAILURE);
            return new BuildWrapper.Environment(){};
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put(this.jiraEnvironmentVariable, releaseNotes);
        final HashMap<String, String> resultVariables = envMap;
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.putAll(resultVariables);
            }
        };
    }

    public String getJiraEnvironmentVariable() {
        return this.jiraEnvironmentVariable;
    }

    public void setJiraEnvironmentVariable(String jiraEnvironmentVariable) {
        this.jiraEnvironmentVariable = jiraEnvironmentVariable;
    }

    public String getJiraRelease() {
        return this.jiraRelease;
    }

    public void setJiraRelease(String jiraRelease) {
        this.jiraRelease = jiraRelease;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public String getJiraFilter() {
        return this.jiraFilter;
    }

    public void setJiraFilter(String jiraFilter) {
        this.jiraFilter = jiraFilter;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class Descriptor
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Generate Release Notes";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

