/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraIssueMigrator
extends Notifier {
    private static final long serialVersionUID = 6909671291180081586L;
    private String jiraProjectKey;
    private String jiraRelease;
    private String jiraQuery;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraIssueMigrator(String jiraProjectKey, String jiraRelease, String jiraQuery) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
        this.jiraQuery = jiraQuery;
    }

    public String getJiraRelease() {
        return this.jiraRelease;
    }

    public void setJiraRelease(String jiraRelease) {
        this.jiraRelease = jiraRelease;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public String getJiraQuery() {
        return this.jiraQuery;
    }

    public void setJiraQuery(String jiraQuery) {
        this.jiraQuery = jiraQuery;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String realRelease = "NOT_SET";
        String realQuery = "";
        try {
            realRelease = build.getEnvironment((TaskListener)listener).expand(this.jiraRelease);
            if (realRelease == null || realRelease.isEmpty()) {
                throw new IllegalArgumentException("Release is Empty");
            }
            realQuery = build.getEnvironment((TaskListener)listener).expand(this.jiraQuery);
            if (realQuery == null || realQuery.isEmpty()) {
                throw new IllegalArgumentException("JQL query is Empty");
            }
            JiraSite site = JiraSite.get(build.getProject());
            site.migrateIssuesToFixVersion(this.jiraProjectKey, realRelease, realQuery);
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("Unable to release jira version %s/%s: %s", new Object[]{realRelease, this.jiraProjectKey, e}));
            listener.finished(Result.FAILURE);
            return false;
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JiraIssueMigrator.class);
        }

        public JiraIssueMigrator newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JiraIssueMigrator)((Object)req.bindJSON(JiraIssueMigrator.class, formData));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraReleaseVersionMigrator_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help-release-migrate.html";
        }
    }
}

