/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.xml.rpc.ServiceException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraIssueUpdateBuilder
extends Builder {
    private final String jqlSearch;
    private final String workflowActionName;
    private final String comment;

    @DataBoundConstructor
    public JiraIssueUpdateBuilder(String jqlSearch, String workflowActionName, String comment) {
        this.jqlSearch = Util.fixEmptyAndTrim((String)jqlSearch);
        this.workflowActionName = Util.fixEmptyAndTrim((String)workflowActionName);
        this.comment = Util.fixEmptyAndTrim((String)comment);
    }

    public String getJqlSearch() {
        return this.jqlSearch;
    }

    public String getWorkflowActionName() {
        return this.workflowActionName;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String realComment = Util.fixEmptyAndTrim((String)build.getEnvironment((TaskListener)listener).expand(this.comment));
        String realJql = Util.fixEmptyAndTrim((String)build.getEnvironment((TaskListener)listener).expand(this.jqlSearch));
        JiraSite site = JiraSite.get(build.getProject());
        if (site == null) {
            listener.getLogger().println(Messages.Updater_NoJiraSite());
            build.setResult(Result.FAILURE);
            return true;
        }
        listener.getLogger().println(Messages.JiraIssueUpdateBuilder_UpdatingWithAction(this.workflowActionName));
        listener.getLogger().println("[JIRA] JQL: " + realJql);
        try {
            if (!site.progressMatchingIssues(realJql, this.workflowActionName, realComment, listener.getLogger())) {
                listener.getLogger().println(Messages.JiraIssueUpdateBuilder_SomeIssuesFailed());
                build.setResult(Result.UNSTABLE);
            }
        }
        catch (ServiceException e) {
            listener.getLogger().println(Messages.JiraIssueUpdateBuilder_Failed());
            e.printStackTrace(listener.getLogger());
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckJqlSearch(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.JiraIssueUpdateBuilder_NoJqlSearch());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWorkflowActionName(@QueryParameter String value) {
            if (Util.fixNull((String)value).trim().length() == 0) {
                return FormValidation.error((String)Messages.JiraIssueUpdateBuilder_NoWorkflowAction());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> klass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraIssueUpdateBuilder_DisplayName();
        }
    }
}

